/*
 * Decompiled with CFR 0.152.
 */
package nl.basjes.collections.prefixmap;

import java.io.Serializable;
import nl.basjes.collections.PrefixMap;
import nl.basjes.collections.prefixmap.PrefixTrie;
import nl.basjes.collections.prefixmap.StringPrefixTrie;

public class StringPrefixMap<V extends Serializable>
implements PrefixMap<V>,
Serializable {
    private PrefixTrie<V> prefixTrie;
    private int size = 0;

    protected StringPrefixMap(PrefixTrie<V> prefixTrie) {
        this.prefixTrie = prefixTrie;
    }

    public StringPrefixMap(boolean caseSensitive) {
        this.prefixTrie = new StringPrefixTrie(caseSensitive);
    }

    @Override
    public boolean containsPrefix(String prefix) {
        return this.prefixTrie.containsPrefix(prefix);
    }

    @Override
    public V put(String prefix, V value) {
        V previousValue = this.prefixTrie.add(prefix, value);
        if (previousValue == null) {
            ++this.size;
        }
        return previousValue;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        this.prefixTrie.clear();
        this.size = 0;
    }

    @Override
    public V remove(String prefix) {
        V oldValue = this.prefixTrie.remove(prefix);
        if (oldValue != null) {
            --this.size;
        }
        return oldValue;
    }

    @Override
    public V getShortestMatch(String input) {
        return this.prefixTrie.getShortestMatch(input);
    }

    @Override
    public V getLongestMatch(String input) {
        return this.prefixTrie.getLongestMatch(input);
    }
}

