/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher.database;

import androidx.sqlite.db.SupportSQLiteDatabase;
import androidx.sqlite.db.SupportSQLiteOpenHelper;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteDatabaseHook;
import net.sqlcipher.database.SQLiteException;
import net.sqlcipher.database.SQLiteOpenHelper;

public class SupportHelper
implements SupportSQLiteOpenHelper {
    private SQLiteOpenHelper standardHelper;
    private byte[] passphrase;
    private final boolean clearPassphrase;

    SupportHelper(final SupportSQLiteOpenHelper.Configuration configuration, byte[] passphrase, SQLiteDatabaseHook hook, boolean clearPassphrase) {
        SQLiteDatabase.loadLibs(configuration.context);
        this.passphrase = passphrase;
        this.clearPassphrase = clearPassphrase;
        this.standardHelper = new SQLiteOpenHelper(configuration.context, configuration.name, null, configuration.callback.version, hook){

            @Override
            public void onCreate(SQLiteDatabase db) {
                configuration.callback.onCreate((SupportSQLiteDatabase)db);
            }

            @Override
            public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
                configuration.callback.onUpgrade((SupportSQLiteDatabase)db, oldVersion, newVersion);
            }

            @Override
            public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
                configuration.callback.onDowngrade((SupportSQLiteDatabase)db, oldVersion, newVersion);
            }

            @Override
            public void onOpen(SQLiteDatabase db) {
                configuration.callback.onOpen((SupportSQLiteDatabase)db);
            }

            @Override
            public void onConfigure(SQLiteDatabase db) {
                configuration.callback.onConfigure((SupportSQLiteDatabase)db);
            }
        };
    }

    public String getDatabaseName() {
        return this.standardHelper.getDatabaseName();
    }

    public void setWriteAheadLoggingEnabled(boolean enabled) {
        this.standardHelper.setWriteAheadLoggingEnabled(enabled);
    }

    public SupportSQLiteDatabase getWritableDatabase() {
        SQLiteDatabase result;
        try {
            result = this.standardHelper.getWritableDatabase(this.passphrase);
        }
        catch (SQLiteException ex) {
            if (this.passphrase != null) {
                boolean isCleared = true;
                for (byte b : this.passphrase) {
                    isCleared = isCleared && b == 0;
                }
                if (isCleared) {
                    throw new IllegalStateException("The passphrase appears to be cleared. This happens bydefault the first time you use the factory to open a database, so we can remove thecleartext passphrase from memory. If you close the database yourself, please use afresh SupportFactory to reopen it. If something else (e.g., Room) closed thedatabase, and you cannot control that, use SupportFactory boolean constructor option to opt out of the automatic password clearing step. See the project README for more information.", ex);
                }
            }
            throw ex;
        }
        if (this.clearPassphrase && this.passphrase != null) {
            for (int i = 0; i < this.passphrase.length; ++i) {
                this.passphrase[i] = 0;
            }
        }
        return result;
    }

    public SupportSQLiteDatabase getReadableDatabase() {
        return this.getWritableDatabase();
    }

    public void close() {
        this.standardHelper.close();
    }
}

