/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher.database;

import android.util.Log;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteDebug;

class SQLiteCompiledSql {
    private static final String TAG = "SQLiteCompiledSql";
    SQLiteDatabase mDatabase;
    long nHandle = 0L;
    long nStatement = 0L;
    private String mSqlStmt = null;
    private boolean mInUse = false;

    SQLiteCompiledSql(SQLiteDatabase db, String sql) {
        if (!db.isOpen()) {
            throw new IllegalStateException("database " + db.getPath() + " already closed");
        }
        this.mDatabase = db;
        this.mSqlStmt = sql;
        this.nHandle = db.mNativeHandle;
        this.compile(sql, true);
    }

    private void compile(String sql, boolean forceCompilation) {
        if (!this.mDatabase.isOpen()) {
            throw new IllegalStateException("database " + this.mDatabase.getPath() + " already closed");
        }
        if (forceCompilation) {
            this.mDatabase.lock();
            try {
                this.native_compile(sql);
            }
            finally {
                this.mDatabase.unlock();
            }
        }
    }

    void releaseSqlStatement() {
        if (this.nStatement != 0L) {
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v((String)TAG, (String)("closed and deallocated DbObj (id#" + this.nStatement + ")"));
            }
            try {
                this.mDatabase.lock();
                this.native_finalize();
                this.nStatement = 0L;
            }
            finally {
                this.mDatabase.unlock();
            }
        }
    }

    synchronized boolean acquire() {
        if (this.mInUse) {
            return false;
        }
        this.mInUse = true;
        if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
            Log.v((String)TAG, (String)("Acquired DbObj (id#" + this.nStatement + ") from DB cache"));
        }
        return true;
    }

    synchronized void release() {
        if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
            Log.v((String)TAG, (String)("Released DbObj (id#" + this.nStatement + ") back to DB cache"));
        }
        this.mInUse = false;
    }

    protected void finalize() throws Throwable {
        try {
            if (this.nStatement == 0L) {
                return;
            }
            if (SQLiteDebug.DEBUG_ACTIVE_CURSOR_FINALIZATION) {
                Log.v((String)TAG, (String)("** warning ** Finalized DbObj (id#" + this.nStatement + ")"));
            }
            this.releaseSqlStatement();
        }
        finally {
            super.finalize();
        }
    }

    private final native void native_compile(String var1);

    private final native void native_finalize();
}

