/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher;

import android.content.ContentResolver;
import android.database.CharArrayBuffer;
import android.database.ContentObservable;
import android.database.ContentObserver;
import android.database.CrossProcessCursor;
import android.database.DataSetObservable;
import android.database.DataSetObserver;
import android.net.Uri;
import android.os.Bundle;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Map;
import net.sqlcipher.Cursor;
import net.sqlcipher.CursorIndexOutOfBoundsException;
import net.sqlcipher.CursorWindow;
import net.sqlcipher.DatabaseUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCursor
implements CrossProcessCursor,
Cursor {
    private static final String TAG = "Cursor";
    DataSetObservable mDataSetObservable = new DataSetObservable();
    ContentObservable mContentObservable = new ContentObservable();
    private Bundle mExtras = Bundle.EMPTY;
    protected HashMap<Long, Map<String, Object>> mUpdatedRows;
    protected int mRowIdColumnIndex = -1;
    protected int mPos = -1;
    protected Long mCurrentRowID = null;
    protected ContentResolver mContentResolver;
    protected boolean mClosed = false;
    private Uri mNotifyUri;
    private ContentObserver mSelfObserver;
    private final Object mSelfObserverLock = new Object();
    private boolean mSelfObserverRegistered;

    public abstract int getCount();

    public abstract String[] getColumnNames();

    public abstract String getString(int var1);

    public abstract short getShort(int var1);

    public abstract int getInt(int var1);

    public abstract long getLong(int var1);

    public abstract float getFloat(int var1);

    public abstract double getDouble(int var1);

    public abstract boolean isNull(int var1);

    @Override
    public abstract int getType(int var1);

    public byte[] getBlob(int column) {
        throw new UnsupportedOperationException("getBlob is not supported");
    }

    public CursorWindow getWindow() {
        return null;
    }

    public int getColumnCount() {
        return this.getColumnNames().length;
    }

    public void deactivate() {
        this.deactivateInternal();
    }

    public void deactivateInternal() {
        if (this.mSelfObserver != null) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            this.mSelfObserverRegistered = false;
        }
        this.mDataSetObservable.notifyInvalidated();
    }

    public boolean requery() {
        if (this.mSelfObserver != null && !this.mSelfObserverRegistered) {
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver);
            this.mSelfObserverRegistered = true;
        }
        this.mDataSetObservable.notifyChanged();
        return true;
    }

    public boolean isClosed() {
        return this.mClosed;
    }

    public void close() {
        this.mClosed = true;
        this.mContentObservable.unregisterAll();
        this.deactivateInternal();
    }

    public boolean commitUpdates(Map<? extends Long, ? extends Map<String, Object>> values) {
        return false;
    }

    public boolean deleteRow() {
        return false;
    }

    public boolean onMove(int oldPosition, int newPosition) {
        return true;
    }

    public void copyStringToBuffer(int columnIndex, CharArrayBuffer buffer) {
        String result = this.getString(columnIndex);
        if (result != null) {
            char[] data = buffer.data;
            if (data == null || data.length < result.length()) {
                buffer.data = result.toCharArray();
            } else {
                result.getChars(0, result.length(), data, 0);
            }
            buffer.sizeCopied = result.length();
        } else {
            buffer.sizeCopied = 0;
        }
    }

    public AbstractCursor() {
        this.mUpdatedRows = new HashMap();
    }

    public final int getPosition() {
        return this.mPos;
    }

    public final boolean moveToPosition(int position) {
        int count = this.getCount();
        if (position >= count) {
            this.mPos = count;
            return false;
        }
        if (position < 0) {
            this.mPos = -1;
            return false;
        }
        if (position == this.mPos) {
            return true;
        }
        boolean result = this.onMove(this.mPos, position);
        if (!result) {
            this.mPos = -1;
        } else {
            this.mPos = position;
            if (this.mRowIdColumnIndex != -1) {
                this.mCurrentRowID = this.getLong(this.mRowIdColumnIndex);
            }
        }
        return result;
    }

    public void fillWindow(int position, android.database.CursorWindow window) {
        DatabaseUtils.cursorFillWindow(this, position, window);
    }

    public final boolean move(int offset) {
        return this.moveToPosition(this.mPos + offset);
    }

    public final boolean moveToFirst() {
        return this.moveToPosition(0);
    }

    public final boolean moveToLast() {
        return this.moveToPosition(this.getCount() - 1);
    }

    public final boolean moveToNext() {
        return this.moveToPosition(this.mPos + 1);
    }

    public final boolean moveToPrevious() {
        return this.moveToPosition(this.mPos - 1);
    }

    public final boolean isFirst() {
        return this.mPos == 0 && this.getCount() != 0;
    }

    public final boolean isLast() {
        int cnt = this.getCount();
        return this.mPos == cnt - 1 && cnt != 0;
    }

    public final boolean isBeforeFirst() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.mPos == -1;
    }

    public final boolean isAfterLast() {
        if (this.getCount() == 0) {
            return true;
        }
        return this.mPos == this.getCount();
    }

    public int getColumnIndex(String columnName) {
        int periodIndex = columnName.lastIndexOf(46);
        if (periodIndex != -1) {
            Exception e = new Exception();
            Log.e((String)TAG, (String)("requesting column name with table name -- " + columnName), (Throwable)e);
            columnName = columnName.substring(periodIndex + 1);
        }
        String[] columnNames = this.getColumnNames();
        int length = columnNames.length;
        for (int i = 0; i < length; ++i) {
            if (!columnNames[i].equalsIgnoreCase(columnName)) continue;
            return i;
        }
        return -1;
    }

    public int getColumnIndexOrThrow(String columnName) {
        int index = this.getColumnIndex(columnName);
        if (index < 0) {
            throw new IllegalArgumentException("column '" + columnName + "' does not exist");
        }
        return index;
    }

    public String getColumnName(int columnIndex) {
        return this.getColumnNames()[columnIndex];
    }

    public boolean updateBlob(int columnIndex, byte[] value) {
        return this.update(columnIndex, value);
    }

    public boolean updateString(int columnIndex, String value) {
        return this.update(columnIndex, value);
    }

    public boolean updateShort(int columnIndex, short value) {
        return this.update(columnIndex, value);
    }

    public boolean updateInt(int columnIndex, int value) {
        return this.update(columnIndex, value);
    }

    public boolean updateLong(int columnIndex, long value) {
        return this.update(columnIndex, value);
    }

    public boolean updateFloat(int columnIndex, float value) {
        return this.update(columnIndex, Float.valueOf(value));
    }

    public boolean updateDouble(int columnIndex, double value) {
        return this.update(columnIndex, value);
    }

    public boolean updateToNull(int columnIndex) {
        return this.update(columnIndex, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean update(int columnIndex, Object obj) {
        if (!this.supportsUpdates()) {
            return false;
        }
        Long rowid = this.getLong(this.mRowIdColumnIndex);
        if (rowid == null) {
            throw new IllegalStateException("null rowid. mRowIdColumnIndex = " + this.mRowIdColumnIndex);
        }
        HashMap<Long, Map<String, Object>> hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            Map<String, Object> row = this.mUpdatedRows.get(rowid);
            if (row == null) {
                row = new HashMap<String, Object>();
                this.mUpdatedRows.put(rowid, row);
            }
            row.put(this.getColumnNames()[columnIndex], obj);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasUpdates() {
        HashMap<Long, Map<String, Object>> hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            return this.mUpdatedRows.size() > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abortUpdates() {
        HashMap<Long, Map<String, Object>> hashMap = this.mUpdatedRows;
        synchronized (hashMap) {
            this.mUpdatedRows.clear();
        }
    }

    public boolean commitUpdates() {
        return this.commitUpdates(null);
    }

    public boolean supportsUpdates() {
        return this.mRowIdColumnIndex != -1;
    }

    public void registerContentObserver(ContentObserver observer) {
        this.mContentObservable.registerObserver(observer);
    }

    public void unregisterContentObserver(ContentObserver observer) {
        if (!this.mClosed) {
            this.mContentObservable.unregisterObserver((Object)observer);
        }
    }

    protected void notifyDataSetChange() {
        this.mDataSetObservable.notifyChanged();
    }

    protected DataSetObservable getDataSetObservable() {
        return this.mDataSetObservable;
    }

    public void registerDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.registerObserver((Object)observer);
    }

    public void unregisterDataSetObserver(DataSetObserver observer) {
        this.mDataSetObservable.unregisterObserver((Object)observer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onChange(boolean selfChange) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mContentObservable.dispatchChange(selfChange);
            if (this.mNotifyUri != null && selfChange) {
                this.mContentResolver.notifyChange(this.mNotifyUri, this.mSelfObserver);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setNotificationUri(ContentResolver cr, Uri notifyUri) {
        Object object = this.mSelfObserverLock;
        synchronized (object) {
            this.mNotifyUri = notifyUri;
            this.mContentResolver = cr;
            if (this.mSelfObserver != null) {
                this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
            }
            this.mSelfObserver = new SelfContentObserver(this);
            this.mContentResolver.registerContentObserver(this.mNotifyUri, true, this.mSelfObserver);
            this.mSelfObserverRegistered = true;
        }
    }

    public Uri getNotificationUri() {
        return this.mNotifyUri;
    }

    public boolean getWantsAllOnMoveCalls() {
        return false;
    }

    public void setExtras(Bundle extras) {
        this.mExtras = extras == null ? Bundle.EMPTY : extras;
    }

    public Bundle getExtras() {
        return this.mExtras;
    }

    public Bundle respond(Bundle extras) {
        return Bundle.EMPTY;
    }

    protected boolean isFieldUpdated(int columnIndex) {
        Map<String, Object> updates;
        return this.mRowIdColumnIndex != -1 && this.mUpdatedRows.size() > 0 && (updates = this.mUpdatedRows.get(this.mCurrentRowID)) != null && updates.containsKey(this.getColumnNames()[columnIndex]);
    }

    protected Object getUpdatedField(int columnIndex) {
        Map<String, Object> updates = this.mUpdatedRows.get(this.mCurrentRowID);
        return updates.get(this.getColumnNames()[columnIndex]);
    }

    protected void checkPosition() {
        if (-1 == this.mPos || this.getCount() == this.mPos) {
            throw new CursorIndexOutOfBoundsException(this.mPos, this.getCount());
        }
    }

    protected void finalize() {
        if (this.mSelfObserver != null && this.mSelfObserverRegistered) {
            this.mContentResolver.unregisterContentObserver(this.mSelfObserver);
        }
    }

    protected static class SelfContentObserver
    extends ContentObserver {
        WeakReference<AbstractCursor> mCursor;

        public SelfContentObserver(AbstractCursor cursor) {
            super(null);
            this.mCursor = new WeakReference<AbstractCursor>(cursor);
        }

        public boolean deliverSelfNotifications() {
            return false;
        }

        public void onChange(boolean selfChange) {
            AbstractCursor cursor = (AbstractCursor)this.mCursor.get();
            if (cursor != null) {
                cursor.onChange(false);
            }
        }
    }
}

