/*
 * Decompiled with CFR 0.152.
 */
package net.sqlcipher;

import android.util.Log;
import java.io.File;
import net.sqlcipher.DatabaseErrorHandler;
import net.sqlcipher.database.SQLiteDatabase;

public final class DefaultDatabaseErrorHandler
implements DatabaseErrorHandler {
    private static final String TAG = "DefaultDatabaseErrorHandler";

    public void onCorruption(SQLiteDatabase dbObj) {
        Log.e((String)TAG, (String)("Corruption reported by sqlite on database, deleting: " + dbObj.getPath()));
        if (dbObj.isOpen()) {
            Log.e((String)TAG, (String)"Database object for corrupted database is already open, closing");
            try {
                dbObj.close();
            }
            catch (Exception e) {
                Log.e((String)TAG, (String)"Exception closing Database object for corrupted database, ignored", (Throwable)e);
            }
        }
        this.deleteDatabaseFile(dbObj.getPath());
    }

    private void deleteDatabaseFile(String fileName) {
        if (fileName.equalsIgnoreCase(":memory:") || fileName.trim().length() == 0) {
            return;
        }
        Log.e((String)TAG, (String)("deleting the database file: " + fileName));
        try {
            new File(fileName).delete();
        }
        catch (Exception e) {
            Log.w((String)TAG, (String)("delete failed: " + e.getMessage()));
        }
    }
}

