/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.time.YearMonth;
import java.time.chrono.IsoChronology;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import net.time4j.CalendarUnit;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.SystemClock;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.BridgeChronology;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.Converter;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.ThreetenAdapter;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.PatternType;
import net.time4j.range.Boundary;
import net.time4j.range.FixedCalendarInterval;
import net.time4j.range.Months;
import net.time4j.range.SPX;
import net.time4j.range.Years;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="iso8601")
public final class CalendarMonth
extends FixedCalendarInterval<CalendarMonth>
implements ThreetenAdapter,
LocalizedPatternSupport {
    @FormattableElement(format="u")
    public static final ChronoElement<Integer> YEAR = PlainDate.YEAR;
    @FormattableElement(format="M", standalone="L")
    public static final ChronoElement<Month> MONTH_OF_YEAR = PlainDate.MONTH_OF_YEAR;
    public static final ChronoElement<Integer> MONTH_AS_NUMBER = PlainDate.MONTH_AS_NUMBER;
    private static final Chronology<CalendarMonth> ENGINE = Chronology.Builder.setUp(CalendarMonth.class, (ChronoMerger)new Merger()).appendElement(YEAR, (ElementRule)new YearRule()).appendElement(MONTH_OF_YEAR, (ElementRule)new EnumMonthRule()).appendElement(MONTH_AS_NUMBER, (ElementRule)new IntMonthRule()).build();
    private static final ChronoFormatter<CalendarMonth> PARSER = ChronoFormatter.setUp(CalendarMonth.chronology(), (Locale)Locale.ROOT).addPattern("uuuu-MM|uuuuMM", PatternType.CLDR).build();
    private static final Chronology<YearMonth> THREETEN;
    private static final long serialVersionUID = -5097347953941448741L;
    private final transient int year;
    private final transient Month month;
    private final transient Boundary<PlainDate> start;
    private final transient Boundary<PlainDate> end;

    private CalendarMonth(int n, Month month) {
        if (n < -999999999 || n > 999999999) {
            throw new IllegalArgumentException("Year out of bounds: " + n);
        }
        if (month == null) {
            throw new NullPointerException("Missing month of calendar year.");
        }
        this.year = n;
        this.month = month;
        this.start = Boundary.ofClosed(PlainDate.of((int)this.year, (Month)month, (int)1));
        this.end = Boundary.ofClosed(PlainDate.of((int)n, (Month)month, (int)GregorianMath.getLengthOfMonth((int)n, (int)month.getValue())));
    }

    public static CalendarMonth of(int n, int n2) {
        return new CalendarMonth(n, Month.valueOf((int)n2));
    }

    public static CalendarMonth of(int n, Month month) {
        return new CalendarMonth(n, month);
    }

    public static CalendarMonth nowInSystemTime() {
        return (CalendarMonth)SystemClock.inLocalView().now(CalendarMonth.chronology());
    }

    public PlainDate atDayOfMonth(int n) {
        if (n == 1) {
            return this.start.getTemporal();
        }
        return (PlainDate)this.start.getTemporal().with((ChronoElement)PlainDate.DAY_OF_MONTH, n);
    }

    public PlainDate atEndOfMonth() {
        return this.end.getTemporal();
    }

    public int getYear() {
        return this.year;
    }

    public Month getMonth() {
        return this.month;
    }

    @Override
    public Boundary<PlainDate> getStart() {
        return this.start;
    }

    @Override
    public Boundary<PlainDate> getEnd() {
        return this.end;
    }

    @Override
    public boolean contains(PlainDate plainDate) {
        return plainDate.getYear() == this.year && plainDate.getMonth() == this.month.getValue();
    }

    @Override
    public boolean isAfter(PlainDate plainDate) {
        return this.start.getTemporal().isAfter((CalendarDate)plainDate);
    }

    @Override
    public boolean isBefore(PlainDate plainDate) {
        return this.end.getTemporal().isBefore((CalendarDate)plainDate);
    }

    public int length() {
        return GregorianMath.getLengthOfMonth((int)this.year, (int)this.month.getValue());
    }

    public static CalendarMonth from(GregorianDate gregorianDate) {
        PlainDate plainDate = PlainDate.from((GregorianDate)gregorianDate);
        return CalendarMonth.of(plainDate.getYear(), plainDate.getMonth());
    }

    public static CalendarMonth from(YearMonth yearMonth) {
        return CalendarMonth.of(yearMonth.getYear(), yearMonth.getMonthValue());
    }

    public CalendarMonth plus(Years<CalendarUnit> years) {
        if (years.isEmpty()) {
            return this;
        }
        return CalendarMonth.of(MathUtils.safeAdd((int)this.year, (int)years.getAmount()), this.month);
    }

    public CalendarMonth plus(Months months) {
        if (months.isEmpty()) {
            return this;
        }
        long l = (long)this.year * 12L + (long)this.month.getValue() - 1L + (long)months.getAmount();
        int n = MathUtils.safeCast((long)MathUtils.floorDivide((long)l, (int)12));
        Month month = Month.valueOf((int)(MathUtils.floorModulo((long)l, (int)12) + 1));
        return CalendarMonth.of(n, month);
    }

    public CalendarMonth minus(Years<CalendarUnit> years) {
        if (years.isEmpty()) {
            return this;
        }
        return CalendarMonth.of(MathUtils.safeSubtract((int)this.year, (int)years.getAmount()), this.month);
    }

    public CalendarMonth minus(Months months) {
        if (months.isEmpty()) {
            return this;
        }
        long l = (long)this.year * 12L + (long)this.month.getValue() - 1L - (long)months.getAmount();
        int n = MathUtils.safeCast((long)MathUtils.floorDivide((long)l, (int)12));
        Month month = Month.valueOf((int)(MathUtils.floorModulo((long)l, (int)12) + 1));
        return CalendarMonth.of(n, month);
    }

    @Override
    public int compareTo(CalendarMonth calendarMonth) {
        if (this.year < calendarMonth.year) {
            return -1;
        }
        if (this.year > calendarMonth.year) {
            return 1;
        }
        return this.month.compareTo((Enum)calendarMonth.month);
    }

    @Override
    public Iterator<PlainDate> iterator() {
        return new Iter();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CalendarMonth) {
            CalendarMonth calendarMonth = (CalendarMonth)object;
            return this.year == calendarMonth.year && this.month == calendarMonth.month;
        }
        return false;
    }

    public int hashCode() {
        return this.year ^ this.month.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        CalendarMonth.formatYear(stringBuilder, this.year);
        stringBuilder.append('-');
        int n = this.month.getValue();
        if (n < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(n);
        return stringBuilder.toString();
    }

    public static CalendarMonth parseISO(String string) throws ParseException {
        return (CalendarMonth)PARSER.parse((CharSequence)string);
    }

    public YearMonth toTemporalAccessor() {
        return YearMonth.of(this.year, this.month.getValue());
    }

    public static Chronology<CalendarMonth> chronology() {
        return ENGINE;
    }

    public static Chronology<YearMonth> threeten() {
        return THREETEN;
    }

    protected Chronology<CalendarMonth> getChronology() {
        return ENGINE;
    }

    protected CalendarMonth getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX(this, 38);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        Converter<YearMonth, CalendarMonth> converter = new Converter<YearMonth, CalendarMonth>(){

            public CalendarMonth translate(YearMonth yearMonth) {
                return CalendarMonth.of(yearMonth.getYear(), yearMonth.getMonthValue());
            }

            public YearMonth from(CalendarMonth calendarMonth) {
                return YearMonth.of(calendarMonth.year, calendarMonth.month.getValue());
            }

            public Class<YearMonth> getSourceType() {
                return YearMonth.class;
            }
        };
        THREETEN = new BridgeChronology((Converter)converter, ENGINE);
    }

    private class Iter
    implements Iterator<PlainDate> {
        private PlainDate current;

        private Iter() {
            this.current = (PlainDate)CalendarMonth.this.start.getTemporal();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public PlainDate next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            PlainDate plainDate = this.current;
            PlainDate plainDate2 = plainDate.plus(1L, CalendarUnit.DAYS);
            this.current = plainDate2.getMonth() == plainDate.getMonth() ? plainDate2 : null;
            return plainDate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class IntMonthRule
    implements IntElementRule<CalendarMonth> {
        private IntMonthRule() {
        }

        public Integer getValue(CalendarMonth calendarMonth) {
            return calendarMonth.month.getValue();
        }

        public Integer getMinimum(CalendarMonth calendarMonth) {
            return 1;
        }

        public Integer getMaximum(CalendarMonth calendarMonth) {
            return 12;
        }

        public boolean isValid(CalendarMonth calendarMonth, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= 1 && n2 <= 12;
        }

        public CalendarMonth withValue(CalendarMonth calendarMonth, Integer n, boolean bl) {
            if (this.isValid(calendarMonth, n)) {
                return CalendarMonth.of(calendarMonth.year, n);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }

        public ChronoElement<?> getChildAtFloor(CalendarMonth calendarMonth) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(CalendarMonth calendarMonth) {
            return null;
        }

        public int getInt(CalendarMonth calendarMonth) {
            return calendarMonth.month.getValue();
        }

        public boolean isValid(CalendarMonth calendarMonth, int n) {
            return n >= 1 && n <= 12;
        }

        public CalendarMonth withValue(CalendarMonth calendarMonth, int n, boolean bl) {
            if (this.isValid(calendarMonth, n)) {
                return CalendarMonth.of(calendarMonth.year, n);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }
    }

    private static class EnumMonthRule
    implements ElementRule<CalendarMonth, Month> {
        private EnumMonthRule() {
        }

        public Month getValue(CalendarMonth calendarMonth) {
            return calendarMonth.month;
        }

        public Month getMinimum(CalendarMonth calendarMonth) {
            return Month.JANUARY;
        }

        public Month getMaximum(CalendarMonth calendarMonth) {
            return Month.DECEMBER;
        }

        public boolean isValid(CalendarMonth calendarMonth, Month month) {
            return month != null;
        }

        public CalendarMonth withValue(CalendarMonth calendarMonth, Month month, boolean bl) {
            if (this.isValid(calendarMonth, month)) {
                return CalendarMonth.of(calendarMonth.year, month);
            }
            throw new IllegalArgumentException("Not valid: " + month);
        }

        public ChronoElement<?> getChildAtFloor(CalendarMonth calendarMonth) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(CalendarMonth calendarMonth) {
            return null;
        }
    }

    private static class YearRule
    implements IntElementRule<CalendarMonth> {
        private YearRule() {
        }

        public Integer getValue(CalendarMonth calendarMonth) {
            return calendarMonth.year;
        }

        public Integer getMinimum(CalendarMonth calendarMonth) {
            return -999999999;
        }

        public Integer getMaximum(CalendarMonth calendarMonth) {
            return 999999999;
        }

        public boolean isValid(CalendarMonth calendarMonth, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= -999999999 && n2 <= 999999999;
        }

        public CalendarMonth withValue(CalendarMonth calendarMonth, Integer n, boolean bl) {
            if (this.isValid(calendarMonth, n)) {
                return CalendarMonth.of((int)n, calendarMonth.month);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }

        public ChronoElement<?> getChildAtFloor(CalendarMonth calendarMonth) {
            return MONTH_OF_YEAR;
        }

        public ChronoElement<?> getChildAtCeiling(CalendarMonth calendarMonth) {
            return MONTH_OF_YEAR;
        }

        public int getInt(CalendarMonth calendarMonth) {
            return calendarMonth.year;
        }

        public boolean isValid(CalendarMonth calendarMonth, int n) {
            return n >= -999999999 && n <= 999999999;
        }

        public CalendarMonth withValue(CalendarMonth calendarMonth, int n, boolean bl) {
            if (this.isValid(calendarMonth, n)) {
                return CalendarMonth.of(n, calendarMonth.month);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }
    }

    private static class Merger
    implements ChronoMerger<CalendarMonth> {
        private Merger() {
        }

        public CalendarMonth createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                timezone = Timezone.of((TZID)((TZID)attributeQuery.get(Attributes.TIMEZONE_ID)));
            } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
                timezone = Timezone.ofSystem();
            } else {
                return null;
            }
            PlainDate plainDate = Moment.from((UnixTime)timeSource.currentTime()).toZonalTimestamp(timezone.getID()).toDate();
            return CalendarMonth.of(plainDate.getYear(), Month.valueOf((int)plainDate.getMonth()));
        }

        public CalendarMonth createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        public CalendarMonth createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = chronoEntity.getInt(YEAR);
            if (n >= -999999999 && n <= 999999999) {
                int n2 = chronoEntity.getInt((ChronoElement)PlainDate.MONTH_AS_NUMBER);
                if (n2 == Integer.MIN_VALUE && chronoEntity.contains(MONTH_OF_YEAR)) {
                    n2 = ((Month)chronoEntity.get(MONTH_OF_YEAR)).getValue();
                }
                if (n2 != Integer.MIN_VALUE) {
                    return CalendarMonth.of(n, Month.valueOf((int)n2));
                }
            } else if (n > Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)("Year out of bounds: " + n));
            }
            return null;
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            Map map = CalendarText.getIsoInstance((Locale)locale).getTextForms();
            String string = null;
            switch (displayStyle.getStyleValue()) {
                case 0: {
                    string = "F_yMMMM";
                    break;
                }
                case 1: {
                    string = "F_yMMM";
                    break;
                }
                case 2: {
                    string = "F_yMM";
                    break;
                }
                case 3: {
                    string = "F_yM";
                }
            }
            String string2 = Merger.getFormatPattern(map, string);
            return string2 == null ? "uuuu-MM" : string2;
        }

        private static String getFormatPattern(Map<String, String> map, String string) {
            if (map.containsKey(string)) {
                return map.get(string);
            }
            switch (string) {
                case "F_yMMMM": {
                    return Merger.getFormatPattern(map, "F_yMMM");
                }
                case "F_yMMM": {
                    return Merger.getFormatPattern(map, "F_yMM");
                }
                case "F_yMM": {
                    return Merger.getFormatPattern(map, "F_yM");
                }
            }
            return null;
        }

        public CalendarMonth createFrom(TemporalAccessor temporalAccessor, AttributeQuery attributeQuery) {
            if (temporalAccessor.query(TemporalQueries.chronology()) == IsoChronology.INSTANCE && temporalAccessor.isSupported(ChronoField.YEAR) && temporalAccessor.isSupported(ChronoField.MONTH_OF_YEAR)) {
                Leniency leniency = (Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART);
                int n = temporalAccessor.get(ChronoField.YEAR);
                int n2 = temporalAccessor.get(ChronoField.MONTH_OF_YEAR);
                if (leniency.isLax()) {
                    PlainDate plainDate = PlainDate.of((int)n, (int)1, (int)1);
                    plainDate = (PlainDate)plainDate.with((ChronoOperator)PlainDate.MONTH_AS_NUMBER.setLenient((Number)n2));
                    return CalendarMonth.of(plainDate.getYear(), plainDate.getMonth());
                }
                return CalendarMonth.of(n, n2);
            }
            return null;
        }
    }
}

