/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.time4j.Moment;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Quarter;
import net.time4j.engine.TimeLine;
import net.time4j.range.Boundary;
import net.time4j.range.CalendarMonth;
import net.time4j.range.CalendarQuarter;
import net.time4j.range.CalendarWeek;
import net.time4j.range.CalendarYear;
import net.time4j.range.ChronoInterval;
import net.time4j.range.ClockInterval;
import net.time4j.range.ClockWindows;
import net.time4j.range.DateInterval;
import net.time4j.range.DateWindows;
import net.time4j.range.GenericWindows;
import net.time4j.range.IntervalCollection;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.MachineTime;
import net.time4j.range.MomentInterval;
import net.time4j.range.MomentWindows;
import net.time4j.range.SimpleInterval;
import net.time4j.range.TimestampInterval;
import net.time4j.range.TimestampWindows;
import net.time4j.scale.TimeScale;

final class SPX
implements Externalizable {
    static final int DATE_TYPE = 32;
    static final int TIME_TYPE = 33;
    static final int TIMESTAMP_TYPE = 34;
    static final int MOMENT_TYPE = 35;
    static final int YEAR_TYPE = 36;
    static final int QUARTER_TYPE = 37;
    static final int MONTH_TYPE = 38;
    static final int WEEK_TYPE = 39;
    static final int DATE_WINDOW_ID = 40;
    static final int CLOCK_WINDOW_ID = 41;
    static final int TIMESTAMP_WINDOW_ID = 42;
    static final int MOMENT_WINDOW_ID = 43;
    static final int GENERIC_WINDOW_ID = 44;
    static final int BOUNDARY_TYPE = 57;
    static final int MACHINE_TIME_TYPE = 7;
    private static final long serialVersionUID = 1L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        if (this.type == 57) {
            Boundary boundary = (Boundary)this.obj;
            int n = 228;
            if (boundary.equals(Boundary.infinitePast())) {
                objectOutput.writeByte(n |= 1);
            } else if (boundary.equals(Boundary.infiniteFuture())) {
                objectOutput.writeByte(n |= 2);
            } else {
                objectOutput.writeByte(n);
                objectOutput.writeByte(boundary.isOpen() ? 1 : 0);
                objectOutput.writeObject(boundary.getTemporal());
            }
        } else {
            int n = this.type << 2;
            objectOutput.writeByte(n);
            switch (this.type) {
                case 32: 
                case 33: 
                case 34: 
                case 35: {
                    ChronoInterval chronoInterval = (ChronoInterval)this.obj;
                    SPX.writeBoundary(chronoInterval.getStart(), objectOutput);
                    SPX.writeBoundary(chronoInterval.getEnd(), objectOutput);
                    break;
                }
                case 36: {
                    CalendarYear calendarYear = (CalendarYear)this.obj;
                    objectOutput.writeInt(calendarYear.getValue());
                    break;
                }
                case 37: {
                    CalendarQuarter calendarQuarter = (CalendarQuarter)this.obj;
                    objectOutput.writeInt(calendarQuarter.getYear());
                    objectOutput.writeInt(calendarQuarter.getQuarter().getValue());
                    break;
                }
                case 38: {
                    CalendarMonth calendarMonth = (CalendarMonth)this.obj;
                    objectOutput.writeInt(calendarMonth.getYear());
                    objectOutput.writeInt(calendarMonth.getMonth().getValue());
                    break;
                }
                case 39: {
                    CalendarWeek calendarWeek = (CalendarWeek)this.obj;
                    objectOutput.writeInt(calendarWeek.getYear());
                    objectOutput.writeInt(calendarWeek.getWeek());
                    break;
                }
                case 40: 
                case 41: 
                case 42: 
                case 43: {
                    IntervalCollection intervalCollection = (IntervalCollection)IntervalCollection.class.cast(this.obj);
                    objectOutput.writeInt(intervalCollection.getSize());
                    for (ChronoInterval chronoInterval : intervalCollection.getIntervals()) {
                        SPX.writeBoundary(chronoInterval.getStart(), objectOutput);
                        SPX.writeBoundary(chronoInterval.getEnd(), objectOutput);
                    }
                    break;
                }
                case 44: {
                    IntervalCollection intervalCollection = (IntervalCollection)IntervalCollection.class.cast(this.obj);
                    objectOutput.writeObject(intervalCollection.getTimeLine());
                    objectOutput.writeInt(intervalCollection.getSize());
                    for (ChronoInterval chronoInterval : intervalCollection.getIntervals()) {
                        objectOutput.writeObject(chronoInterval.getStart().getTemporal());
                        objectOutput.writeObject(chronoInterval.getEnd().getTemporal());
                    }
                    break;
                }
                case 7: {
                    this.writeMachineTime(objectOutput);
                    break;
                }
                default: {
                    throw new InvalidClassException("Unknown serialized type.");
                }
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        int n = (by & 0xFF) >> 2;
        switch (n) {
            case 32: {
                this.obj = SPX.readDateInterval(objectInput);
                break;
            }
            case 33: {
                this.obj = SPX.readClockInterval(objectInput);
                break;
            }
            case 34: {
                this.obj = SPX.readTimestampInterval(objectInput);
                break;
            }
            case 35: {
                this.obj = SPX.readMomentInterval(objectInput);
                break;
            }
            case 36: {
                this.obj = SPX.readCalendarYear(objectInput);
                break;
            }
            case 37: {
                this.obj = SPX.readCalendarQuarter(objectInput);
                break;
            }
            case 38: {
                this.obj = SPX.readCalendarMonth(objectInput);
                break;
            }
            case 39: {
                this.obj = SPX.readCalendarWeek(objectInput);
                break;
            }
            case 40: {
                this.obj = SPX.readDateWindows(objectInput);
                break;
            }
            case 41: {
                this.obj = SPX.readClockWindows(objectInput);
                break;
            }
            case 42: {
                this.obj = SPX.readTimestampWindows(objectInput);
                break;
            }
            case 43: {
                this.obj = SPX.readMomentWindows(objectInput);
                break;
            }
            case 44: {
                this.obj = SPX.readGenericWindows(objectInput);
                break;
            }
            case 57: {
                this.obj = SPX.readBoundary(objectInput, by);
                break;
            }
            case 7: {
                this.obj = this.readMachineTime(objectInput, by);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private static DateInterval readDateInterval(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = SPX.readBoundary(objectInput);
        Object object2 = SPX.readBoundary(objectInput);
        Boundary<PlainDate> boundary = SPX.getBoundary(object, PlainDate.class, false);
        Boundary<PlainDate> boundary2 = SPX.getBoundary(object2, PlainDate.class, true);
        if (boundary != null && boundary2 != null) {
            return new DateInterval(boundary, boundary2);
        }
        throw new StreamCorruptedException();
    }

    private static ClockInterval readClockInterval(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = SPX.readBoundary(objectInput);
        Object object2 = SPX.readBoundary(objectInput);
        Boundary<PlainTime> boundary = SPX.getBoundary(object, PlainTime.class, false);
        Boundary<PlainTime> boundary2 = SPX.getBoundary(object2, PlainTime.class, true);
        if (boundary != null && boundary2 != null) {
            return new ClockInterval(boundary, boundary2);
        }
        throw new StreamCorruptedException();
    }

    private static TimestampInterval readTimestampInterval(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = SPX.readBoundary(objectInput);
        Object object2 = SPX.readBoundary(objectInput);
        Boundary<PlainTimestamp> boundary = SPX.getBoundary(object, PlainTimestamp.class, false);
        Boundary<PlainTimestamp> boundary2 = SPX.getBoundary(object2, PlainTimestamp.class, true);
        if (boundary != null && boundary2 != null) {
            return new TimestampInterval(boundary, boundary2);
        }
        throw new StreamCorruptedException();
    }

    private static MomentInterval readMomentInterval(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        Object object = SPX.readBoundary(objectInput);
        Object object2 = SPX.readBoundary(objectInput);
        Boundary<Moment> boundary = SPX.getBoundary(object, Moment.class, false);
        Boundary<Moment> boundary2 = SPX.getBoundary(object2, Moment.class, true);
        if (boundary != null && boundary2 != null) {
            return new MomentInterval(boundary, boundary2);
        }
        throw new StreamCorruptedException();
    }

    private static CalendarYear readCalendarYear(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        return CalendarYear.of(n);
    }

    private static CalendarQuarter readCalendarQuarter(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        int n2 = objectInput.readInt();
        return CalendarQuarter.of(n, Quarter.valueOf((int)n2));
    }

    private static CalendarMonth readCalendarMonth(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        int n2 = objectInput.readInt();
        return CalendarMonth.of(n, Month.valueOf((int)n2));
    }

    private static CalendarWeek readCalendarWeek(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        int n2 = objectInput.readInt();
        return CalendarWeek.of(n, n2);
    }

    private static IntervalCollection<PlainDate> readDateWindows(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == 0) {
            return DateWindows.EMPTY;
        }
        ArrayList<DateInterval> arrayList = new ArrayList<DateInterval>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(SPX.readDateInterval(objectInput));
        }
        Collections.sort(arrayList, DateInterval.comparator());
        return DateWindows.EMPTY.plus((List<ChronoInterval<PlainDate>>)arrayList);
    }

    private static IntervalCollection<PlainTime> readClockWindows(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == 0) {
            return ClockWindows.EMPTY;
        }
        ArrayList<ClockInterval> arrayList = new ArrayList<ClockInterval>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(SPX.readClockInterval(objectInput));
        }
        Collections.sort(arrayList, ClockInterval.comparator());
        return ClockWindows.EMPTY.plus((List<ChronoInterval<PlainTime>>)arrayList);
    }

    private static IntervalCollection<PlainTimestamp> readTimestampWindows(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == 0) {
            return TimestampWindows.EMPTY;
        }
        ArrayList<TimestampInterval> arrayList = new ArrayList<TimestampInterval>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(SPX.readTimestampInterval(objectInput));
        }
        Collections.sort(arrayList, TimestampInterval.comparator());
        return TimestampWindows.EMPTY.plus((List<ChronoInterval<PlainTimestamp>>)arrayList);
    }

    private static IntervalCollection<Moment> readMomentWindows(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readInt();
        if (n == 0) {
            return MomentWindows.EMPTY;
        }
        ArrayList<MomentInterval> arrayList = new ArrayList<MomentInterval>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(SPX.readMomentInterval(objectInput));
        }
        Collections.sort(arrayList, MomentInterval.comparator());
        return MomentWindows.EMPTY.plus((List<ChronoInterval<Moment>>)arrayList);
    }

    private static IntervalCollection<?> readGenericWindows(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        TimeLine timeLine = (TimeLine)TimeLine.class.cast(objectInput.readObject());
        int n = objectInput.readInt();
        ArrayList arrayList = new ArrayList(n);
        for (int i = 0; i < n; ++i) {
            Object object = objectInput.readObject();
            Object object2 = objectInput.readObject();
            arrayList.add(new SimpleInterval<Object>(object, object2, timeLine));
        }
        Collections.sort(arrayList, new IntervalComparator(false, timeLine));
        return new GenericWindows(timeLine, arrayList);
    }

    private static Object readBoundary(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        IntervalEdge intervalEdge;
        int n = by & 1;
        if (n == 1) {
            return Boundary.infinitePast();
        }
        int n2 = by & 2;
        if (n2 == 2) {
            return Boundary.infiniteFuture();
        }
        byte by2 = objectInput.readByte();
        switch (by2) {
            case 0: {
                intervalEdge = IntervalEdge.CLOSED;
                break;
            }
            case 1: {
                intervalEdge = IntervalEdge.OPEN;
                break;
            }
            default: {
                throw new StreamCorruptedException("Invalid edge state.");
            }
        }
        Object object = objectInput.readObject();
        return Boundary.of(intervalEdge, object);
    }

    private static void writeBoundary(Boundary<?> boundary, ObjectOutput objectOutput) throws IOException {
        if (boundary.equals(Boundary.infinitePast())) {
            objectOutput.writeByte(1);
        } else if (boundary.equals(Boundary.infiniteFuture())) {
            objectOutput.writeByte(2);
        } else {
            objectOutput.writeByte(boundary.isOpen() ? 4 : 0);
            objectOutput.writeObject(boundary.getTemporal());
        }
    }

    private static Object readBoundary(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        int n = objectInput.readByte() & 0xFF;
        if ((n & 1) == 1) {
            return Boundary.infinitePast();
        }
        if ((n & 2) == 2) {
            return Boundary.infiniteFuture();
        }
        IntervalEdge intervalEdge = (n & 4) == 4 ? IntervalEdge.OPEN : IntervalEdge.CLOSED;
        Object object = objectInput.readObject();
        return Boundary.of(intervalEdge, object);
    }

    private static <T> Boundary<T> getBoundary(Object object, Class<T> clazz, boolean bl) {
        Boundary boundary = null;
        if (object instanceof Boundary) {
            Boundary boundary2 = (Boundary)SPX.cast(object);
            if (boundary2.isInfinite()) {
                Boundary boundary3 = bl ? Boundary.infiniteFuture() : Boundary.infinitePast();
                if (boundary3.equals(object)) {
                    boundary = boundary3;
                }
            } else if (clazz.isInstance(boundary2.getTemporal())) {
                boundary = (Boundary)SPX.cast(boundary2);
            }
        }
        return boundary;
    }

    private void writeMachineTime(ObjectOutput objectOutput) throws IOException {
        MachineTime machineTime = (MachineTime)MachineTime.class.cast(this.obj);
        int n = 7;
        n <<= 2;
        if (machineTime.getScale() == TimeScale.UTC) {
            n |= 1;
        }
        if (machineTime.getFraction() == 0) {
            objectOutput.writeByte(n);
            objectOutput.writeLong(machineTime.getSeconds());
        } else {
            objectOutput.writeByte(n |= 2);
            objectOutput.writeLong(machineTime.getSeconds());
            objectOutput.writeInt(machineTime.getFraction());
        }
    }

    private Object readMachineTime(ObjectInput objectInput, byte by) throws IOException, ClassNotFoundException {
        int n;
        TimeScale timeScale = (by & 1) == 1 ? TimeScale.UTC : TimeScale.POSIX;
        long l = objectInput.readLong();
        int n2 = n = (by & 2) == 2 ? objectInput.readInt() : 0;
        if (timeScale == TimeScale.UTC) {
            return MachineTime.ofSIUnits(l, n);
        }
        return MachineTime.ofPosixUnits(l, n);
    }

    private static <T> T cast(Object object) {
        return (T)object;
    }
}

