/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.time4j.AdjustableElement;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.Weekmodel;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Temporal;
import net.time4j.engine.TimeLine;
import net.time4j.engine.TimePoint;
import net.time4j.format.Attributes;
import net.time4j.format.DisplayMode;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.ElementPosition;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.IsoDateStyle;
import net.time4j.format.expert.IsoDecimalStyle;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.SignPolicy;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.DateInterval;
import net.time4j.range.FixedNumParser;
import net.time4j.range.InfinityStyle;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.MachineTime;
import net.time4j.range.MomentIntervalFactory;
import net.time4j.range.NoopPrinter;
import net.time4j.range.SPX;
import net.time4j.range.TimestampInterval;
import net.time4j.range.YearParser;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public final class MomentInterval
extends IsoInterval<Moment, MomentInterval>
implements Serializable {
    private static final long serialVersionUID = -5403584519478162113L;
    private static final ChronoFormatter<Moment> EXTENDED_ISO = Iso8601Format.EXTENDED_DATE_TIME_OFFSET.with(Attributes.TRAILING_CHARACTERS, true);
    private static final ChronoFormatter<Moment> BASIC_ISO = Iso8601Format.BASIC_DATE_TIME_OFFSET.with(Attributes.TRAILING_CHARACTERS, true);
    private static final Comparator<ChronoInterval<Moment>> COMPARATOR = new IntervalComparator<Moment>(false, (TimeLine<Moment>)Moment.axis());

    MomentInterval(Boundary<Moment> boundary, Boundary<Moment> boundary2) {
        super(boundary, boundary2);
    }

    public static Comparator<ChronoInterval<Moment>> comparator() {
        return COMPARATOR;
    }

    public static MomentInterval between(Moment moment, Moment moment2) {
        return new MomentInterval(Boundary.of(IntervalEdge.CLOSED, moment), Boundary.of(IntervalEdge.OPEN, moment2));
    }

    public static MomentInterval between(Instant instant, Instant instant2) {
        return MomentInterval.between(Moment.from((Instant)instant), Moment.from((Instant)instant2));
    }

    public static MomentInterval since(Moment moment) {
        Boundary<Moment> boundary = Boundary.infiniteFuture();
        return new MomentInterval(Boundary.of(IntervalEdge.CLOSED, moment), boundary);
    }

    public static MomentInterval since(Instant instant) {
        return MomentInterval.since(Moment.from((Instant)instant));
    }

    public static MomentInterval until(Moment moment) {
        Boundary<Moment> boundary = Boundary.infinitePast();
        return new MomentInterval(boundary, Boundary.of(IntervalEdge.OPEN, moment));
    }

    public static MomentInterval until(Instant instant) {
        return MomentInterval.until(Moment.from((Instant)instant));
    }

    public Moment getStartAsMoment() {
        return (Moment)this.getStart().getTemporal();
    }

    public Instant getStartAsInstant() {
        Moment moment = this.getStartAsMoment();
        return moment == null ? null : moment.toTemporalAccessor();
    }

    public Moment getEndAsMoment() {
        return (Moment)this.getEnd().getTemporal();
    }

    public Instant getEndAsInstant() {
        Moment moment = this.getEndAsMoment();
        return moment == null ? null : moment.toTemporalAccessor();
    }

    public TimestampInterval toLocalInterval() {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toLocalTimestamp();
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toLocalTimestamp();
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public TimestampInterval toZonalInterval(TZID tZID) {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toZonalTimestamp(tZID);
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toZonalTimestamp(tZID);
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public TimestampInterval toZonalInterval(String string) {
        Boundary<PlainTimestamp> boundary;
        PlainTimestamp plainTimestamp;
        Boundary<PlainTimestamp> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            plainTimestamp = ((Moment)this.getStart().getTemporal()).toZonalTimestamp(string);
            boundary2 = Boundary.of(this.getStart().getEdge(), plainTimestamp);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            plainTimestamp = ((Moment)this.getEnd().getTemporal()).toZonalTimestamp(string);
            boundary = Boundary.of(this.getEnd().getEdge(), plainTimestamp);
        }
        return new TimestampInterval(boundary2, boundary);
    }

    public Duration<IsoUnit> getNominalDuration(Timezone timezone, IsoUnit ... isoUnitArray) {
        return this.toZonalInterval(timezone.getID()).getDuration(timezone, isoUnitArray);
    }

    public MachineTime<TimeUnit> getSimpleDuration() {
        boolean bl;
        Moment moment = (Moment)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = moment == null;
        if (bl) {
            moment = (Moment)this.getEnd().getTemporal();
        }
        MachineTime machineTime = (MachineTime)MachineTime.ON_POSIX_SCALE.between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)moment);
        if (bl) {
            return machineTime.plus(1L, TimeUnit.NANOSECONDS);
        }
        return machineTime;
    }

    public MachineTime<SI> getRealDuration() {
        boolean bl;
        Moment moment = (Moment)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = moment == null;
        if (bl) {
            moment = (Moment)this.getEnd().getTemporal();
        }
        MachineTime machineTime = (MachineTime)MachineTime.ON_UTC_SCALE.between((TimePoint)this.getTemporalOfClosedStart(), (TimePoint)moment);
        if (bl) {
            return machineTime.plus(1L, SI.NANOSECONDS);
        }
        return machineTime;
    }

    public MomentInterval move(long l, TimeUnit timeUnit) {
        if (l == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), (Temporal)((Moment)this.getStart().getTemporal()).plus(l, (Object)timeUnit));
        Boundary<Object> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), (Temporal)((Moment)this.getEnd().getTemporal()).plus(l, (Object)timeUnit));
        return new MomentInterval((Boundary<Moment>)boundary, (Boundary<Moment>)boundary2);
    }

    public MomentInterval move(long l, SI sI) {
        if (l == 0L) {
            return this;
        }
        Boundary<Object> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), ((Moment)this.getStart().getTemporal()).plus(l, sI));
        Boundary<Moment> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), ((Moment)this.getEnd().getTemporal()).plus(l, sI));
        return new MomentInterval((Boundary<Moment>)boundary, boundary2);
    }

    public String formatISO(IsoDateStyle isoDateStyle, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit, ZonalOffset zonalOffset, InfinityStyle infinityStyle) {
        MomentInterval momentInterval = (MomentInterval)this.toCanonical();
        StringBuilder stringBuilder = new StringBuilder(65);
        ChronoPrinter chronoPrinter = Iso8601Format.ofMoment((IsoDateStyle)isoDateStyle, (IsoDecimalStyle)isoDecimalStyle, (ClockUnit)clockUnit, (ZonalOffset)zonalOffset);
        if (momentInterval.getStart().isInfinite()) {
            stringBuilder.append(infinityStyle.displayPast(chronoPrinter, Moment.axis()));
        } else {
            chronoPrinter.print((Object)momentInterval.getStartAsMoment(), stringBuilder);
        }
        stringBuilder.append('/');
        if (momentInterval.getEnd().isInfinite()) {
            stringBuilder.append(infinityStyle.displayFuture(chronoPrinter, Moment.axis()));
        } else {
            chronoPrinter.print((Object)momentInterval.getEndAsMoment(), stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String formatReduced(IsoDateStyle isoDateStyle, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit, ZonalOffset zonalOffset, InfinityStyle infinityStyle) {
        ChronoPrinter chronoPrinter;
        MomentInterval momentInterval = (MomentInterval)this.toCanonical();
        Moment moment = momentInterval.getStartAsMoment();
        Moment moment2 = momentInterval.getEndAsMoment();
        StringBuilder stringBuilder = new StringBuilder(65);
        ChronoPrinter chronoPrinter2 = Iso8601Format.ofMoment((IsoDateStyle)isoDateStyle, (IsoDecimalStyle)isoDecimalStyle, (ClockUnit)clockUnit, (ZonalOffset)zonalOffset);
        if (momentInterval.getStart().isInfinite()) {
            chronoPrinter = null;
            if (infinityStyle == InfinityStyle.MIN_MAX) {
                chronoPrinter = Iso8601Format.ofMoment((IsoDateStyle)isoDateStyle, (IsoDecimalStyle)isoDecimalStyle, (ClockUnit)clockUnit, (ZonalOffset)ZonalOffset.UTC);
            }
            stringBuilder.append(infinityStyle.displayPast(chronoPrinter, Moment.axis()));
        } else {
            chronoPrinter2.print((Object)moment, stringBuilder);
        }
        stringBuilder.append('/');
        if (momentInterval.isFinite()) {
            PlainDate plainDate;
            chronoPrinter = moment2.toZonalTimestamp((TZID)zonalOffset);
            PlainDate plainDate2 = moment.toZonalTimestamp((TZID)zonalOffset).getCalendarDate();
            if (!plainDate2.equals((Object)(plainDate = chronoPrinter.getCalendarDate()))) {
                DateInterval.getEndPrinter(isoDateStyle, plainDate2, plainDate).print((Object)plainDate, stringBuilder);
            }
            stringBuilder.append('T');
            ChronoPrinter chronoPrinter3 = isoDateStyle.isExtended() ? Iso8601Format.ofExtendedTime((IsoDecimalStyle)isoDecimalStyle, (ClockUnit)clockUnit) : Iso8601Format.ofBasicTime((IsoDecimalStyle)isoDecimalStyle, (ClockUnit)clockUnit);
            Set set = chronoPrinter3.print((Object)chronoPrinter.getWallTime(), stringBuilder);
            if (moment2.isLeapSecond()) {
                for (ElementPosition elementPosition : set) {
                    if (elementPosition.getElement() != PlainTime.SECOND_OF_MINUTE) continue;
                    stringBuilder.replace(elementPosition.getStartIndex(), elementPosition.getEndIndex(), "60");
                    break;
                }
            }
        } else if (momentInterval.getEnd().isInfinite()) {
            chronoPrinter = null;
            if (infinityStyle == InfinityStyle.MIN_MAX) {
                chronoPrinter = Iso8601Format.ofMoment((IsoDateStyle)isoDateStyle, (IsoDecimalStyle)isoDecimalStyle, (ClockUnit)clockUnit, (ZonalOffset)ZonalOffset.UTC);
            }
            stringBuilder.append(infinityStyle.displayFuture(chronoPrinter, Moment.axis()));
        } else {
            chronoPrinter2.print((Object)moment2, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static MomentInterval parse(String string, ChronoParser<Moment> chronoParser) throws ParseException {
        return MomentInterval.parse(string, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
    }

    public static MomentInterval parse(String string, ChronoParser<Moment> chronoParser, String string2) throws ParseException {
        return IntervalParser.parsePattern(string, MomentIntervalFactory.INSTANCE, chronoParser, string2);
    }

    public static MomentInterval parse(CharSequence charSequence, ChronoParser<Moment> chronoParser, BracketPolicy bracketPolicy) throws ParseException {
        ParseLog parseLog = new ParseLog();
        MomentInterval momentInterval = (MomentInterval)IntervalParser.of(MomentIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, new ParseLog(), chronoParser.getAttributes());
        if (momentInterval == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        return momentInterval;
    }

    @Deprecated
    public static MomentInterval parse(CharSequence charSequence, ChronoParser<Moment> chronoParser, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (MomentInterval)IntervalParser.of(MomentIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, chronoParser.getAttributes());
    }

    public static MomentInterval parse(CharSequence charSequence, ChronoParser<Moment> chronoParser, char c, ChronoParser<Moment> chronoParser2, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (MomentInterval)IntervalParser.of(MomentIntervalFactory.INSTANCE, chronoParser, chronoParser2, bracketPolicy, c).parse(charSequence, parseLog, chronoParser.getAttributes());
    }

    public static MomentInterval parseISO(String string) throws ParseException {
        int n;
        int n2;
        int n3;
        boolean bl;
        if (string.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty text.");
        }
        int n4 = 0;
        int n5 = Math.min(string.length(), 117);
        boolean bl2 = true;
        int n6 = 1;
        int n7 = 0;
        int n8 = 0;
        boolean bl3 = bl = string.charAt(0) == '-';
        if (string.charAt(0) == 'P' || bl) {
            for (n3 = 1; n3 < n5; ++n3) {
                if (string.charAt(n3) != '/') continue;
                if (n3 + 1 == n5) {
                    throw new ParseException("Missing end component.", n5);
                }
                if (bl) {
                    if (string.charAt(1) != '\u221e' && n3 != 1) break;
                    n4 = n3 + 1;
                    break;
                }
                n4 = n3 + 1;
                break;
            }
        }
        n3 = 0;
        int n9 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n10 = -1;
        for (n2 = n4 + 1; n2 < n5; ++n2) {
            n = string.charAt(n2);
            if (bl7) {
                if (n == 80 || n == 45 && n2 == n5 - 1 || n == 43 && n2 == n5 - 2 && string.charAt(n2 + 1) == '\u221e') {
                    bl7 = false;
                    break;
                }
                if (n == 84 || n8 > 0) {
                    ++n8;
                    continue;
                }
                if (n == 87) {
                    bl6 = true;
                } else if (n == 45 && n2 > n10 + 1) {
                    ++n9;
                }
                ++n7;
                continue;
            }
            if (n == 47) {
                if (n10 == -1) {
                    n10 = n2;
                    bl7 = true;
                    n8 = 0;
                    continue;
                }
                throw new ParseException("Interval with two slashes found: " + string, n2);
            }
            if (n == 84 || n8 > 0) {
                ++n8;
                continue;
            }
            if (n == 45) {
                ++n6;
                ++n3;
                continue;
            }
            if (n == 87) {
                ++n6;
                bl5 = true;
                continue;
            }
            ++n6;
        }
        if (bl7 && bl5 != bl6) {
            throw new ParseException("Mixed date styles not allowed.", n5);
        }
        n2 = string.charAt(n4);
        n = n6 - 4;
        if (n2 == 43 || n2 == 45) {
            n -= 2;
        }
        if (!bl5) {
            bl4 = n3 == 1 || n3 == 0 && n == 3;
        }
        boolean bl8 = n3 > 0;
        boolean bl9 = true;
        if (bl7) {
            if (n8 == 0) {
                bl9 = false;
                n8 = n7;
                n7 = 0;
            }
            bl2 = n6 == n7 && n3 == n9 && MomentInterval.hasSecondOffset(string, n5);
        }
        ChronoFormatter<Moment> chronoFormatter = bl8 ? EXTENDED_ISO : BASIC_ISO;
        ChronoFormatter<Moment> chronoFormatter2 = bl2 ? chronoFormatter : null;
        Parser parser = new Parser((ChronoParser<Moment>)chronoFormatter, (ChronoParser<Moment>)chronoFormatter2, bl8, bl5, bl4, n8, bl9);
        return (MomentInterval)parser.parse(string);
    }

    @Override
    IntervalFactory<Moment, MomentInterval> getFactory() {
        return MomentIntervalFactory.INSTANCE;
    }

    @Override
    MomentInterval getContext() {
        return this;
    }

    private static boolean hasSecondOffset(String string, int n) {
        char c;
        if (string.charAt(n - 1) == 'Z') {
            return true;
        }
        int n2 = Math.max(0, n - 6);
        for (int i = n - 1; i >= n2 && (c = string.charAt(i)) != 'T' && c != '/' && c != '.' && c != ','; --i) {
            if (c != '+' && c != '-') continue;
            return true;
        }
        return false;
    }

    private Object writeReplace() {
        return new SPX(this, 35);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private static class Parser
    extends IntervalParser<Moment, MomentInterval> {
        private final boolean extended;
        private final boolean weekStyle;
        private final boolean ordinalStyle;
        private final int protectedArea;
        private final boolean hasT;

        Parser(ChronoParser<Moment> chronoParser, ChronoParser<Moment> chronoParser2, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super(MomentIntervalFactory.INSTANCE, chronoParser, chronoParser2, BracketPolicy.SHOW_NEVER, Character.valueOf('/'));
            this.extended = bl;
            this.weekStyle = bl2;
            this.ordinalStyle = bl3;
            this.protectedArea = n;
            this.hasT = bl4;
        }

        @Override
        protected Moment parseReducedEnd(CharSequence charSequence, Moment moment, ParseLog parseLog, ParseLog parseLog2, AttributeQuery attributeQuery) {
            ChronoFormatter<Moment> chronoFormatter = this.createEndFormat(Moment.axis().preformat((ChronoEntity)moment, attributeQuery), parseLog.getRawValues());
            return (Moment)chronoFormatter.parse(charSequence, parseLog2);
        }

        @Override
        protected boolean wantsTrailingCheck() {
            return true;
        }

        private ChronoFormatter<Moment> createEndFormat(ChronoDisplay chronoDisplay, ChronoEntity<?> chronoEntity) {
            int n;
            AdjustableElement adjustableElement;
            ChronoFormatter.Builder builder = ChronoFormatter.setUp(Moment.class, (Locale)Locale.ROOT);
            AdjustableElement adjustableElement2 = adjustableElement = this.weekStyle ? PlainDate.YEAR_OF_WEEKDATE : PlainDate.YEAR;
            if (this.extended) {
                n = (this.ordinalStyle ? 3 : 5) + this.protectedArea;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
                builder.addCustomized((ChronoElement)adjustableElement, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(this.weekStyle ? YearParser.YEAR_OF_WEEKDATE : YearParser.YEAR));
            } else {
                n = (this.ordinalStyle ? 3 : 4) + this.protectedArea;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
                builder.addInteger((ChronoElement)adjustableElement, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
            }
            builder.endSection();
            if (this.weekStyle) {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, 1 + this.protectedArea);
                builder.addCustomized((ChronoElement)Weekmodel.ISO.weekOfYear(), (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)(this.extended ? FixedNumParser.EXTENDED_WEEK_OF_YEAR : FixedNumParser.BASIC_WEEK_OF_YEAR));
                builder.endSection();
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedNumerical((ChronoElement)PlainDate.DAY_OF_WEEK, 1);
                builder.endSection();
            } else if (this.ordinalStyle) {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_YEAR, 3);
                builder.endSection();
            } else {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, 2 + this.protectedArea);
                if (this.extended) {
                    builder.addCustomized((ChronoElement)PlainDate.MONTH_AS_NUMBER, (ChronoPrinter)NoopPrinter.NOOP, (ChronoParser)FixedNumParser.CALENDAR_MONTH);
                } else {
                    builder.addFixedInteger((ChronoElement)PlainDate.MONTH_AS_NUMBER, 2);
                }
                builder.endSection();
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedInteger((ChronoElement)PlainDate.DAY_OF_MONTH, 2);
                builder.endSection();
            }
            if (this.hasT) {
                builder.addLiteral('T');
            }
            builder.addCustomized((ChronoElement)PlainTime.COMPONENT, this.extended ? Iso8601Format.EXTENDED_WALL_TIME : Iso8601Format.BASIC_WALL_TIME);
            builder.startOptionalSection();
            builder.addTimezoneOffset(DisplayMode.SHORT, this.extended, Collections.singletonList("Z"));
            builder.endSection();
            for (ChronoElement<?> chronoElement : MomentIntervalFactory.INSTANCE.stdElements(chronoEntity)) {
                Parser.setDefault((ChronoFormatter.Builder<Moment>)builder, chronoElement, chronoDisplay);
            }
            Attributes attributes = new Attributes.Builder().set(Attributes.TRAILING_CHARACTERS, true).setTimezone(chronoEntity.getTimezone()).build();
            return builder.build(attributes);
        }

        private static <V> void setDefault(ChronoFormatter.Builder<Moment> builder, ChronoElement<V> chronoElement, ChronoDisplay chronoDisplay) {
            builder.setDefault(chronoElement, chronoDisplay.get(chronoElement));
        }
    }
}

