/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.text.ParseException;
import java.util.Iterator;
import java.util.Locale;
import java.util.NoSuchElementException;
import net.time4j.CalendarUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.Weekcycle;
import net.time4j.Weekday;
import net.time4j.Weekmodel;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.PatternType;
import net.time4j.range.Boundary;
import net.time4j.range.FixedCalendarInterval;
import net.time4j.range.SPX;
import net.time4j.range.Weeks;
import net.time4j.range.Years;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="iso8601")
public final class CalendarWeek
extends FixedCalendarInterval<CalendarWeek> {
    @FormattableElement(format="Y")
    public static final ChronoElement<Integer> YEAR_OF_WEEKDATE = PlainDate.YEAR_OF_WEEKDATE;
    @FormattableElement(format="w")
    public static final ChronoElement<Integer> WEEK_OF_YEAR = Weekmodel.ISO.weekOfYear();
    private static final Chronology<CalendarWeek> ENGINE = Chronology.Builder.setUp(CalendarWeek.class, (ChronoMerger)new Merger()).appendElement(YEAR_OF_WEEKDATE, (ElementRule)new YearRule()).appendElement(WEEK_OF_YEAR, (ElementRule)new WeekRule()).build();
    private static final ChronoFormatter<CalendarWeek> PARSER = ChronoFormatter.setUp(CalendarWeek.chronology(), (Locale)Locale.ROOT).addPattern("YYYY[-]'W'ww", PatternType.CLDR).build();
    private static final long serialVersionUID = -3948942660009645060L;
    private final transient int year;
    private final transient int week;
    private final transient Boundary<PlainDate> start;
    private final transient Boundary<PlainDate> end;
    private final transient int lastWeek;

    private CalendarWeek(int n, int n2) {
        int n3 = CalendarWeek.maximumOfWeek(n);
        if (n < -999999999 || n > 999999999) {
            throw new IllegalArgumentException("Year out of bounds: " + n);
        }
        if (n2 < 1 || n2 > n3) {
            throw new NullPointerException("Week-of-year out of bounds: " + n2);
        }
        this.year = n;
        this.week = n2;
        this.lastWeek = n3;
        PlainDate plainDate = PlainDate.of((int)this.year, (int)n2, (Weekday)Weekday.MONDAY);
        this.start = Boundary.ofClosed(plainDate);
        this.end = Boundary.ofClosed(plainDate.plus(6L, CalendarUnit.DAYS));
    }

    public static CalendarWeek of(int n, int n2) {
        return new CalendarWeek(n, n2);
    }

    public PlainDate at(Weekday weekday) {
        if (weekday == Weekday.MONDAY) {
            return this.start.getTemporal();
        }
        if (weekday == Weekday.SUNDAY) {
            return this.end.getTemporal();
        }
        return PlainDate.of((int)this.year, (int)this.week, (Weekday)weekday);
    }

    public int getYear() {
        return this.year;
    }

    public int getWeek() {
        return this.week;
    }

    @Override
    public Boundary<PlainDate> getStart() {
        return this.start;
    }

    @Override
    public Boundary<PlainDate> getEnd() {
        return this.end;
    }

    @Override
    public boolean contains(PlainDate plainDate) {
        return !plainDate.isBefore((CalendarDate)this.start.getTemporal()) && !plainDate.isAfter((CalendarDate)this.end.getTemporal());
    }

    @Override
    public boolean isAfter(PlainDate plainDate) {
        return this.start.getTemporal().isAfter((CalendarDate)plainDate);
    }

    @Override
    public boolean isBefore(PlainDate plainDate) {
        return this.end.getTemporal().isBefore((CalendarDate)plainDate);
    }

    public int length() {
        return 7;
    }

    public CalendarWeek withLastWeekOfYear() {
        if (this.week == this.lastWeek) {
            return this;
        }
        return CalendarWeek.of(this.year, this.lastWeek);
    }

    public CalendarWeek plus(Years<Weekcycle> years) {
        if (years.isEmpty()) {
            return this;
        }
        int n = MathUtils.safeAdd((int)this.year, (int)years.getAmount());
        int n2 = this.week;
        if (this.week == 53 && CalendarWeek.maximumOfWeek(n) < 53) {
            n2 = 52;
        }
        return CalendarWeek.of(n, n2);
    }

    public CalendarWeek plus(Weeks weeks) {
        if (weeks.isEmpty()) {
            return this;
        }
        PlainDate plainDate = this.start.getTemporal().plus((long)weeks.getAmount(), CalendarUnit.WEEKS);
        int n = plainDate.getInt(YEAR_OF_WEEKDATE);
        int n2 = plainDate.getInt(WEEK_OF_YEAR);
        return CalendarWeek.of(n, n2);
    }

    public CalendarWeek minus(Years<Weekcycle> years) {
        if (years.isEmpty()) {
            return this;
        }
        int n = MathUtils.safeSubtract((int)this.year, (int)years.getAmount());
        int n2 = this.week;
        if (this.week == 53 && CalendarWeek.maximumOfWeek(n) < 53) {
            n2 = 52;
        }
        return CalendarWeek.of(n, n2);
    }

    public CalendarWeek minus(Weeks weeks) {
        if (weeks.isEmpty()) {
            return this;
        }
        PlainDate plainDate = this.start.getTemporal().minus((long)weeks.getAmount(), CalendarUnit.WEEKS);
        int n = plainDate.getInt(YEAR_OF_WEEKDATE);
        int n2 = plainDate.getInt(WEEK_OF_YEAR);
        return CalendarWeek.of(n, n2);
    }

    @Override
    public int compareTo(CalendarWeek calendarWeek) {
        if (this.year < calendarWeek.year) {
            return -1;
        }
        if (this.year > calendarWeek.year) {
            return 1;
        }
        return this.week - calendarWeek.week;
    }

    @Override
    public Iterator<PlainDate> iterator() {
        return new Iter();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CalendarWeek) {
            CalendarWeek calendarWeek = (CalendarWeek)object;
            return this.year == calendarWeek.year && this.week == calendarWeek.week;
        }
        return false;
    }

    public int hashCode() {
        return this.year ^ this.week >> 16;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        CalendarWeek.formatYear(stringBuilder, this.year);
        stringBuilder.append("-W");
        if (this.week < 10) {
            stringBuilder.append('0');
        }
        stringBuilder.append(this.week);
        return stringBuilder.toString();
    }

    public static CalendarWeek parseISO(String string) throws ParseException {
        return (CalendarWeek)PARSER.parse((CharSequence)string);
    }

    public static Chronology<CalendarWeek> chronology() {
        return ENGINE;
    }

    protected Chronology<CalendarWeek> getChronology() {
        return ENGINE;
    }

    protected CalendarWeek getContext() {
        return this;
    }

    private static int maximumOfWeek(int n) {
        return (Integer)PlainDate.of((int)n, (int)7, (int)1).getMaximum(WEEK_OF_YEAR);
    }

    private Object writeReplace() {
        return new SPX(this, 39);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private class Iter
    implements Iterator<PlainDate> {
        private int count = 0;

        private Iter() {
        }

        @Override
        public boolean hasNext() {
            return this.count < 7;
        }

        @Override
        public PlainDate next() {
            if (this.count >= 7) {
                throw new NoSuchElementException();
            }
            PlainDate plainDate = ((PlainDate)CalendarWeek.this.start.getTemporal()).plus((long)this.count, CalendarUnit.DAYS);
            ++this.count;
            return plainDate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class WeekRule
    implements IntElementRule<CalendarWeek> {
        private WeekRule() {
        }

        public Integer getValue(CalendarWeek calendarWeek) {
            return calendarWeek.week;
        }

        public Integer getMinimum(CalendarWeek calendarWeek) {
            return 1;
        }

        public Integer getMaximum(CalendarWeek calendarWeek) {
            return calendarWeek.lastWeek;
        }

        public boolean isValid(CalendarWeek calendarWeek, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= 1 && (n2 < 53 || n2 == calendarWeek.lastWeek);
        }

        public CalendarWeek withValue(CalendarWeek calendarWeek, Integer n, boolean bl) {
            if (this.isValid(calendarWeek, n)) {
                return CalendarWeek.of(calendarWeek.year, n);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }

        public ChronoElement<?> getChildAtFloor(CalendarWeek calendarWeek) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(CalendarWeek calendarWeek) {
            return null;
        }

        public int getInt(CalendarWeek calendarWeek) {
            return calendarWeek.week;
        }

        public boolean isValid(CalendarWeek calendarWeek, int n) {
            return n >= 1 && (n < 53 || n == calendarWeek.lastWeek);
        }

        public CalendarWeek withValue(CalendarWeek calendarWeek, int n, boolean bl) {
            if (this.isValid(calendarWeek, n)) {
                return CalendarWeek.of(calendarWeek.year, n);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }
    }

    private static class YearRule
    implements IntElementRule<CalendarWeek> {
        private YearRule() {
        }

        public Integer getValue(CalendarWeek calendarWeek) {
            return calendarWeek.year;
        }

        public Integer getMinimum(CalendarWeek calendarWeek) {
            return -999999999;
        }

        public Integer getMaximum(CalendarWeek calendarWeek) {
            return 999999999;
        }

        public boolean isValid(CalendarWeek calendarWeek, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= -999999999 && n2 <= 999999999;
        }

        public CalendarWeek withValue(CalendarWeek calendarWeek, Integer n, boolean bl) {
            if (this.isValid(calendarWeek, n)) {
                int n2 = n;
                return CalendarWeek.of(n2, Math.min(CalendarWeek.maximumOfWeek(n2), calendarWeek.week));
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }

        public ChronoElement<?> getChildAtFloor(CalendarWeek calendarWeek) {
            return WEEK_OF_YEAR;
        }

        public ChronoElement<?> getChildAtCeiling(CalendarWeek calendarWeek) {
            return WEEK_OF_YEAR;
        }

        public int getInt(CalendarWeek calendarWeek) {
            return calendarWeek.year;
        }

        public boolean isValid(CalendarWeek calendarWeek, int n) {
            return n >= -999999999 && n <= 999999999;
        }

        public CalendarWeek withValue(CalendarWeek calendarWeek, int n, boolean bl) {
            if (this.isValid(calendarWeek, n)) {
                int n2 = calendarWeek.week;
                if (n2 == 53) {
                    n2 = Math.min(CalendarWeek.maximumOfWeek(n), calendarWeek.week);
                }
                return CalendarWeek.of(n, n2);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }
    }

    private static class Merger
    implements ChronoMerger<CalendarWeek> {
        private Merger() {
        }

        public CalendarWeek createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                timezone = Timezone.of((TZID)((TZID)attributeQuery.get(Attributes.TIMEZONE_ID)));
            } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
                timezone = Timezone.ofSystem();
            } else {
                return null;
            }
            PlainDate plainDate = Moment.from((UnixTime)timeSource.currentTime()).toZonalTimestamp(timezone.getID()).toDate();
            return CalendarWeek.of(plainDate.getInt(YEAR_OF_WEEKDATE), plainDate.getInt(WEEK_OF_YEAR));
        }

        public CalendarWeek createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        public CalendarWeek createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = chronoEntity.getInt(YEAR_OF_WEEKDATE);
            int n2 = chronoEntity.getInt(WEEK_OF_YEAR);
            if (n >= -999999999 && n <= 999999999 && n2 >= 1 && n2 <= CalendarWeek.maximumOfWeek(n)) {
                return CalendarWeek.of(n, n2);
            }
            if (n > Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)("Year out of bounds: " + n));
            } else if (n2 > Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)("Week-of-year out of bounds: " + n2));
            }
            return null;
        }
    }
}

