/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import net.time4j.CalendarUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.Quarter;
import net.time4j.SystemClock;
import net.time4j.base.GregorianDate;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDate;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoMerger;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.Chronology;
import net.time4j.engine.DisplayStyle;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.engine.IntElementRule;
import net.time4j.engine.StartOfDay;
import net.time4j.engine.ValidationElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.CalendarType;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedPatternSupport;
import net.time4j.range.Boundary;
import net.time4j.range.FixedCalendarInterval;
import net.time4j.range.Quarters;
import net.time4j.range.SPX;
import net.time4j.range.Years;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

@CalendarType(value="iso8601")
public final class CalendarQuarter
extends FixedCalendarInterval<CalendarQuarter>
implements LocalizedPatternSupport {
    @FormattableElement(format="u")
    public static final ChronoElement<Integer> YEAR = PlainDate.YEAR;
    @FormattableElement(format="Q", standalone="q")
    public static final ChronoElement<Quarter> QUARTER_OF_YEAR = PlainDate.QUARTER_OF_YEAR;
    private static final Chronology<CalendarQuarter> ENGINE = Chronology.Builder.setUp(CalendarQuarter.class, (ChronoMerger)new Merger()).appendElement(YEAR, (ElementRule)new YearRule()).appendElement(QUARTER_OF_YEAR, (ElementRule)new QuarterRule()).build();
    private static final long serialVersionUID = -4871348693353897858L;
    private final transient int year;
    private final transient Quarter quarter;
    private final transient Boundary<PlainDate> start;
    private final transient Boundary<PlainDate> end;

    private CalendarQuarter(int n, Quarter quarter) {
        if (n < -999999999 || n > 999999999) {
            throw new IllegalArgumentException("Year out of bounds: " + n);
        }
        if (quarter == null) {
            throw new NullPointerException("Missing quarter of calendar year.");
        }
        this.year = n;
        this.quarter = quarter;
        PlainDate plainDate = (PlainDate)PlainDate.of((int)this.year, (int)1, (int)1).with(QUARTER_OF_YEAR, (Object)quarter);
        this.start = Boundary.ofClosed(plainDate);
        this.end = Boundary.ofClosed(plainDate.with((ChronoOperator)PlainDate.DAY_OF_QUARTER.maximized()));
    }

    public static CalendarQuarter of(int n, Quarter quarter) {
        return new CalendarQuarter(n, quarter);
    }

    public static CalendarQuarter nowInSystemTime() {
        return (CalendarQuarter)SystemClock.inLocalView().now(CalendarQuarter.chronology());
    }

    public PlainDate atDayOfQuarter(int n) {
        if (n == 1) {
            return this.start.getTemporal();
        }
        return (PlainDate)this.start.getTemporal().with((ChronoElement)PlainDate.DAY_OF_QUARTER, n);
    }

    public PlainDate atEndOfQuarter() {
        return this.end.getTemporal();
    }

    public int getYear() {
        return this.year;
    }

    public Quarter getQuarter() {
        return this.quarter;
    }

    @Override
    public Boundary<PlainDate> getStart() {
        return this.start;
    }

    @Override
    public Boundary<PlainDate> getEnd() {
        return this.end;
    }

    @Override
    public boolean contains(PlainDate plainDate) {
        return plainDate.getYear() == this.year && plainDate.get(QUARTER_OF_YEAR) == this.quarter;
    }

    @Override
    public boolean isAfter(PlainDate plainDate) {
        return this.start.getTemporal().isAfter((CalendarDate)plainDate);
    }

    @Override
    public boolean isBefore(PlainDate plainDate) {
        return this.end.getTemporal().isBefore((CalendarDate)plainDate);
    }

    public int length() {
        return (Integer)this.start.getTemporal().getMaximum((ChronoElement)PlainDate.DAY_OF_QUARTER);
    }

    public static CalendarQuarter from(GregorianDate gregorianDate) {
        PlainDate plainDate = PlainDate.from((GregorianDate)gregorianDate);
        return CalendarQuarter.of(plainDate.getYear(), (Quarter)plainDate.get((ChronoElement)PlainDate.QUARTER_OF_YEAR));
    }

    public CalendarQuarter plus(Years<CalendarUnit> years) {
        if (years.isEmpty()) {
            return this;
        }
        return CalendarQuarter.of(MathUtils.safeAdd((int)this.year, (int)years.getAmount()), this.quarter);
    }

    public CalendarQuarter plus(Quarters quarters) {
        if (quarters.isEmpty()) {
            return this;
        }
        long l = (long)this.year * 4L + (long)this.quarter.getValue() - 1L + (long)quarters.getAmount();
        int n = MathUtils.safeCast((long)MathUtils.floorDivide((long)l, (int)4));
        Quarter quarter = Quarter.valueOf((int)(MathUtils.floorModulo((long)l, (int)4) + 1));
        return CalendarQuarter.of(n, quarter);
    }

    public CalendarQuarter minus(Years<CalendarUnit> years) {
        if (years.isEmpty()) {
            return this;
        }
        return CalendarQuarter.of(MathUtils.safeSubtract((int)this.year, (int)years.getAmount()), this.quarter);
    }

    public CalendarQuarter minus(Quarters quarters) {
        if (quarters.isEmpty()) {
            return this;
        }
        long l = (long)this.year * 4L + (long)this.quarter.getValue() - 1L - (long)quarters.getAmount();
        int n = MathUtils.safeCast((long)MathUtils.floorDivide((long)l, (int)4));
        Quarter quarter = Quarter.valueOf((int)(MathUtils.floorModulo((long)l, (int)4) + 1));
        return CalendarQuarter.of(n, quarter);
    }

    @Override
    public int compareTo(CalendarQuarter calendarQuarter) {
        if (this.year < calendarQuarter.year) {
            return -1;
        }
        if (this.year > calendarQuarter.year) {
            return 1;
        }
        return this.quarter.compareTo((Enum)calendarQuarter.quarter);
    }

    @Override
    public Iterator<PlainDate> iterator() {
        return new Iter();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof CalendarQuarter) {
            CalendarQuarter calendarQuarter = (CalendarQuarter)object;
            return this.year == calendarQuarter.year && this.quarter == calendarQuarter.quarter;
        }
        return false;
    }

    public int hashCode() {
        return this.year ^ this.quarter.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        CalendarQuarter.formatYear(stringBuilder, this.year);
        stringBuilder.append("-Q");
        stringBuilder.append(this.quarter.getValue());
        return stringBuilder.toString();
    }

    public static Chronology<CalendarQuarter> chronology() {
        return ENGINE;
    }

    protected Chronology<CalendarQuarter> getChronology() {
        return ENGINE;
    }

    protected CalendarQuarter getContext() {
        return this;
    }

    private Object writeReplace() {
        return new SPX(this, 37);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private class Iter
    implements Iterator<PlainDate> {
        private PlainDate current;

        private Iter() {
            this.current = (PlainDate)CalendarQuarter.this.start.getTemporal();
        }

        @Override
        public boolean hasNext() {
            return this.current != null;
        }

        @Override
        public PlainDate next() {
            if (this.current == null) {
                throw new NoSuchElementException();
            }
            PlainDate plainDate = this.current;
            PlainDate plainDate2 = (PlainDate)plainDate.plus(1L, (Object)CalendarUnit.DAYS);
            this.current = plainDate2.isAfter((CalendarDate)CalendarQuarter.this.end.getTemporal()) ? null : plainDate2;
            return plainDate;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class QuarterRule
    implements ElementRule<CalendarQuarter, Quarter> {
        private QuarterRule() {
        }

        public Quarter getValue(CalendarQuarter calendarQuarter) {
            return calendarQuarter.quarter;
        }

        public Quarter getMinimum(CalendarQuarter calendarQuarter) {
            return Quarter.Q1;
        }

        public Quarter getMaximum(CalendarQuarter calendarQuarter) {
            return Quarter.Q4;
        }

        public boolean isValid(CalendarQuarter calendarQuarter, Quarter quarter) {
            return quarter != null;
        }

        public CalendarQuarter withValue(CalendarQuarter calendarQuarter, Quarter quarter, boolean bl) {
            if (this.isValid(calendarQuarter, quarter)) {
                return CalendarQuarter.of(calendarQuarter.year, quarter);
            }
            throw new IllegalArgumentException("Not valid: " + quarter);
        }

        public ChronoElement<?> getChildAtFloor(CalendarQuarter calendarQuarter) {
            return null;
        }

        public ChronoElement<?> getChildAtCeiling(CalendarQuarter calendarQuarter) {
            return null;
        }
    }

    private static class YearRule
    implements IntElementRule<CalendarQuarter> {
        private YearRule() {
        }

        public Integer getValue(CalendarQuarter calendarQuarter) {
            return calendarQuarter.year;
        }

        public Integer getMinimum(CalendarQuarter calendarQuarter) {
            return -999999999;
        }

        public Integer getMaximum(CalendarQuarter calendarQuarter) {
            return 999999999;
        }

        public boolean isValid(CalendarQuarter calendarQuarter, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= -999999999 && n2 <= 999999999;
        }

        public CalendarQuarter withValue(CalendarQuarter calendarQuarter, Integer n, boolean bl) {
            if (this.isValid(calendarQuarter, n)) {
                return CalendarQuarter.of(n, calendarQuarter.quarter);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }

        public ChronoElement<?> getChildAtFloor(CalendarQuarter calendarQuarter) {
            return QUARTER_OF_YEAR;
        }

        public ChronoElement<?> getChildAtCeiling(CalendarQuarter calendarQuarter) {
            return QUARTER_OF_YEAR;
        }

        public int getInt(CalendarQuarter calendarQuarter) {
            return calendarQuarter.year;
        }

        public boolean isValid(CalendarQuarter calendarQuarter, int n) {
            return n >= -999999999 && n <= 999999999;
        }

        public CalendarQuarter withValue(CalendarQuarter calendarQuarter, int n, boolean bl) {
            if (this.isValid(calendarQuarter, n)) {
                return CalendarQuarter.of(n, calendarQuarter.quarter);
            }
            throw new IllegalArgumentException("Not valid: " + n);
        }
    }

    private static class Merger
    implements ChronoMerger<CalendarQuarter> {
        private Merger() {
        }

        public CalendarQuarter createFrom(TimeSource<?> timeSource, AttributeQuery attributeQuery) {
            Timezone timezone;
            if (attributeQuery.contains(Attributes.TIMEZONE_ID)) {
                timezone = Timezone.of((TZID)((TZID)attributeQuery.get(Attributes.TIMEZONE_ID)));
            } else if (((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax()) {
                timezone = Timezone.ofSystem();
            } else {
                return null;
            }
            PlainDate plainDate = Moment.from((UnixTime)timeSource.currentTime()).toZonalTimestamp(timezone.getID()).toDate();
            return CalendarQuarter.of(plainDate.getYear(), (Quarter)plainDate.get(QUARTER_OF_YEAR));
        }

        public CalendarQuarter createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl) {
            boolean bl2 = ((Leniency)attributeQuery.get(Attributes.LENIENCY, (Object)Leniency.SMART)).isLax();
            return this.createFrom((ChronoEntity)chronoEntity, attributeQuery, bl2, bl);
        }

        public CalendarQuarter createFrom(ChronoEntity<?> chronoEntity, AttributeQuery attributeQuery, boolean bl, boolean bl2) {
            int n = chronoEntity.getInt(YEAR);
            if (n >= -999999999 && n <= 999999999 && chronoEntity.contains(QUARTER_OF_YEAR)) {
                return CalendarQuarter.of(n, (Quarter)chronoEntity.get(QUARTER_OF_YEAR));
            }
            if (n > Integer.MIN_VALUE) {
                chronoEntity.with((ChronoElement)ValidationElement.ERROR_MESSAGE, (Object)("Year out of bounds: " + n));
            }
            return null;
        }

        public ChronoDisplay preformat(CalendarQuarter calendarQuarter, AttributeQuery attributeQuery) {
            return calendarQuarter;
        }

        public Chronology<?> preparser() {
            return null;
        }

        public String getFormatPattern(DisplayStyle displayStyle, Locale locale) {
            Map map = CalendarText.getIsoInstance((Locale)locale).getTextForms();
            String string = null;
            switch (displayStyle.getStyleValue()) {
                case 0: {
                    string = "F_yQQQQ";
                    break;
                }
                case 1: {
                    string = "F_yQQQ";
                    break;
                }
                case 2: {
                    string = "F_yQQ";
                    break;
                }
                case 3: {
                    string = "F_yQ";
                }
            }
            String string2 = Merger.getFormatPattern(map, string);
            return string2 == null ? "uuuu-'Q'Q" : string2;
        }

        public StartOfDay getDefaultStartOfDay() {
            return StartOfDay.MIDNIGHT;
        }

        private static String getFormatPattern(Map<String, String> map, String string) {
            if (map.containsKey(string)) {
                return map.get(string);
            }
            if (string.equals("F_yQQQQ")) {
                return Merger.getFormatPattern(map, "F_yQQQ");
            }
            if (string.equals("F_yQQQ")) {
                return Merger.getFormatPattern(map, "F_yQQ");
            }
            if (string.equals("F_yQQ")) {
                return Merger.getFormatPattern(map, "F_yQ");
            }
            return null;
        }
    }
}

