/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.util.Comparator;
import java.util.List;
import net.time4j.engine.TimeLine;
import net.time4j.range.Boundary;
import net.time4j.range.ChronoInterval;
import net.time4j.range.IntervalCollection;
import net.time4j.range.IntervalComparator;
import net.time4j.range.SPX;
import net.time4j.range.SimpleInterval;

final class GenericWindows<T>
extends IntervalCollection<T> {
    private static final long serialVersionUID = 7068295351485872982L;
    private final transient TimeLine<T> timeLine;

    GenericWindows(TimeLine<T> timeLine, List<ChronoInterval<T>> list) {
        super(list);
        if (timeLine == null) {
            throw new NullPointerException("Missing timeline.");
        }
        this.timeLine = timeLine;
    }

    @Override
    ChronoInterval<T> newInterval(Boundary<T> boundary, Boundary<T> boundary2) {
        SimpleInterval.Factory<T> factory = SimpleInterval.onTimeLine(this.timeLine);
        if (boundary.isInfinite()) {
            Object object = boundary2.getTemporal();
            if (object != null && boundary2.isClosed()) {
                object = this.timeLine.stepForward(object);
            }
            if (object == null) {
                return new SimpleInterval<T>(boundary, Boundary.infiniteFuture(), this.timeLine);
            }
            return factory.until(object);
        }
        if (boundary2.isInfinite()) {
            Object object = boundary.getTemporal();
            if (boundary.isOpen()) {
                object = this.timeLine.stepForward(object);
            }
            return factory.since(object);
        }
        Object object = boundary.getTemporal();
        if (boundary.isOpen()) {
            object = this.timeLine.stepForward(object);
        }
        Object object2 = boundary2.getTemporal();
        if (boundary2.isClosed()) {
            object2 = this.timeLine.stepForward(object2);
        }
        return factory.between(object, object2);
    }

    @Override
    Comparator<ChronoInterval<T>> getComparator() {
        return new IntervalComparator<T>(false, this.timeLine);
    }

    @Override
    IntervalCollection<T> create(List<ChronoInterval<T>> list) {
        return new GenericWindows<T>(this.timeLine, list);
    }

    @Override
    TimeLine<T> getTimeLine() {
        return this.timeLine;
    }

    private Object writeReplace() {
        return new SPX(this, 44);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }
}

