/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.ElementOperator;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.ValueOperator;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.StdOperator;

final class DateOperator
extends ElementOperator<PlainDate> {
    private final Object opDelegate;

    DateOperator(ChronoElement<?> chronoElement, int n) {
        this(chronoElement, n, null);
    }

    DateOperator(ChronoElement<?> chronoElement, int n, Object object) {
        super(chronoElement, n);
        switch (n) {
            case -1: {
                this.opDelegate = DateOperator.newValue(chronoElement, object);
                break;
            }
            case 0: {
                this.opDelegate = StdOperator.minimized(chronoElement);
                break;
            }
            case 1: {
                this.opDelegate = StdOperator.maximized(chronoElement);
                break;
            }
            case 2: {
                this.opDelegate = StdOperator.decremented(chronoElement);
                break;
            }
            case 3: {
                this.opDelegate = StdOperator.incremented(chronoElement);
                break;
            }
            case 4: {
                this.opDelegate = StdOperator.atFloor(chronoElement);
                break;
            }
            case 5: {
                this.opDelegate = StdOperator.atCeiling(chronoElement);
                break;
            }
            case 6: {
                this.opDelegate = DateOperator.lenient(chronoElement, object);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown: " + this.getType()));
            }
        }
    }

    @Override
    public PlainDate apply(PlainDate plainDate) {
        ChronoOperator chronoOperator = (ChronoOperator)this.opDelegate;
        return chronoOperator.apply(plainDate);
    }

    @Override
    ChronoOperator<PlainTimestamp> onTimestamp() {
        return (ChronoOperator)this.opDelegate;
    }

    private static <V, T extends ChronoEntity<T>> Object newValue(ChronoElement<V> chronoElement, Object object) {
        V v = chronoElement.getType().cast(object);
        ChronoOperator chronoOperator = StdOperator.newValue(v, chronoElement);
        return ValueOperator.of(chronoOperator, object);
    }

    private static <V, T extends ChronoEntity<T>> Object lenient(ChronoElement<V> chronoElement, Object object) {
        V v = chronoElement.getType().cast(object);
        ChronoOperator chronoOperator = StdOperator.setLenient(v, chronoElement);
        return ValueOperator.of(chronoOperator, object);
    }
}

