/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.IsoDateUnit;
import net.time4j.OverflowPolicy;
import net.time4j.OverflowUnit;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.YOWElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimePoint;
import net.time4j.engine.UnitRule;

public enum CalendarUnit implements IsoDateUnit
{
    MILLENNIA{

        @Override
        public char getSymbol() {
            return 'I';
        }

        @Override
        public double getLength() {
            return 3.1556952E10;
        }
    }
    ,
    CENTURIES{

        @Override
        public char getSymbol() {
            return 'C';
        }

        @Override
        public double getLength() {
            return 3.1556952E9;
        }
    }
    ,
    DECADES{

        @Override
        public char getSymbol() {
            return 'E';
        }

        @Override
        public double getLength() {
            return 3.1556952E8;
        }
    }
    ,
    YEARS{

        @Override
        public char getSymbol() {
            return 'Y';
        }

        @Override
        public double getLength() {
            return 3.1556952E7;
        }
    }
    ,
    QUARTERS{

        @Override
        public char getSymbol() {
            return 'Q';
        }

        @Override
        public double getLength() {
            return 7889238.0;
        }
    }
    ,
    MONTHS{

        @Override
        public char getSymbol() {
            return 'M';
        }

        @Override
        public double getLength() {
            return 2629746.0;
        }
    }
    ,
    WEEKS{

        @Override
        public char getSymbol() {
            return 'W';
        }

        @Override
        public double getLength() {
            return 604800.0;
        }
    }
    ,
    DAYS{

        @Override
        public char getSymbol() {
            return 'D';
        }

        @Override
        public double getLength() {
            return 86400.0;
        }
    };

    private final IsoDateUnit eof = new OverflowUnit(this, OverflowPolicy.END_OF_MONTH);
    private final IsoDateUnit kld = new OverflowUnit(this, OverflowPolicy.KEEPING_LAST_DATE);
    private final IsoDateUnit ui = new OverflowUnit(this, OverflowPolicy.UNLESS_INVALID);
    private final IsoDateUnit nvd = new OverflowUnit(this, OverflowPolicy.NEXT_VALID_DATE);
    private final IsoDateUnit co = new OverflowUnit(this, OverflowPolicy.CARRY_OVER);

    public <T extends TimePoint<? super CalendarUnit, T>> long between(T t, T t2) {
        return t.until(t2, (CalendarUnit)this);
    }

    @Override
    public boolean isCalendrical() {
        return true;
    }

    public IsoDateUnit nextValidDate() {
        switch (this) {
            case WEEKS: 
            case DAYS: {
                return this;
            }
        }
        return this.nvd;
    }

    public IsoDateUnit withCarryOver() {
        switch (this) {
            case WEEKS: 
            case DAYS: {
                return this;
            }
        }
        return this.co;
    }

    public IsoDateUnit unlessInvalid() {
        switch (this) {
            case WEEKS: 
            case DAYS: {
                return this;
            }
        }
        return this.ui;
    }

    public IsoDateUnit atEndOfMonth() {
        return this.eof;
    }

    public IsoDateUnit keepingEndOfMonth() {
        return this.kld;
    }

    public static IsoDateUnit weekBasedYears() {
        return YOWElement.YOWUnit.WEEK_BASED_YEARS;
    }

    static class Rule<T extends ChronoEntity<T>>
    implements UnitRule<T> {
        private final CalendarUnit unit;
        private final OverflowPolicy policy;

        Rule(CalendarUnit calendarUnit) {
            this(calendarUnit, OverflowPolicy.PREVIOUS_VALID_DATE);
        }

        Rule(CalendarUnit calendarUnit, OverflowPolicy overflowPolicy) {
            this.unit = calendarUnit;
            this.policy = overflowPolicy;
        }

        @Override
        public T addTo(T t, long l) {
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            plainDate = PlainDate.doAdd(this.unit, plainDate, l, this.policy);
            return ((ChronoEntity)t).with(PlainDate.CALENDAR_DATE, (PlainDate)plainDate);
        }

        @Override
        public long between(T t, T t2) {
            long l;
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            PlainDate plainDate2 = ((ChronoEntity)t2).get(PlainDate.CALENDAR_DATE);
            switch (this.unit) {
                case MILLENNIA: {
                    l = Rule.monthDelta(plainDate, plainDate2) / 12000L;
                    break;
                }
                case CENTURIES: {
                    l = Rule.monthDelta(plainDate, plainDate2) / 1200L;
                    break;
                }
                case DECADES: {
                    l = Rule.monthDelta(plainDate, plainDate2) / 120L;
                    break;
                }
                case YEARS: {
                    l = Rule.monthDelta(plainDate, plainDate2) / 12L;
                    break;
                }
                case QUARTERS: {
                    l = Rule.monthDelta(plainDate, plainDate2) / 3L;
                    break;
                }
                case MONTHS: {
                    l = Rule.monthDelta(plainDate, plainDate2);
                    break;
                }
                case WEEKS: {
                    l = Rule.dayDelta(plainDate, plainDate2) / 7L;
                    break;
                }
                case DAYS: {
                    l = Rule.dayDelta(plainDate, plainDate2);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException(this.unit.name());
                }
            }
            if (l != 0L && ((ChronoEntity)t).contains(PlainTime.WALL_TIME) && ((ChronoEntity)t2).contains(PlainTime.WALL_TIME)) {
                PlainTime plainTime = ((ChronoEntity)t).get(PlainTime.WALL_TIME);
                PlainTime plainTime2 = ((ChronoEntity)t2).get(PlainTime.WALL_TIME);
                if (l > 0L && plainTime.isAfter(plainTime2)) {
                    --l;
                } else if (l < 0L && plainTime.isBefore(plainTime2)) {
                    ++l;
                }
            }
            return l;
        }

        private static long monthDelta(PlainDate plainDate, PlainDate plainDate2) {
            long l = plainDate2.getEpochMonths() - plainDate.getEpochMonths();
            if (l > 0L && plainDate2.getDayOfMonth() < plainDate.getDayOfMonth()) {
                --l;
            } else if (l < 0L && plainDate2.getDayOfMonth() > plainDate.getDayOfMonth()) {
                ++l;
            }
            return l;
        }

        private static long dayDelta(PlainDate plainDate, PlainDate plainDate2) {
            if (plainDate.getYear() == plainDate2.getYear()) {
                return plainDate2.getDayOfYear() - plainDate.getDayOfYear();
            }
            return plainDate2.getDaysSinceUTC() - plainDate.getDaysSinceUTC();
        }
    }
}

