/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.ElementRule;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;

public final class StdOperator<T extends ChronoEntity<T>>
implements ChronoOperator<T> {
    private static final int NEW_VALUE_MODE = 0;
    private static final int MIN_MODE = 1;
    private static final int MAX_MODE = 2;
    private static final int FLOOR_MODE = 3;
    private static final int CEILING_MODE = 4;
    private static final int LENIENT_MODE = 5;
    private static final int DECREMENTING_MODE = 6;
    private static final int INCREMENTING_MODE = 7;
    private final int mode;
    private final ChronoElement<?> element;
    private final Object value;

    private StdOperator(int n, ChronoElement<?> chronoElement) {
        this(n, chronoElement, null);
    }

    private StdOperator(int n, ChronoElement<?> chronoElement, Object object) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        this.mode = n;
        this.element = chronoElement;
        this.value = object;
    }

    @Override
    public T apply(T t) {
        switch (this.mode) {
            case 0: {
                return this.value((ChronoEntity<T>)t, this.element, this.value, false);
            }
            case 1: {
                return this.min((ChronoEntity<T>)t, this.element);
            }
            case 2: {
                return this.max((ChronoEntity<T>)t, this.element);
            }
            case 3: {
                return this.floor((ChronoEntity<T>)t, this.element);
            }
            case 4: {
                return this.ceiling((ChronoEntity<T>)t, this.element);
            }
            case 5: {
                return this.value((ChronoEntity<T>)t, this.element, this.value, true);
            }
            case 6: {
                return this.move(t, false);
            }
            case 7: {
                return this.move(t, true);
            }
        }
        throw new UnsupportedOperationException("Unknown mode: " + this.mode);
    }

    public static <T extends ChronoEntity<T>> ChronoOperator<T> minimized(ChronoElement<?> chronoElement) {
        return new StdOperator<T>(1, chronoElement);
    }

    public static <T extends ChronoEntity<T>> ChronoOperator<T> maximized(ChronoElement<?> chronoElement) {
        return new StdOperator<T>(2, chronoElement);
    }

    public static <T extends ChronoEntity<T>> ChronoOperator<T> decremented(ChronoElement<?> chronoElement) {
        return new StdOperator<T>(6, chronoElement);
    }

    public static <T extends ChronoEntity<T>> ChronoOperator<T> incremented(ChronoElement<?> chronoElement) {
        return new StdOperator<T>(7, chronoElement);
    }

    public static <T extends ChronoEntity<T>> ChronoOperator<T> atFloor(ChronoElement<?> chronoElement) {
        return new StdOperator<T>(3, chronoElement);
    }

    public static <T extends ChronoEntity<T>> ChronoOperator<T> atCeiling(ChronoElement<?> chronoElement) {
        return new StdOperator<T>(4, chronoElement);
    }

    public static <T extends ChronoEntity<T>, V> ChronoOperator<T> setLenient(V v, ChronoElement<V> chronoElement) {
        return new StdOperator<T>(5, chronoElement, v);
    }

    public static <T extends ChronoEntity<T>, V> ChronoOperator<T> newValue(V v, ChronoElement<V> chronoElement) {
        return new StdOperator<T>(0, chronoElement, v);
    }

    private <V> T min(ChronoEntity<T> chronoEntity, ChronoElement<V> chronoElement) {
        return chronoEntity.with(chronoElement, chronoEntity.getMinimum(chronoElement));
    }

    private <V> T max(ChronoEntity<T> chronoEntity, ChronoElement<V> chronoElement) {
        return chronoEntity.with(chronoElement, chronoEntity.getMaximum(chronoElement));
    }

    private <V> T floor(ChronoEntity<T> chronoEntity, ChronoElement<V> chronoElement) {
        T t = chronoEntity.getContext();
        ChronoElement<Object> chronoElement2 = chronoElement;
        while ((chronoElement2 = ((ChronoEntity)t).getChronology().getRule(chronoElement2).getChildAtFloor(t)) != null) {
            t = this.withFloor(t, chronoElement2);
        }
        return t;
    }

    private <V> T ceiling(ChronoEntity<T> chronoEntity, ChronoElement<V> chronoElement) {
        T t = chronoEntity.getContext();
        ChronoElement<Object> chronoElement2 = chronoElement;
        while ((chronoElement2 = ((ChronoEntity)t).getChronology().getRule(chronoElement2).getChildAtCeiling(t)) != null) {
            t = this.withCeiling(t, chronoElement2);
        }
        return t;
    }

    private <V> T value(ChronoEntity<T> chronoEntity, ChronoElement<V> chronoElement, Object object, boolean bl) {
        T t = chronoEntity.getContext();
        return (T)((ChronoEntity)((ChronoEntity)t).getChronology().getRule(chronoElement).withValue(t, chronoElement.getType().cast(object), bl));
    }

    private <V> T withFloor(T t, ChronoElement<V> chronoElement) {
        ElementRule<T, V> elementRule = ((ChronoEntity)t).getChronology().getRule(chronoElement);
        return (T)((ChronoEntity)elementRule.withValue(t, elementRule.getMinimum(t), chronoElement.isLenient()));
    }

    private <V> T withCeiling(T t, ChronoElement<V> chronoElement) {
        ElementRule<T, V> elementRule = ((ChronoEntity)t).getChronology().getRule(chronoElement);
        return (T)((ChronoEntity)elementRule.withValue(t, elementRule.getMaximum(t), chronoElement.isLenient()));
    }

    private T move(T t, boolean bl) {
        if (t instanceof TimePoint) {
            TimePoint timePoint = (TimePoint)TimePoint.class.cast(t);
            T t2 = StdOperator.add(timePoint, this.element, bl);
            return (T)((ChronoEntity)((ChronoEntity)t).getChronology().getChronoType().cast(t2));
        }
        throw new ChronoException("Base units not supported by: " + ((ChronoEntity)t).getChronology().getChronoType());
    }

    private static <U, T extends TimePoint<U, T>> T add(TimePoint<U, T> timePoint, ChronoElement<?> chronoElement, boolean bl) {
        Object u = ((TimeAxis)timePoint.getChronology()).getBaseUnit(chronoElement);
        if (bl) {
            return timePoint.plus(1L, u);
        }
        return timePoint.minus(1L, u);
    }
}

