/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.Serializable;
import net.time4j.CalendarUnit;
import net.time4j.IsoDateUnit;
import net.time4j.PlainDate;
import net.time4j.engine.BasicUnit;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.UnitRule;

final class OverflowUnit
extends BasicUnit
implements IsoDateUnit,
Serializable {
    static final int POLICY_PREVIOUS_VALID_DATE = 0;
    static final int POLICY_NEXT_VALID_DATE = 1;
    static final int POLICY_END_OF_MONTH = 2;
    static final int POLICY_CARRY_OVER = 3;
    static final int POLICY_UNLESS_INVALID = 4;
    static final int POLICY_KEEPING_LAST_DATE = 5;
    private static final long serialVersionUID = 1988843503875912054L;
    private final CalendarUnit unit;
    private final int policy;

    OverflowUnit(CalendarUnit calendarUnit, int n) {
        this.unit = calendarUnit;
        this.policy = n;
    }

    @Override
    public char getSymbol() {
        return '\u0000';
    }

    @Override
    public double getLength() {
        return this.unit.getLength();
    }

    @Override
    public boolean isCalendrical() {
        return true;
    }

    @Override
    protected <T extends ChronoEntity<T>> UnitRule<T> derive(Chronology<T> chronology) {
        if (chronology.isRegistered(PlainDate.CALENDAR_DATE)) {
            return new CalendarUnit.Rule(this.unit, this.policy);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OverflowUnit) {
            OverflowUnit overflowUnit = (OverflowUnit)object;
            return this.unit == overflowUnit.unit && this.policy == overflowUnit.policy;
        }
        return false;
    }

    public int hashCode() {
        return 23 * this.unit.hashCode() + 37 * this.policy;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.unit.getSymbol());
        stringBuilder.append('-');
        switch (this.policy) {
            case 1: {
                stringBuilder.append("NEXT_VALID_DATE");
                break;
            }
            case 2: {
                stringBuilder.append("END_OF_MONTH");
                break;
            }
            case 3: {
                stringBuilder.append("CARRY_OVER");
                break;
            }
            case 4: {
                stringBuilder.append("UNLESS_INVALID");
                break;
            }
            case 5: {
                stringBuilder.append("KEEPING_LAST_DATE");
                break;
            }
            default: {
                stringBuilder.append("PREVIOUS_VALID_DATE");
            }
        }
        return stringBuilder.toString();
    }

    CalendarUnit getCalendarUnit() {
        return this.unit;
    }
}

