/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.ElementOperator;
import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.Quarter;
import net.time4j.base.GregorianMath;
import net.time4j.engine.ChronoOperator;

final class CalendarOperator
extends ElementOperator<PlainDate> {
    static final CalendarOperator FIRST_DAY_OF_NEXT_MONTH = new CalendarOperator(17);
    static final CalendarOperator FIRST_DAY_OF_NEXT_QUARTER = new CalendarOperator(18);
    static final CalendarOperator FIRST_DAY_OF_NEXT_YEAR = new CalendarOperator(19);
    static final CalendarOperator LAST_DAY_OF_PREVIOUS_MONTH = new CalendarOperator(20);
    static final CalendarOperator LAST_DAY_OF_PREVIOUS_QUARTER = new CalendarOperator(21);
    static final CalendarOperator LAST_DAY_OF_PREVIOUS_YEAR = new CalendarOperator(22);
    private final ChronoOperator<PlainTimestamp> tsop = new ChronoOperator<PlainTimestamp>(){

        @Override
        public PlainTimestamp apply(PlainTimestamp plainTimestamp) {
            PlainDate plainDate = CalendarOperator.this.doApply(plainTimestamp.getCalendarDate());
            return plainTimestamp.with(plainDate);
        }
    };

    private CalendarOperator(int n) {
        super(PlainDate.COMPONENT, n);
    }

    @Override
    public PlainDate apply(PlainDate plainDate) {
        return this.doApply(plainDate);
    }

    @Override
    ChronoOperator<PlainTimestamp> onTimestamp() {
        return this.tsop;
    }

    private PlainDate doApply(PlainDate plainDate) {
        int n = plainDate.getYear();
        int n2 = plainDate.getMonth();
        switch (this.getType()) {
            case 17: {
                if (++n2 >= 13) {
                    ++n;
                    n2 = 1;
                }
                return PlainDate.of(n, n2, 1);
            }
            case 18: {
                Quarter quarter = Month.valueOf(n2).getQuarterOfYear();
                Quarter quarter2 = quarter.next();
                n2 = Month.atStartOfQuarterYear(quarter2).getValue();
                if (quarter == Quarter.Q4) {
                    ++n;
                }
                return PlainDate.of(n, n2, 1);
            }
            case 19: {
                return PlainDate.of(++n, 1, 1);
            }
            case 20: {
                if (--n2 <= 0) {
                    --n;
                    n2 = 12;
                }
                return PlainDate.of(n, n2, GregorianMath.getLengthOfMonth(n, n2));
            }
            case 21: {
                Quarter quarter = Month.valueOf(n2).getQuarterOfYear();
                Quarter quarter3 = quarter.previous();
                n2 = Month.atEndOfQuarterYear(quarter3).getValue();
                if (quarter3 == Quarter.Q4) {
                    return PlainDate.of(--n, n2, 31);
                }
                if (quarter3 == Quarter.Q1) {
                    return PlainDate.of(n, n2, 31);
                }
                return PlainDate.of(n, n2, 30);
            }
            case 22: {
                return PlainDate.of(--n, 12, 31);
            }
        }
        throw new AssertionError((Object)("Unknown: " + this.getType()));
    }
}

