/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParsePosition;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.time4j.AbstractDateElement;
import net.time4j.AdjustableElement;
import net.time4j.ElementOperator;
import net.time4j.NavigableElement;
import net.time4j.NavigationOperator;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.SPX;
import net.time4j.Weekday;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.ResourceLoader;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.ElementRule;
import net.time4j.engine.FormattableElement;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.NumericalElement;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.WeekdataProvider;

public final class Weekmodel
implements Serializable {
    private static final int CALENDAR_WEEK_OF_YEAR = 0;
    private static final int CALENDAR_WEEK_OF_MONTH = 1;
    private static final int BOUNDED_WEEK_OF_YEAR = 2;
    private static final int BOUNDED_WEEK_OF_MONTH = 3;
    private static final Map<Locale, Weekmodel> CACHE = new ConcurrentHashMap<Locale, Weekmodel>();
    public static final Weekmodel ISO = new Weekmodel(Weekday.MONDAY, 4, Weekday.SATURDAY, Weekday.SUNDAY);
    private static final WeekdataProvider LOCALIZED_WEEKDATA;
    private static final long serialVersionUID = 7794495882610436763L;
    private final transient Weekday firstDayOfWeek;
    private final transient int minimalDaysInFirstWeek;
    private final transient Weekday startOfWeekend;
    private final transient Weekday endOfWeekend;
    private final transient AdjustableElement<Integer, PlainDate> woyElement;
    private final transient AdjustableElement<Integer, PlainDate> womElement;
    private final transient AdjustableElement<Integer, PlainDate> boundWoyElement;
    private final transient AdjustableElement<Integer, PlainDate> boundWomElement;
    private final transient NavigableElement<Weekday> dayOfWeekElement;
    private final transient Set<ChronoElement<?>> elements;
    private final transient ChronoCondition<GregorianDate> weekendCondition;

    private Weekmodel(Weekday weekday, int n, final Weekday weekday2, final Weekday weekday3) {
        if (weekday == null) {
            throw new NullPointerException("Missing first day of week.");
        }
        if (n < 1 || n > 7) {
            throw new IllegalArgumentException("Minimal days in first week out of range: " + n);
        }
        if (weekday2 == null) {
            throw new NullPointerException("Missing start of weekend.");
        }
        if (weekday3 == null) {
            throw new NullPointerException("Missing end of weekend.");
        }
        this.firstDayOfWeek = weekday;
        this.minimalDaysInFirstWeek = n;
        this.startOfWeekend = weekday2;
        this.endOfWeekend = weekday3;
        this.woyElement = new CalendarWeekElement("WEEK_OF_YEAR", 0);
        this.womElement = new CalendarWeekElement("WEEK_OF_MONTH", 1);
        this.boundWoyElement = new CalendarWeekElement("BOUNDED_WEEK_OF_YEAR", 2);
        this.boundWomElement = new CalendarWeekElement("BOUNDED_WEEK_OF_MONTH", 3);
        this.dayOfWeekElement = new DayOfWeekElement();
        this.weekendCondition = new ChronoCondition<GregorianDate>(){

            @Override
            public boolean test(GregorianDate gregorianDate) {
                int n;
                int n2;
                int n3 = gregorianDate.getYear();
                Weekday weekday = Weekday.valueOf(GregorianMath.getDayOfWeek(n3, n2 = gregorianDate.getMonth(), n = gregorianDate.getDayOfMonth()));
                return weekday == weekday2 || weekday == weekday3;
            }
        };
        HashSet<AdjustableElement<Integer, PlainDate>> hashSet = new HashSet<AdjustableElement<Integer, PlainDate>>();
        hashSet.add(this.woyElement);
        hashSet.add(this.womElement);
        hashSet.add(this.dayOfWeekElement);
        hashSet.add(this.boundWoyElement);
        hashSet.add(this.boundWomElement);
        this.elements = Collections.unmodifiableSet(hashSet);
    }

    public static Weekmodel of(Weekday weekday, int n) {
        return Weekmodel.of(weekday, n, Weekday.SATURDAY, Weekday.SUNDAY);
    }

    public static Weekmodel of(Weekday weekday, int n, Weekday weekday2, Weekday weekday3) {
        if (weekday == Weekday.MONDAY && n == 4 && weekday2 == Weekday.SATURDAY && weekday3 == Weekday.SUNDAY) {
            return ISO;
        }
        return new Weekmodel(weekday, n, weekday2, weekday3);
    }

    public static Weekmodel ofSystem() {
        return Weekmodel.of(Locale.getDefault());
    }

    public static Weekmodel of(Locale locale) {
        if (locale.getCountry().isEmpty()) {
            return ISO;
        }
        Weekmodel weekmodel = CACHE.get(locale);
        if (weekmodel != null) {
            return weekmodel;
        }
        WeekdataProvider weekdataProvider = LOCALIZED_WEEKDATA;
        if (weekdataProvider == null) {
            GregorianCalendar gregorianCalendar = new GregorianCalendar(locale);
            int n = gregorianCalendar.getFirstDayOfWeek();
            int n2 = n == 1 ? 7 : n - 1;
            return Weekmodel.of(Weekday.valueOf(n2), gregorianCalendar.getMinimalDaysInFirstWeek());
        }
        weekmodel = new Weekmodel(Weekday.valueOf(weekdataProvider.getFirstDayOfWeek(locale)), weekdataProvider.getMinimalDaysInFirstWeek(locale), Weekday.valueOf(weekdataProvider.getStartOfWeekend(locale)), Weekday.valueOf(weekdataProvider.getEndOfWeekend(locale)));
        if (CACHE.size() > 150) {
            CACHE.clear();
        }
        CACHE.put(locale, weekmodel);
        return weekmodel;
    }

    public Weekday getFirstDayOfWeek() {
        return this.firstDayOfWeek;
    }

    public int getMinimalDaysInFirstWeek() {
        return this.minimalDaysInFirstWeek;
    }

    public Weekday getStartOfWeekend() {
        return this.startOfWeekend;
    }

    public Weekday getEndOfWeekend() {
        return this.endOfWeekend;
    }

    public Weekday getFirstWorkday() {
        return this.getEndOfWeekend().next();
    }

    @FormattableElement(format="w")
    public AdjustableElement<Integer, PlainDate> weekOfYear() {
        return this.woyElement;
    }

    @FormattableElement(format="W")
    public AdjustableElement<Integer, PlainDate> weekOfMonth() {
        return this.womElement;
    }

    @FormattableElement(format="e", standalone="c")
    public NavigableElement<Weekday> localDayOfWeek() {
        return this.dayOfWeekElement;
    }

    public AdjustableElement<Integer, PlainDate> boundedWeekOfYear() {
        return this.boundWoyElement;
    }

    public AdjustableElement<Integer, PlainDate> boundedWeekOfMonth() {
        return this.boundWomElement;
    }

    public ChronoCondition<GregorianDate> weekend() {
        return this.weekendCondition;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Weekmodel) {
            Weekmodel weekmodel = (Weekmodel)object;
            return this.firstDayOfWeek == weekmodel.firstDayOfWeek && this.minimalDaysInFirstWeek == weekmodel.minimalDaysInFirstWeek && this.startOfWeekend == weekmodel.startOfWeekend && this.endOfWeekend == weekmodel.endOfWeekend;
        }
        return false;
    }

    public int hashCode() {
        return 17 * this.firstDayOfWeek.name().hashCode() + 37 * this.minimalDaysInFirstWeek;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(64);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append("[firstDayOfWeek=");
        stringBuilder.append(this.firstDayOfWeek);
        stringBuilder.append(",minimalDaysInFirstWeek=");
        stringBuilder.append(this.minimalDaysInFirstWeek);
        stringBuilder.append(",startOfWeekend=");
        stringBuilder.append(this.startOfWeekend);
        stringBuilder.append(",endOfWeekend=");
        stringBuilder.append(this.endOfWeekend);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    Set<ChronoElement<?>> getElements() {
        return this.elements;
    }

    static Weekday getDayOfWeek(long l) {
        return Weekday.valueOf(MathUtils.floorModulo(l + 5L, 7) + 1);
    }

    private Object writeReplace() {
        return new SPX(this, 3);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        WeekdataProvider weekdataProvider = null;
        Iterator<WeekdataProvider> iterator = ResourceLoader.getInstance().services(WeekdataProvider.class).iterator();
        if (iterator.hasNext()) {
            WeekdataProvider weekdataProvider2;
            weekdataProvider = weekdataProvider2 = iterator.next();
        }
        LOCALIZED_WEEKDATA = weekdataProvider;
    }

    private static class BWRule<T extends ChronoEntity<T>>
    implements ElementRule<T, Integer> {
        private final CalendarWeekElement owner;

        private BWRule(CalendarWeekElement calendarWeekElement) {
            this.owner = calendarWeekElement;
        }

        @Override
        public Integer getValue(T t) {
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            return this.getWeek(plainDate);
        }

        @Override
        public Integer getMinimum(T t) {
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            return this.getMinWeek(plainDate);
        }

        @Override
        public Integer getMaximum(T t) {
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            return this.getMaxWeek(plainDate);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(T t) {
            return this.getChild(t, false);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(T t) {
            return this.getChild(t, true);
        }

        private ChronoElement<?> getChild(T t, boolean bl) {
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            NavigableElement<Weekday> navigableElement = this.owner.getModel().localDayOfWeek();
            int n = this.getValue(t);
            if (bl) {
                if (n >= (this.owner.isYearRelated() ? 52 : 4)) {
                    PlainDate plainDate2 = (PlainDate)plainDate.with(navigableElement, ((ChronoEntity)t).getMaximum(navigableElement));
                    if (this.owner.isYearRelated()) {
                        if (plainDate2.getDayOfYear() < plainDate.getDayOfYear()) {
                            return PlainDate.DAY_OF_YEAR;
                        }
                    } else if (plainDate2.getDayOfMonth() < plainDate.getDayOfMonth()) {
                        return PlainDate.DAY_OF_MONTH;
                    }
                }
            } else if (n == 0) {
                PlainDate plainDate3 = (PlainDate)plainDate.with(navigableElement, ((ChronoEntity)t).getMinimum(navigableElement));
                if (this.owner.isYearRelated()) {
                    if (plainDate3.getDayOfYear() > plainDate.getDayOfYear()) {
                        return PlainDate.DAY_OF_YEAR;
                    }
                } else if (plainDate3.getDayOfMonth() > plainDate.getDayOfMonth()) {
                    return PlainDate.DAY_OF_MONTH;
                }
            }
            return navigableElement;
        }

        @Override
        public boolean isValid(T t, Integer n) {
            PlainDate plainDate;
            if (n == null) {
                return false;
            }
            int n2 = n;
            return n2 >= this.getMinWeek(plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE)) && n2 <= this.getMaxWeek(plainDate);
        }

        @Override
        public T withValue(T t, Integer n, boolean bl) {
            int n2 = n;
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            if (!bl && !this.isValid(t, n)) {
                throw new IllegalArgumentException("Invalid value: " + n2 + " (context=" + t + ")");
            }
            return ((ChronoEntity)t).with(PlainDate.CALENDAR_DATE, (PlainDate)this.setWeek(plainDate, n2));
        }

        private int getWeek(PlainDate plainDate) {
            return this.getWeek(plainDate, 0);
        }

        private int getMinWeek(PlainDate plainDate) {
            return this.getWeek(plainDate, -1);
        }

        private int getMaxWeek(PlainDate plainDate) {
            return this.getWeek(plainDate, 1);
        }

        private int getWeek(PlainDate plainDate, int n) {
            int n2;
            int n3 = this.owner.isYearRelated() ? plainDate.getDayOfYear() : plainDate.getDayOfMonth();
            Weekday weekday = Weekmodel.getDayOfWeek(plainDate.getDaysSinceUTC() - (long)n3 + 1L);
            int n4 = weekday.getValue(this.owner.getModel());
            int n5 = n4 <= 8 - this.owner.getModel().getMinimalDaysInFirstWeek() ? 2 - n4 : 9 - n4;
            switch (n) {
                case -1: {
                    n2 = 1;
                    break;
                }
                case 0: {
                    n2 = n3;
                    break;
                }
                case 1: {
                    n2 = this.getLengthOfYM(plainDate);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("Unexpected: " + n));
                }
            }
            return MathUtils.floorDivide(n2 - n5, 7) + 1;
        }

        private PlainDate setWeek(PlainDate plainDate, int n) {
            int n2 = this.getWeek(plainDate);
            if (n == n2) {
                return plainDate;
            }
            int n3 = 7 * (n - n2);
            return plainDate.withDaysSinceUTC(plainDate.getDaysSinceUTC() + (long)n3);
        }

        private int getLengthOfYM(PlainDate plainDate) {
            if (this.owner.isYearRelated()) {
                return GregorianMath.isLeapYear(plainDate.getYear()) ? 366 : 365;
            }
            return GregorianMath.getLengthOfMonth(plainDate.getYear(), plainDate.getMonth());
        }
    }

    private static class CWRule<T extends ChronoEntity<T>>
    implements ElementRule<T, Integer> {
        private final CalendarWeekElement owner;

        private CWRule(CalendarWeekElement calendarWeekElement) {
            this.owner = calendarWeekElement;
        }

        @Override
        public Integer getMinimum(T t) {
            return 1;
        }

        @Override
        public Integer getMaximum(T t) {
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            return this.getMaxCalendarWeek(plainDate);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(T t) {
            return this.getChild(t);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(T t) {
            return this.getChild(t);
        }

        private ChronoElement<?> getChild(T t) {
            return this.owner.getModel().localDayOfWeek();
        }

        @Override
        public Integer getValue(T t) {
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            return this.getCalendarWeek(plainDate);
        }

        @Override
        public boolean isValid(T t, Integer n) {
            if (n == null) {
                return false;
            }
            int n2 = n;
            if (this.owner.isYearRelated() && n2 >= 1 && n2 <= 52) {
                return true;
            }
            if (!this.owner.isYearRelated() || n2 == 53) {
                PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
                return n2 >= 1 && n2 <= this.getMaxCalendarWeek(plainDate);
            }
            return false;
        }

        @Override
        public T withValue(T t, Integer n, boolean bl) {
            int n2 = n;
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            if (!bl && !this.isValid(t, n)) {
                throw new IllegalArgumentException("Invalid value: " + n2 + " (context=" + t + ")");
            }
            return ((ChronoEntity)t).with(PlainDate.CALENDAR_DATE, (PlainDate)this.setCalendarWeek(plainDate, n2));
        }

        private int getMaxCalendarWeek(PlainDate plainDate) {
            int n = this.owner.isYearRelated() ? plainDate.getDayOfYear() : plainDate.getDayOfMonth();
            int n2 = this.getFirstCalendarWeekAsDay(plainDate, 0);
            if (n2 <= n) {
                int n3 = this.getFirstCalendarWeekAsDay(plainDate, 1) + this.getLengthOfYM(plainDate, 0);
                return (n3 - n2) / 7;
            }
            int n4 = this.getFirstCalendarWeekAsDay(plainDate, -1);
            return ((n2 += this.getLengthOfYM(plainDate, -1)) - n4) / 7;
        }

        private int getFirstCalendarWeekAsDay(PlainDate plainDate, int n) {
            Weekmodel weekmodel;
            Weekday weekday = this.getWeekdayStart(plainDate, n);
            int n2 = weekday.getValue(weekmodel = this.owner.getModel());
            return n2 <= 8 - weekmodel.getMinimalDaysInFirstWeek() ? 2 - n2 : 9 - n2;
        }

        private Weekday getWeekdayStart(PlainDate plainDate, int n) {
            if (this.owner.isYearRelated()) {
                return Weekday.valueOf(GregorianMath.getDayOfWeek(plainDate.getYear() + n, 1, 1));
            }
            int n2 = plainDate.getYear();
            int n3 = plainDate.getMonth() + n;
            if (n3 == 0) {
                n3 = 12;
                --n2;
            } else if (n3 == 13) {
                n3 = 1;
                ++n2;
            }
            return Weekday.valueOf(GregorianMath.getDayOfWeek(n2, n3, 1));
        }

        private int getLengthOfYM(PlainDate plainDate, int n) {
            if (this.owner.isYearRelated()) {
                return GregorianMath.isLeapYear(plainDate.getYear() + n) ? 366 : 365;
            }
            int n2 = plainDate.getYear();
            int n3 = plainDate.getMonth() + n;
            if (n3 == 0) {
                n3 = 12;
                --n2;
            } else if (n3 == 13) {
                n3 = 1;
                ++n2;
            }
            return GregorianMath.getLengthOfMonth(n2, n3);
        }

        private int getCalendarWeek(PlainDate plainDate) {
            int n = this.owner.isYearRelated() ? plainDate.getDayOfYear() : plainDate.getDayOfMonth();
            int n2 = this.getFirstCalendarWeekAsDay(plainDate, 0);
            if (n2 <= n) {
                int n3;
                int n4 = (n - n2) / 7 + 1;
                if ((n4 >= 53 || !this.owner.isYearRelated() && n4 >= 5) && (n3 = this.getFirstCalendarWeekAsDay(plainDate, 1) + this.getLengthOfYM(plainDate, 0)) <= n) {
                    n4 = 1;
                }
                return n4;
            }
            int n5 = this.getFirstCalendarWeekAsDay(plainDate, -1);
            int n6 = n + this.getLengthOfYM(plainDate, -1);
            return (n6 - n5) / 7 + 1;
        }

        private PlainDate setCalendarWeek(PlainDate plainDate, int n) {
            int n2 = this.getCalendarWeek(plainDate);
            if (n == n2) {
                return plainDate;
            }
            int n3 = 7 * (n - n2);
            return plainDate.withDaysSinceUTC(plainDate.getDaysSinceUTC() + (long)n3);
        }
    }

    private class CalendarWeekElement
    extends AbstractDateElement<Integer>
    implements NumericalElement<Integer> {
        private static final long serialVersionUID = -5936254509996557266L;
        private final int category;

        CalendarWeekElement(String string, int n) {
            super(string);
            this.category = n;
        }

        @Override
        public char getSymbol() {
            switch (this.category) {
                case 0: {
                    return 'w';
                }
                case 1: {
                    return 'W';
                }
            }
            return super.getSymbol();
        }

        @Override
        public Class<Integer> getType() {
            return Integer.class;
        }

        @Override
        public int numerical(Integer n) {
            return n;
        }

        @Override
        public Integer getDefaultMinimum() {
            return 1;
        }

        @Override
        public Integer getDefaultMaximum() {
            return this.isYearRelated() ? 52 : 5;
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public boolean isLenient() {
            return true;
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && this.getModel().equals(((CalendarWeekElement)object).getModel());
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + 37 * this.getModel().hashCode();
        }

        @Override
        protected ChronoElement<?> getParent() {
            return PlainDate.WEEKDAY_IN_MONTH;
        }

        @Override
        protected <T extends ChronoEntity<T>> ElementRule<T, Integer> derive(Chronology<T> chronology) {
            if (chronology.isRegistered(PlainDate.CALENDAR_DATE)) {
                if (this.isBounded()) {
                    return new BWRule(this);
                }
                return new CWRule(this);
            }
            return null;
        }

        private Object readResolve() throws ObjectStreamException {
            Weekmodel weekmodel = this.getModel();
            switch (this.category) {
                case 0: {
                    return weekmodel.weekOfYear();
                }
                case 1: {
                    return weekmodel.weekOfMonth();
                }
                case 2: {
                    return weekmodel.boundedWeekOfYear();
                }
                case 3: {
                    return weekmodel.boundedWeekOfMonth();
                }
            }
            throw new InvalidObjectException("Unknown category: " + this.category);
        }

        private Weekmodel getModel() {
            return Weekmodel.this;
        }

        private boolean isYearRelated() {
            return this.category % 2 == 0;
        }

        private boolean isBounded() {
            return this.category >= 2;
        }
    }

    private static class DRule<T extends ChronoEntity<T>>
    implements ElementRule<T, Weekday> {
        final DayOfWeekElement element;

        private DRule(DayOfWeekElement dayOfWeekElement) {
            this.element = dayOfWeekElement;
        }

        @Override
        public boolean isValid(T t, Weekday weekday) {
            return weekday != null;
        }

        @Override
        public Weekday getMinimum(T t) {
            return this.element.getDefaultMinimum();
        }

        @Override
        public Weekday getMaximum(T t) {
            return this.element.getDefaultMaximum();
        }

        @Override
        public ChronoElement<?> getChildAtFloor(T t) {
            return this.getChild(t);
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(T t) {
            return this.getChild(t);
        }

        private ChronoElement<?> getChild(T t) {
            if (((ChronoEntity)t).contains(PlainTime.WALL_TIME)) {
                return PlainTime.WALL_TIME;
            }
            return null;
        }

        @Override
        public Weekday getValue(T t) {
            return Weekmodel.getDayOfWeek(((ChronoEntity)t).get(PlainDate.CALENDAR_DATE).getDaysSinceUTC());
        }

        @Override
        public T withValue(T t, Weekday weekday, boolean bl) {
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            long l = plainDate.getDaysSinceUTC();
            Weekday weekday2 = Weekmodel.getDayOfWeek(l);
            if (weekday == weekday2) {
                return t;
            }
            int n = weekday2.getValue(this.element.getModel());
            int n2 = weekday.getValue(this.element.getModel());
            plainDate = plainDate.withDaysSinceUTC(l + (long)n2 - (long)n);
            return ((ChronoEntity)t).with(PlainDate.CALENDAR_DATE, (PlainDate)plainDate);
        }
    }

    private class DayOfWeekElement
    extends AbstractDateElement<Weekday>
    implements NavigableElement<Weekday>,
    NumericalElement<Weekday>,
    TextElement<Weekday> {
        private static final long serialVersionUID = 1945670789283677398L;

        DayOfWeekElement() {
            super("LOCAL_DAY_OF_WEEK");
        }

        @Override
        public Class<Weekday> getType() {
            return Weekday.class;
        }

        @Override
        public char getSymbol() {
            return 'e';
        }

        @Override
        public int numerical(Weekday weekday) {
            return weekday.getValue(Weekmodel.this);
        }

        @Override
        public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
            int n;
            int n2 = chronoDisplay.get(this).getValue(Weekmodel.this);
            return n2 < (n = chronoDisplay2.get(this).getValue(Weekmodel.this)) ? -1 : (n2 == n ? 0 : 1);
        }

        @Override
        public Weekday getDefaultMinimum() {
            return Weekmodel.this.getFirstDayOfWeek();
        }

        @Override
        public Weekday getDefaultMaximum() {
            return Weekmodel.this.getFirstDayOfWeek().roll(6);
        }

        @Override
        public boolean isDateElement() {
            return true;
        }

        @Override
        public boolean isTimeElement() {
            return false;
        }

        @Override
        public ElementOperator<PlainDate> setToNext(Weekday weekday) {
            return new NavigationOperator<Weekday>(this, 9, weekday);
        }

        @Override
        public ElementOperator<PlainDate> setToPrevious(Weekday weekday) {
            return new NavigationOperator<Weekday>(this, 10, weekday);
        }

        @Override
        public ElementOperator<PlainDate> setToNextOrSame(Weekday weekday) {
            return new NavigationOperator<Weekday>(this, 11, weekday);
        }

        @Override
        public ElementOperator<PlainDate> setToPreviousOrSame(Weekday weekday) {
            return new NavigationOperator<Weekday>(this, 12, weekday);
        }

        @Override
        public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
            appendable.append(this.accessor(attributeQuery).print(chronoDisplay.get(this)));
        }

        @Override
        public Weekday parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
            return this.accessor(attributeQuery).parse(charSequence, parsePosition, this.getType(), attributeQuery);
        }

        @Override
        public boolean equals(Object object) {
            return super.equals(object) && this.getModel().equals(((DayOfWeekElement)object).getModel());
        }

        @Override
        public int hashCode() {
            return 31 * super.hashCode() + 37 * this.getModel().hashCode();
        }

        @Override
        protected <T extends ChronoEntity<T>> ElementRule<T, Weekday> derive(Chronology<T> chronology) {
            if (chronology.isRegistered(PlainDate.CALENDAR_DATE)) {
                return new DRule(this);
            }
            return null;
        }

        @Override
        protected ChronoElement<?> getParent() {
            return PlainDate.DAY_OF_WEEK;
        }

        private TextAccessor accessor(AttributeQuery attributeQuery) {
            CalendarText calendarText = CalendarText.getInstance(attributeQuery.get(Attributes.CALENDAR_TYPE, "iso8601"), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
            return calendarText.getWeekdays(attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE), attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT));
        }

        private Weekmodel getModel() {
            return Weekmodel.this;
        }

        private Object readResolve() throws ObjectStreamException {
            return Weekmodel.this.localDayOfWeek();
        }
    }
}

