/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.util.Date;
import net.time4j.Moment;
import net.time4j.base.MathUtils;
import net.time4j.scale.TimeScale;

public abstract class TemporalType<S, T> {
    private static final int MIO = 1000000;
    public static final TemporalType<Date, Moment> JAVA_UTIL_DATE = new JavaUtilDateRule();
    public static final TemporalType<Long, Moment> MILLIS_SINCE_UNIX = new MillisSinceUnixRule();

    protected TemporalType() {
    }

    public abstract T translate(S var1);

    public abstract S from(T var1);

    private static class MillisSinceUnixRule
    extends TemporalType<Long, Moment> {
        private MillisSinceUnixRule() {
        }

        @Override
        public Moment translate(Long l) {
            long l2 = l;
            long l3 = MathUtils.floorDivide(l2, 1000);
            int n = MathUtils.floorModulo(l2, 1000) * 1000000;
            return Moment.of(l3, n, TimeScale.POSIX);
        }

        @Override
        public Long from(Moment moment) {
            long l = moment.getPosixTime();
            int n = moment.getNanosecond();
            return MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), (long)(n / 1000000));
        }
    }

    private static class JavaUtilDateRule
    extends TemporalType<Date, Moment> {
        private JavaUtilDateRule() {
        }

        @Override
        public Moment translate(Date date) {
            long l = date.getTime();
            long l2 = MathUtils.floorDivide(l, 1000);
            int n = MathUtils.floorModulo(l, 1000) * 1000000;
            return Moment.of(l2, n, TimeScale.POSIX);
        }

        @Override
        public Date from(Moment moment) {
            long l = moment.getPosixTime();
            int n = moment.getNanosecond();
            long l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), (long)(n / 1000000));
            return new Date(l2);
        }
    }
}

