/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.TimeZone;
import net.time4j.base.GregorianDate;
import net.time4j.base.GregorianMath;
import net.time4j.base.MathUtils;
import net.time4j.base.WallTime;
import net.time4j.tz.GapResolver;
import net.time4j.tz.OverlapResolver;
import net.time4j.tz.SPX;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionHistory;
import net.time4j.tz.TransitionStrategy;
import net.time4j.tz.ZonalOffset;
import net.time4j.tz.ZonalTransition;

final class TransitionResolver
implements TransitionStrategy,
Serializable {
    private static final Map<Integer, TransitionResolver> INSTANCES = new HashMap<Integer, TransitionResolver>();
    private static final String NO_HISTORY = "Timezone provider does not expose its transition history.";
    private static final long serialVersionUID = 1790434289322009750L;
    private final transient GapResolver gapResolver;
    private final transient OverlapResolver overlapResolver;

    private TransitionResolver(GapResolver gapResolver, OverlapResolver overlapResolver) {
        this.gapResolver = gapResolver;
        this.overlapResolver = overlapResolver;
    }

    @Override
    public long resolve(GregorianDate gregorianDate, WallTime wallTime, Timezone timezone) {
        int n = gregorianDate.getYear();
        int n2 = gregorianDate.getMonth();
        int n3 = gregorianDate.getDayOfMonth();
        int n4 = wallTime.getHour();
        int n5 = wallTime.getMinute();
        int n6 = wallTime.getSecond();
        TransitionHistory transitionHistory = timezone.getHistory();
        if (transitionHistory == null && this.overlapResolver == OverlapResolver.LATER_OFFSET && (this.gapResolver == GapResolver.PUSH_FORWARD || this.gapResolver == GapResolver.ABORT)) {
            TimeZone timeZone = TimeZone.getTimeZone(timezone.getID().canonical());
            GregorianCalendar gregorianCalendar = new GregorianCalendar(timeZone);
            gregorianCalendar.set(14, 0);
            gregorianCalendar.set(n, n2 - 1, n3, n4, n5, n6);
            int n7 = gregorianCalendar.get(1);
            int n8 = gregorianCalendar.get(2) + 1;
            int n9 = gregorianCalendar.get(5);
            int n10 = gregorianCalendar.get(11);
            int n11 = gregorianCalendar.get(12);
            int n12 = gregorianCalendar.get(13);
            if (this.gapResolver == GapResolver.ABORT && (n != n7 || n2 != n8 || n3 != n9 || n4 != n10 || n5 != n11 || n6 != n12)) {
                TransitionResolver.throwInvalidException(gregorianDate, wallTime, timezone);
            }
            long l = TransitionResolver.toLocalSeconds(n7, n8, n9, n10, n11, n12);
            return l - (long)timezone.getOffset(gregorianDate, wallTime).getIntegralAmount();
        }
        if (transitionHistory == null) {
            throw new UnsupportedOperationException(NO_HISTORY);
        }
        ZonalTransition zonalTransition = transitionHistory.getConflictTransition(gregorianDate, wallTime);
        if (zonalTransition != null) {
            if (zonalTransition.isGap()) {
                switch (this.gapResolver) {
                    case PUSH_FORWARD: {
                        long l = TransitionResolver.toLocalSeconds(n, n2, n3, n4, n5, n6);
                        return (l += (long)zonalTransition.getSize()) - (long)zonalTransition.getTotalOffset();
                    }
                    case NEXT_VALID_TIME: {
                        return zonalTransition.getPosixTime();
                    }
                    case ABORT: {
                        TransitionResolver.throwInvalidException(gregorianDate, wallTime, timezone);
                        break;
                    }
                    default: {
                        String string = this.gapResolver.name();
                        throw new UnsupportedOperationException(string);
                    }
                }
            } else if (zonalTransition.isOverlap()) {
                long l = TransitionResolver.toLocalSeconds(n, n2, n3, n4, n5, n6);
                int n13 = zonalTransition.getTotalOffset();
                if (this.overlapResolver == OverlapResolver.EARLIER_OFFSET) {
                    n13 = zonalTransition.getPreviousOffset();
                }
                return l - (long)n13;
            }
        }
        long l = TransitionResolver.toLocalSeconds(n, n2, n3, n4, n5, n6);
        ZonalOffset zonalOffset = transitionHistory.getValidOffsets(gregorianDate, wallTime).get(0);
        return l - (long)zonalOffset.getIntegralAmount();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public ZonalOffset getOffset(GregorianDate gregorianDate, WallTime wallTime, Timezone timezone) {
        TransitionHistory transitionHistory = timezone.getHistory();
        if (transitionHistory == null && this.overlapResolver == OverlapResolver.LATER_OFFSET && (this.gapResolver == GapResolver.PUSH_FORWARD || this.gapResolver == GapResolver.ABORT)) {
            if (this.gapResolver != GapResolver.ABORT || !timezone.isInvalid(gregorianDate, wallTime)) return timezone.getOffset(gregorianDate, wallTime);
            TransitionResolver.throwInvalidException(gregorianDate, wallTime, timezone);
            return timezone.getOffset(gregorianDate, wallTime);
        }
        if (transitionHistory == null) {
            throw new UnsupportedOperationException(NO_HISTORY);
        }
        ZonalTransition zonalTransition = transitionHistory.getConflictTransition(gregorianDate, wallTime);
        if (zonalTransition == null) return transitionHistory.getValidOffsets(gregorianDate, wallTime).get(0);
        int n = zonalTransition.getTotalOffset();
        if (zonalTransition.isGap()) {
            if (this.gapResolver != GapResolver.ABORT) return ZonalOffset.ofTotalSeconds(n);
            TransitionResolver.throwInvalidException(gregorianDate, wallTime, timezone);
            return transitionHistory.getValidOffsets(gregorianDate, wallTime).get(0);
        } else {
            if (!zonalTransition.isOverlap()) return transitionHistory.getValidOffsets(gregorianDate, wallTime).get(0);
            if (this.overlapResolver != OverlapResolver.EARLIER_OFFSET) return ZonalOffset.ofTotalSeconds(n);
            n = zonalTransition.getPreviousOffset();
            return ZonalOffset.ofTotalSeconds(n);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append(":[gap=");
        stringBuilder.append((Object)this.gapResolver);
        stringBuilder.append(",overlap=");
        stringBuilder.append((Object)this.overlapResolver);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    static TransitionResolver of(GapResolver gapResolver, OverlapResolver overlapResolver) {
        int n = gapResolver.ordinal() * 2 + overlapResolver.ordinal();
        return INSTANCES.get(n);
    }

    int getKey() {
        return this.gapResolver.ordinal() * 2 + this.overlapResolver.ordinal();
    }

    private static long toLocalSeconds(int n, int n2, int n3, int n4, int n5, int n6) {
        long l = MathUtils.safeMultiply(MathUtils.safeSubtract(GregorianMath.toMJD(n, n2, n3), 40587L), 86400L);
        return l += (long)(n4 * 3600 + n5 * 60 + n6);
    }

    private static void throwInvalidException(GregorianDate gregorianDate, WallTime wallTime, Timezone timezone) {
        throw new IllegalArgumentException("Invalid local timestamp due to timezone transition: local-date=" + gregorianDate + ", local-time=" + wallTime + " [" + timezone.getID() + "]");
    }

    private Object writeReplace() throws ObjectStreamException {
        return new SPX(this, 13);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    static {
        for (GapResolver gapResolver : GapResolver.values()) {
            for (OverlapResolver overlapResolver : OverlapResolver.values()) {
                TransitionResolver transitionResolver = new TransitionResolver(gapResolver, overlapResolver);
                int n = gapResolver.ordinal() * 2 + overlapResolver.ordinal();
                INSTANCES.put(n, transitionResolver);
            }
        }
    }
}

