/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.engine.AttributeKey;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoDisplay;
import net.time4j.format.Leniency;
import net.time4j.format.NumberSymbolProvider;
import net.time4j.format.OutputContext;
import net.time4j.format.PredefinedKey;
import net.time4j.format.TextWidth;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.TransitionStrategy;

public final class Attributes
implements AttributeQuery {
    private static final NumberSymbolProvider NUMBER_SYMBOLS;
    public static final AttributeKey<String> CALENDAR_TYPE;
    public static final AttributeKey<Locale> LANGUAGE;
    public static final AttributeKey<TZID> TIMEZONE_ID;
    public static final AttributeKey<TransitionStrategy> TRANSITION_STRATEGY;
    public static final AttributeKey<Leniency> LENIENCY;
    public static final AttributeKey<TextWidth> TEXT_WIDTH;
    public static final AttributeKey<OutputContext> OUTPUT_CONTEXT;
    public static final AttributeKey<Boolean> PARSE_CASE_INSENSITIVE;
    public static final AttributeKey<Boolean> PARSE_PARTIAL_COMPARE;
    public static final AttributeKey<Character> ZERO_DIGIT;
    public static final AttributeKey<Character> DECIMAL_SEPARATOR;
    public static final AttributeKey<Character> PAD_CHAR;
    public static final AttributeKey<Integer> PIVOT_YEAR;
    public static final AttributeKey<Boolean> TRAILING_CHARACTERS;
    public static final AttributeKey<Integer> PROTECTED_CHARACTERS;
    static final AttributeKey<Locale> LOCALE;
    static final AttributeKey<Boolean> OPTIONAL;
    static final AttributeKey<Integer> LEVEL;
    static final AttributeKey<Integer> SECTION;
    private static final char ISO_DECIMAL_SEPARATOR;
    private static final ConcurrentMap<Locale, NumericalSymbols> NUMBER_SYMBOL_CACHE;
    private static final NumericalSymbols DEFAULT_NUMERICAL_SYMBOLS;
    private static final AttributeQuery EMPTY;
    private final Map<String, Object> attributes;
    private final ChronoCondition<ChronoDisplay> printCondition;

    private Attributes(Map<String, Object> map, ChronoCondition<ChronoDisplay> chronoCondition) {
        this.attributes = Collections.unmodifiableMap(new HashMap<String, Object>(map));
        this.printCondition = chronoCondition;
    }

    public static AttributeQuery empty() {
        return EMPTY;
    }

    @Override
    public boolean contains(AttributeKey<?> attributeKey) {
        return this.attributes.containsKey(attributeKey.name());
    }

    @Override
    public <A> A get(AttributeKey<A> attributeKey) {
        Object object = this.attributes.get(attributeKey.name());
        if (object == null) {
            throw new NoSuchElementException(attributeKey.name());
        }
        return attributeKey.type().cast(object);
    }

    @Override
    public <A> A get(AttributeKey<A> attributeKey, A a) {
        Object object = this.attributes.get(attributeKey.name());
        if (object == null) {
            return a;
        }
        return attributeKey.type().cast(object);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof Attributes) {
            Attributes attributes = (Attributes)object;
            return this.attributes.equals(attributes.attributes);
        }
        return false;
    }

    public int hashCode() {
        return this.attributes.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.attributes.size() * 32);
        stringBuilder.append(this.getClass().getName());
        stringBuilder.append('[');
        stringBuilder.append(this.attributes);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    Locale getLocale() {
        return this.get(LOCALE, Locale.ROOT);
    }

    ChronoCondition<ChronoDisplay> getCondition() {
        return this.printCondition;
    }

    static Builder createDefaults(Locale locale) {
        Builder builder = new Builder();
        builder.setStandardAttributes();
        builder.setLocale(locale);
        return builder;
    }

    static {
        Iterator<NumberSymbolProvider> iterator;
        NumberSymbolProvider numberSymbolProvider = null;
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = NumberSymbolProvider.class.getClassLoader();
        }
        if ((iterator = ServiceLoader.load(NumberSymbolProvider.class, classLoader).iterator()).hasNext()) {
            NumberSymbolProvider numberSymbolProvider2;
            numberSymbolProvider = numberSymbolProvider2 = iterator.next();
        }
        if (numberSymbolProvider == null) {
            numberSymbolProvider = NumberSymbolProvider.DEFAULT;
        }
        NUMBER_SYMBOLS = numberSymbolProvider;
        CALENDAR_TYPE = PredefinedKey.valueOf("CALENDAR_TYPE", String.class);
        LANGUAGE = PredefinedKey.valueOf("LANGUAGE", Locale.class);
        TIMEZONE_ID = PredefinedKey.valueOf("TIMEZONE_ID", TZID.class);
        TRANSITION_STRATEGY = PredefinedKey.valueOf("TRANSITION_STRATEGY", TransitionStrategy.class);
        LENIENCY = PredefinedKey.valueOf("LENIENCY", Leniency.class);
        TEXT_WIDTH = PredefinedKey.valueOf("TEXT_WIDTH", TextWidth.class);
        OUTPUT_CONTEXT = PredefinedKey.valueOf("OUTPUT_CONTEXT", OutputContext.class);
        PARSE_CASE_INSENSITIVE = PredefinedKey.valueOf("PARSE_CASE_INSENSITIVE", Boolean.class);
        PARSE_PARTIAL_COMPARE = PredefinedKey.valueOf("PARSE_PARTIAL_COMPARE", Boolean.class);
        ZERO_DIGIT = PredefinedKey.valueOf("ZERO_DIGIT", Character.class);
        DECIMAL_SEPARATOR = PredefinedKey.valueOf("DECIMAL_SEPARATOR", Character.class);
        PAD_CHAR = PredefinedKey.valueOf("PAD_CHAR", Character.class);
        PIVOT_YEAR = PredefinedKey.valueOf("PIVOT_YEAR", Integer.class);
        TRAILING_CHARACTERS = PredefinedKey.valueOf("TRAILING_CHARACTERS", Boolean.class);
        PROTECTED_CHARACTERS = PredefinedKey.valueOf("PROTECTED_CHARACTERS", Integer.class);
        LOCALE = PredefinedKey.valueOf("_LOCALE", Locale.class);
        OPTIONAL = PredefinedKey.valueOf("_OPTIONAL", Boolean.class);
        LEVEL = PredefinedKey.valueOf("_LEVEL", Integer.class);
        SECTION = PredefinedKey.valueOf("_SECTION", Integer.class);
        ISO_DECIMAL_SEPARATOR = (char)(Boolean.getBoolean("net.time4j.format.iso.decimal.dot") ? 46 : 44);
        NUMBER_SYMBOL_CACHE = new ConcurrentHashMap<Locale, NumericalSymbols>();
        DEFAULT_NUMERICAL_SYMBOLS = new NumericalSymbols('0', ISO_DECIMAL_SEPARATOR);
        EMPTY = new Builder().build();
    }

    private static class NumericalSymbols {
        private final char zeroDigit;
        private final char decimalSeparator;

        NumericalSymbols(char c, char c2) {
            this.zeroDigit = c;
            this.decimalSeparator = c2;
        }
    }

    public static final class Builder {
        private final Map<String, Object> attributes = new HashMap<String, Object>();
        private ChronoCondition<ChronoDisplay> printCondition = null;

        public Builder setCalendarType(String string) {
            this.setInternal(CALENDAR_TYPE, string);
            return this;
        }

        public Builder setLanguage(Locale locale) {
            this.setInternal(LANGUAGE, locale);
            return this;
        }

        public Builder setTimezone(TZID tZID) {
            this.setInternal(TIMEZONE_ID, tZID);
            return this;
        }

        public Builder setTimezone(String string) {
            this.setTimezone(Timezone.of(string).getID());
            return this;
        }

        public Builder setStdTimezone() {
            return this.setTimezone(Timezone.ofSystem().getID());
        }

        public Builder set(AttributeKey<Boolean> attributeKey, boolean bl) {
            this.attributes.put(attributeKey.name(), bl);
            return this;
        }

        public Builder set(AttributeKey<Integer> attributeKey, int n) {
            if (attributeKey == PIVOT_YEAR && n < 100) {
                throw new IllegalArgumentException("Pivot year in far past not supported: " + n);
            }
            this.attributes.put(attributeKey.name(), n);
            return this;
        }

        public Builder set(AttributeKey<Character> attributeKey, char c) {
            this.attributes.put(attributeKey.name(), Character.valueOf(c));
            return this;
        }

        public <A extends Enum<A>> Builder set(AttributeKey<A> attributeKey, A a) {
            if (a == null) {
                throw new NullPointerException("Missing attribute value.");
            }
            if (!(a instanceof Enum)) {
                throw new ClassCastException("Enum expected, but found: " + a);
            }
            this.attributes.put(attributeKey.name(), a);
            AttributeKey<A> attributeKey2 = attributeKey;
            if (attributeKey2 == LENIENCY) {
                switch ((Leniency)((Object)Leniency.class.cast(a))) {
                    case STRICT: {
                        this.set((AttributeKey<A>)PARSE_CASE_INSENSITIVE, (A)false);
                        this.set((AttributeKey<A>)PARSE_PARTIAL_COMPARE, (A)false);
                        this.set((AttributeKey<A>)TRAILING_CHARACTERS, (A)false);
                        break;
                    }
                    case SMART: {
                        this.set((AttributeKey<A>)PARSE_CASE_INSENSITIVE, (A)true);
                        this.set((AttributeKey<A>)PARSE_PARTIAL_COMPARE, (A)false);
                        this.set((AttributeKey<A>)TRAILING_CHARACTERS, (A)false);
                        break;
                    }
                    case LAX: {
                        this.set((AttributeKey<A>)PARSE_CASE_INSENSITIVE, (A)true);
                        this.set((AttributeKey<A>)PARSE_PARTIAL_COMPARE, (A)true);
                        this.set((AttributeKey<A>)TRAILING_CHARACTERS, (A)true);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException(a.name());
                    }
                }
            }
            return this;
        }

        public Builder setAll(Attributes attributes) {
            this.attributes.putAll(attributes.attributes);
            return this;
        }

        public Builder remove(AttributeKey<?> attributeKey) {
            String string = attributeKey.name();
            if (string.startsWith("_")) {
                throw new IllegalArgumentException("Internal attribute cannot be removed: " + string);
            }
            this.attributes.remove(string);
            return this;
        }

        public Attributes build() {
            return new Attributes(this.attributes, this.printCondition);
        }

        Builder setLocale(Locale locale) {
            if (locale.getLanguage().isEmpty() && locale.getCountry().isEmpty()) {
                locale = Locale.ROOT;
                this.set((AttributeKey)ZERO_DIGIT, (Enum)48);
                this.set((AttributeKey)DECIMAL_SEPARATOR, (Enum)ISO_DECIMAL_SEPARATOR);
            } else {
                Object object = NUMBER_SYMBOL_CACHE.get(locale);
                if (object == null) {
                    object = DEFAULT_NUMERICAL_SYMBOLS;
                    Object object2 = NUMBER_SYMBOLS.getAvailableLocales();
                    int n = ((Locale[])object2).length;
                    for (int i = 0; i < n; ++i) {
                        Locale locale2 = object2[i];
                        if (!locale.equals(locale2)) continue;
                        object = new NumericalSymbols(NUMBER_SYMBOLS.getZeroDigit(locale), NUMBER_SYMBOLS.getDecimalSeparator(locale));
                        break;
                    }
                    if ((object2 = NUMBER_SYMBOL_CACHE.putIfAbsent(locale, object)) != null) {
                        object = object2;
                    }
                }
                this.set((AttributeKey)ZERO_DIGIT, (Enum)((NumericalSymbols)object).zeroDigit);
                this.set((AttributeKey)DECIMAL_SEPARATOR, (Enum)((NumericalSymbols)object).decimalSeparator);
            }
            this.setInternal(LOCALE, locale);
            this.setInternal(LANGUAGE, locale);
            return this;
        }

        void setCondition(ChronoCondition<ChronoDisplay> chronoCondition) {
            this.printCondition = chronoCondition;
        }

        private Builder setStandardAttributes() {
            this.set(LENIENCY, Leniency.SMART);
            this.set(TEXT_WIDTH, TextWidth.WIDE);
            this.set(OUTPUT_CONTEXT, OutputContext.FORMAT);
            this.set((AttributeKey)PAD_CHAR, (Enum)32);
            return this;
        }

        private <A> void setInternal(AttributeKey<A> attributeKey, A a) {
            if (a == null) {
                throw new NullPointerException("Missing attribute value.");
            }
            this.attributes.put(attributeKey.name(), a);
        }
    }
}

