/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.ZonalMoment;
import net.time4j.base.MathUtils;
import net.time4j.base.UnixTime;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoException;
import net.time4j.engine.EpochDays;
import net.time4j.engine.TimePoint;
import net.time4j.scale.LeapSeconds;
import net.time4j.scale.TimeScale;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public abstract class TemporalType<S, T> {
    private static final boolean WITH_SQL_UTC_CONVERSION = Boolean.getBoolean("net.time4j.sql.utc.conversion");
    private static final PlainDate UNIX_DATE = PlainDate.of(0L, EpochDays.UNIX);
    private static final int MIO = 1000000;
    private static final int MRD = 1000000000;
    private static final BigDecimal MRD_D = BigDecimal.valueOf(1000000000L);
    private static final BigInteger MRD_I = BigInteger.valueOf(1000000000L);
    private static final XmlDateTimeRule XML_TIMESTAMP = new XmlDateTimeRule();
    public static final TemporalType<java.util.Date, Moment> JAVA_UTIL_DATE = new JavaUtilDateRule();
    public static final TemporalType<Long, Moment> MILLIS_SINCE_UNIX = new MillisSinceUnixRule();
    public static final TemporalType<Date, PlainDate> SQL_DATE = new SqlDateRule();
    public static final TemporalType<Time, PlainTime> SQL_TIME = new SqlTimeRule();
    public static final TemporalType<Timestamp, PlainTimestamp> SQL_TIMESTAMP = new SqlTimestampRule();
    public static final TemporalType<XMLGregorianCalendar, PlainDate> XML_DATE = new XmlDateRule();
    public static final TemporalType<XMLGregorianCalendar, PlainTime> XML_TIME = new XmlTimeRule();
    public static final TemporalType<XMLGregorianCalendar, PlainTimestamp> XML_DATE_TIME = XML_TIMESTAMP;
    public static final TemporalType<XMLGregorianCalendar, ZonalMoment> XML_DATE_TIME_OFFSET = new XmlDateTimeOffsetRule();
    public static final TemporalType<javax.xml.datatype.Duration, Duration<IsoUnit>> XML_DURATION = new XmlDurationRule();

    protected TemporalType() {
    }

    public abstract T translate(S var1);

    public abstract S from(T var1);

    private static DatatypeFactory getXMLFactory() {
        try {
            return DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException datatypeConfigurationException) {
            throw new ChronoException("XML-conversion not available.", datatypeConfigurationException);
        }
    }

    private static XMLGregorianCalendar toXML(ChronoDisplay chronoDisplay, int n) {
        PlainDate plainDate = chronoDisplay.get(PlainDate.COMPONENT);
        int n2 = plainDate.getYear();
        int n3 = plainDate.getMonth();
        int n4 = plainDate.getDayOfMonth();
        PlainTime plainTime = chronoDisplay.get(PlainTime.COMPONENT);
        int n5 = plainTime.getHour();
        int n6 = plainTime.getMinute();
        int n7 = (Integer)chronoDisplay.get(PlainTime.SECOND_OF_MINUTE);
        int n8 = plainTime.getNanosecond();
        DatatypeFactory datatypeFactory = TemporalType.getXMLFactory();
        if (n8 % 1000000 == 0) {
            int n9 = n8 / 1000000;
            return datatypeFactory.newXMLGregorianCalendar(n2, n3, n4, n5, n6, n7, n9, n);
        }
        BigInteger bigInteger = BigInteger.valueOf(n2);
        BigDecimal bigDecimal = BigDecimal.valueOf(n8).setScale(9).divide(MRD_D);
        return datatypeFactory.newXMLGregorianCalendar(bigInteger, n3, n4, n5, n6, n7, bigDecimal, n);
    }

    private static class XmlDurationRule
    extends TemporalType<javax.xml.datatype.Duration, Duration<IsoUnit>> {
        private XmlDurationRule() {
        }

        @Override
        public Duration<IsoUnit> translate(javax.xml.datatype.Duration duration) {
            if (duration.getSign() == 0) {
                return Duration.ofZero();
            }
            try {
                return Duration.parsePeriod(duration.toString());
            }
            catch (ParseException parseException) {
                if (parseException.getCause() instanceof NumberFormatException) {
                    ArithmeticException arithmeticException = new ArithmeticException();
                    arithmeticException.initCause(parseException);
                    throw arithmeticException;
                }
                throw new ChronoException("Cannot translate: " + duration, parseException);
            }
        }

        @Override
        public javax.xml.datatype.Duration from(Duration<IsoUnit> duration) {
            DatatypeFactory datatypeFactory = TemporalType.getXMLFactory();
            return datatypeFactory.newDuration(duration.toStringXML());
        }
    }

    private static class XmlDateTimeOffsetRule
    extends TemporalType<XMLGregorianCalendar, ZonalMoment> {
        private XmlDateTimeOffsetRule() {
        }

        @Override
        public ZonalMoment translate(XMLGregorianCalendar xMLGregorianCalendar) {
            PlainTimestamp plainTimestamp = XML_TIMESTAMP.translate(xMLGregorianCalendar, true);
            int n = xMLGregorianCalendar.getTimezone();
            if (n == Integer.MIN_VALUE) {
                throw new ChronoException("Missing timezone offset: " + xMLGregorianCalendar);
            }
            ZonalOffset zonalOffset = ZonalOffset.ofTotalSeconds(n * 60);
            if (xMLGregorianCalendar.getSecond() == 60 && LeapSeconds.getInstance().isEnabled()) {
                Moment moment = plainTimestamp.at(zonalOffset).plus(1L, SI.SECONDS);
                if (moment.isLeapSecond()) {
                    return moment.inZonalView(zonalOffset);
                }
                throw new ChronoException("Leap second not registered: " + xMLGregorianCalendar);
            }
            return ZonalMoment.of(plainTimestamp, zonalOffset);
        }

        @Override
        public XMLGregorianCalendar from(ZonalMoment zonalMoment) {
            ZonalOffset zonalOffset = zonalMoment.getOffset();
            int n = zonalOffset.getIntegralAmount() / 60;
            try {
                return TemporalType.toXML(zonalMoment, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (zonalMoment.isLeapSecond()) {
                    ZonalMoment zonalMoment2 = zonalMoment.toMoment().minus(1L, SI.SECONDS).inZonalView(zonalOffset);
                    return TemporalType.toXML(zonalMoment2, n);
                }
                throw illegalArgumentException;
            }
        }
    }

    private static class XmlDateTimeRule
    extends TemporalType<XMLGregorianCalendar, PlainTimestamp> {
        private XmlDateTimeRule() {
        }

        @Override
        public PlainTimestamp translate(XMLGregorianCalendar xMLGregorianCalendar) {
            return this.translate(xMLGregorianCalendar, false);
        }

        PlainTimestamp translate(XMLGregorianCalendar xMLGregorianCalendar, boolean bl) {
            int n;
            BigInteger bigInteger;
            BigInteger bigInteger2 = xMLGregorianCalendar.getEon();
            if (bigInteger2 != null && (bigInteger = bigInteger2.abs()).compareTo(MRD_I) >= 0) {
                throw new ArithmeticException("Year out of supported range: " + xMLGregorianCalendar);
            }
            int n2 = xMLGregorianCalendar.getYear();
            int n3 = xMLGregorianCalendar.getMonth();
            int n4 = xMLGregorianCalendar.getDay();
            if (n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE || n4 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing date component: " + xMLGregorianCalendar);
            }
            int n5 = xMLGregorianCalendar.getHour();
            if (n5 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing hour component: " + xMLGregorianCalendar);
            }
            int n6 = xMLGregorianCalendar.getMinute();
            if (n6 == Integer.MIN_VALUE) {
                n6 = 0;
            }
            if ((n = xMLGregorianCalendar.getSecond()) == Integer.MIN_VALUE) {
                n = 0;
            } else if (bl && n == 60) {
                n = 59;
            }
            int n7 = 0;
            BigDecimal bigDecimal = xMLGregorianCalendar.getFractionalSecond();
            if (bigDecimal != null) {
                n7 = bigDecimal.movePointRight(9).intValue();
            }
            PlainTimestamp plainTimestamp = PlainTimestamp.of(n2, n3, n4, n5, n6, n);
            if (n7 != 0) {
                plainTimestamp = (PlainTimestamp)plainTimestamp.with((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, n7);
            }
            return plainTimestamp;
        }

        @Override
        public XMLGregorianCalendar from(PlainTimestamp plainTimestamp) {
            return TemporalType.toXML(plainTimestamp, Integer.MIN_VALUE);
        }
    }

    private static class XmlTimeRule
    extends TemporalType<XMLGregorianCalendar, PlainTime> {
        private XmlTimeRule() {
        }

        @Override
        public PlainTime translate(XMLGregorianCalendar xMLGregorianCalendar) {
            int n;
            int n2 = xMLGregorianCalendar.getHour();
            if (n2 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing hour component: " + xMLGregorianCalendar);
            }
            int n3 = xMLGregorianCalendar.getMinute();
            if (n3 == Integer.MIN_VALUE) {
                n3 = 0;
            }
            if ((n = xMLGregorianCalendar.getSecond()) == Integer.MIN_VALUE) {
                n = 0;
            }
            int n4 = 0;
            BigDecimal bigDecimal = xMLGregorianCalendar.getFractionalSecond();
            if (bigDecimal != null) {
                n4 = bigDecimal.movePointRight(9).intValue();
            }
            return PlainTime.of(n2, n3, n, n4);
        }

        @Override
        public XMLGregorianCalendar from(PlainTime plainTime) {
            int n = plainTime.getHour();
            int n2 = plainTime.getMinute();
            int n3 = plainTime.getSecond();
            int n4 = plainTime.getNanosecond();
            DatatypeFactory datatypeFactory = TemporalType.getXMLFactory();
            int n5 = Integer.MIN_VALUE;
            if (n4 % 1000000 == 0) {
                int n6 = n4 / 1000000;
                return datatypeFactory.newXMLGregorianCalendarTime(n, n2, n3, n6, n5);
            }
            BigDecimal bigDecimal = BigDecimal.valueOf(n4).setScale(9).divide(MRD_D);
            return datatypeFactory.newXMLGregorianCalendarTime(n, n2, n3, bigDecimal, n5);
        }
    }

    private static class XmlDateRule
    extends TemporalType<XMLGregorianCalendar, PlainDate> {
        private XmlDateRule() {
        }

        @Override
        public PlainDate translate(XMLGregorianCalendar xMLGregorianCalendar) {
            BigInteger bigInteger;
            BigInteger bigInteger2 = xMLGregorianCalendar.getEon();
            if (bigInteger2 != null && (bigInteger = bigInteger2.abs()).compareTo(MRD_I) >= 0) {
                throw new ArithmeticException("Year out of supported range: " + xMLGregorianCalendar);
            }
            int n = xMLGregorianCalendar.getYear();
            int n2 = xMLGregorianCalendar.getMonth();
            int n3 = xMLGregorianCalendar.getDay();
            if (n == Integer.MIN_VALUE || n2 == Integer.MIN_VALUE || n3 == Integer.MIN_VALUE) {
                throw new ChronoException("Missing date component: " + xMLGregorianCalendar);
            }
            return PlainDate.of(n, n2, n3);
        }

        @Override
        public XMLGregorianCalendar from(PlainDate plainDate) {
            int n = plainDate.getYear();
            int n2 = plainDate.getMonth();
            int n3 = plainDate.getDayOfMonth();
            DatatypeFactory datatypeFactory = TemporalType.getXMLFactory();
            return datatypeFactory.newXMLGregorianCalendarDate(n, n2, n3, Integer.MIN_VALUE);
        }
    }

    private static class SqlTimestampRule
    extends TemporalType<Timestamp, PlainTimestamp> {
        private SqlTimestampRule() {
        }

        @Override
        public PlainTimestamp translate(Timestamp timestamp) {
            Comparable<ZonalOffset> comparable;
            TimePoint timePoint;
            long l = timestamp.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                timePoint = Moment.of(MathUtils.floorDivide(l, 1000), TimeScale.POSIX);
                comparable = Timezone.ofSystem().getOffset((UnixTime)((Object)timePoint));
                l += (long)(((ZonalOffset)comparable).getIntegralAmount() * 1000);
            }
            timePoint = PlainDate.of(MathUtils.floorDivide(l, 86400000), EpochDays.UNIX);
            comparable = PlainTime.createFromMillis(MathUtils.floorModulo(l, 86400000));
            PlainTimestamp plainTimestamp = PlainTimestamp.of((PlainDate)timePoint, comparable);
            return (PlainTimestamp)plainTimestamp.with((ChronoElement<Integer>)PlainTime.NANO_OF_SECOND, timestamp.getNanos());
        }

        @Override
        public Timestamp from(PlainTimestamp plainTimestamp) {
            Comparable<ZonalOffset> comparable;
            long l = MathUtils.safeMultiply(plainTimestamp.getCalendarDate().getDaysSinceUTC() + 730L, 86400000L);
            long l2 = ((Integer)plainTimestamp.get(PlainTime.MILLI_OF_DAY)).intValue();
            if (!WITH_SQL_UTC_CONVERSION) {
                comparable = Timezone.ofSystem().getOffset(plainTimestamp, plainTimestamp);
                l2 -= (long)(((ZonalOffset)comparable).getIntegralAmount() * 1000);
            }
            comparable = new Timestamp(MathUtils.safeAdd(l, l2));
            ((Timestamp)comparable).setNanos((Integer)plainTimestamp.get(PlainTime.NANO_OF_SECOND));
            return comparable;
        }
    }

    private static class SqlTimeRule
    extends TemporalType<Time, PlainTime> {
        private SqlTimeRule() {
        }

        @Override
        public PlainTime translate(Time time) {
            long l = time.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                Moment moment = Moment.of(MathUtils.floorDivide(l, 1000), TimeScale.POSIX);
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(moment);
                l += (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return (PlainTime)PlainTime.MIN.with((ChronoElement<Integer>)PlainTime.MILLI_OF_DAY, MathUtils.floorModulo(l, 86400000));
        }

        @Override
        public Time from(PlainTime plainTime) {
            long l = ((Integer)plainTime.get(PlainTime.MILLI_OF_DAY)).intValue();
            if (!WITH_SQL_UTC_CONVERSION) {
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(UNIX_DATE, plainTime);
                l -= (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return new Time(l);
        }
    }

    private static class SqlDateRule
    extends TemporalType<Date, PlainDate> {
        private SqlDateRule() {
        }

        @Override
        public PlainDate translate(Date date) {
            long l = date.getTime();
            if (!WITH_SQL_UTC_CONVERSION) {
                Moment moment = Moment.of(MathUtils.floorDivide(l, 1000), TimeScale.POSIX);
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(moment);
                l += (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return PlainDate.axis().getCalendarSystem().transform(MathUtils.floorDivide(l, 86400000) - 730L);
        }

        @Override
        public Date from(PlainDate plainDate) {
            int n = plainDate.getYear();
            if (n < 1900 || n > 9999) {
                throw new ChronoException("SQL-Date is only defined in year range of 1900-9999.");
            }
            long l = MathUtils.safeMultiply(plainDate.getDaysSinceUTC() + 730L, 86400000L);
            if (!WITH_SQL_UTC_CONVERSION) {
                ZonalOffset zonalOffset = Timezone.ofSystem().getOffset(plainDate, PlainTime.MIN);
                l -= (long)(zonalOffset.getIntegralAmount() * 1000);
            }
            return new Date(l);
        }
    }

    private static class MillisSinceUnixRule
    extends TemporalType<Long, Moment> {
        private MillisSinceUnixRule() {
        }

        @Override
        public Moment translate(Long l) {
            long l2 = l;
            long l3 = MathUtils.floorDivide(l2, 1000);
            int n = MathUtils.floorModulo(l2, 1000) * 1000000;
            return Moment.of(l3, n, TimeScale.POSIX);
        }

        @Override
        public Long from(Moment moment) {
            long l = moment.getPosixTime();
            int n = moment.getNanosecond();
            return MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), (long)(n / 1000000));
        }
    }

    private static class JavaUtilDateRule
    extends TemporalType<java.util.Date, Moment> {
        private JavaUtilDateRule() {
        }

        @Override
        public Moment translate(java.util.Date date) {
            long l = date.getTime();
            long l2 = MathUtils.floorDivide(l, 1000);
            int n = MathUtils.floorModulo(l, 1000) * 1000000;
            return Moment.of(l2, n, TimeScale.POSIX);
        }

        @Override
        public java.util.Date from(Moment moment) {
            long l = moment.getPosixTime();
            int n = moment.getNanosecond();
            long l2 = MathUtils.safeAdd(MathUtils.safeMultiply(l, 1000L), (long)(n / 1000000));
            return new java.util.Date(l2);
        }
    }
}

