/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.PlainDate;
import net.time4j.PlainTimestamp;
import net.time4j.SystemClock;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class ZonalClock {
    private static final ZonalClock SYSTEM = new ZonalClock();
    private final TimeSource<?> timeSource;
    private final Timezone timezone;

    public ZonalClock(TimeSource<?> timeSource, TZID tZID) {
        if (timeSource == null) {
            throw new NullPointerException("Missing time source.");
        }
        if (tZID == null) {
            throw new NullPointerException("Missing timezone id.");
        }
        this.timeSource = timeSource;
        this.timezone = Timezone.of(tZID);
    }

    public ZonalClock(TimeSource<?> timeSource, String string) {
        if (timeSource == null) {
            throw new NullPointerException("Missing time source.");
        }
        if (string.isEmpty()) {
            throw new NullPointerException("Timezone id is empty.");
        }
        this.timeSource = timeSource;
        this.timezone = Timezone.of(string);
    }

    private ZonalClock() {
        this.timeSource = SystemClock.INSTANCE;
        this.timezone = Timezone.ofSystem();
    }

    public PlainTimestamp now() {
        Object obj = this.timeSource.currentTime();
        return PlainTimestamp.from(obj, this.timezone.getOffset((UnixTime)obj));
    }

    public PlainDate today() {
        Object obj = this.timeSource.currentTime();
        return PlainDate.from(obj, this.timezone.getOffset((UnixTime)obj));
    }

    public TimeSource<?> getSource() {
        return this.timeSource;
    }

    public TZID getTimezone() {
        return this.timezone.getID();
    }

    static ZonalClock ofSystem() {
        return SYSTEM;
    }
}

