/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.ZonalElement;
import net.time4j.ZonalQuery;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoFunction;
import net.time4j.format.NumericalElement;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class DecimalTimeElement
extends BasicElement<BigDecimal>
implements ZonalElement<BigDecimal>,
NumericalElement<BigDecimal> {
    private static final long serialVersionUID = -4837430960549551204L;
    private final transient BigDecimal defaultMax;

    DecimalTimeElement(String string, BigDecimal bigDecimal) {
        super(string);
        this.defaultMax = bigDecimal;
    }

    @Override
    public Class<BigDecimal> getType() {
        return BigDecimal.class;
    }

    @Override
    public int numerical(BigDecimal bigDecimal) {
        return bigDecimal.setScale(9, RoundingMode.FLOOR).intValue();
    }

    @Override
    public BigDecimal getDefaultMinimum() {
        return BigDecimal.ZERO;
    }

    @Override
    public BigDecimal getDefaultMaximum() {
        return this.defaultMax;
    }

    @Override
    public boolean isDateElement() {
        return false;
    }

    @Override
    public boolean isTimeElement() {
        return true;
    }

    @Override
    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return chronoDisplay.get(this).compareTo(chronoDisplay2.get(this));
    }

    @Override
    public ChronoFunction<Moment, BigDecimal> inStdTimezone() {
        return this.in(Timezone.ofSystem());
    }

    @Override
    public ChronoFunction<Moment, BigDecimal> inTimezone(TZID tZID) {
        return this.in(Timezone.of(tZID));
    }

    @Override
    public ChronoFunction<Moment, BigDecimal> in(Timezone timezone) {
        return new ZonalQuery<BigDecimal>(this, timezone);
    }

    @Override
    public ChronoFunction<Moment, BigDecimal> atUTC() {
        return this.at(ZonalOffset.UTC);
    }

    @Override
    public ChronoFunction<Moment, BigDecimal> at(ZonalOffset zonalOffset) {
        return new ZonalQuery<BigDecimal>(this, zonalOffset);
    }

    private Object readResolve() throws ObjectStreamException {
        Object object = PlainTime.lookupElement(this.name());
        if (object == null) {
            throw new InvalidObjectException(this.name());
        }
        return object;
    }
}

