/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz;

import java.io.Externalizable;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.ObjectStreamException;
import java.io.StreamCorruptedException;
import net.time4j.tz.ZonalOffset;

final class SPX
implements Externalizable {
    static final int ZONAL_OFFSET_TYPE = 15;
    private static final long serialVersionUID = -1000776907354520172L;
    private transient Object obj;
    private transient int type;

    public SPX() {
    }

    SPX(Object object, int n) {
        this.obj = object;
        this.type = n;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        switch (this.type) {
            case 15: {
                this.writeOffset(objectOutput);
                break;
            }
            default: {
                throw new InvalidClassException("Unknown serialized type.");
            }
        }
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte by = objectInput.readByte();
        switch (by >> 4) {
            case 15: {
                this.obj = this.readOffset(objectInput, by);
                break;
            }
            default: {
                throw new StreamCorruptedException("Unknown serialized type.");
            }
        }
    }

    private Object readResolve() throws ObjectStreamException {
        return this.obj;
    }

    private void writeOffset(ObjectOutput objectOutput) throws IOException {
        ZonalOffset zonalOffset = (ZonalOffset)this.obj;
        boolean bl = zonalOffset.getFractionalAmount() != 0;
        int n = 240;
        if (bl) {
            n |= 1;
        }
        objectOutput.writeByte(n);
        objectOutput.writeInt(zonalOffset.getIntegralAmount());
        if (bl) {
            objectOutput.writeInt(zonalOffset.getFractionalAmount());
        }
    }

    private Object readOffset(ObjectInput objectInput, byte by) throws IOException {
        int n = objectInput.readInt();
        int n2 = 0;
        if ((by & 0xF) == 1) {
            n2 = objectInput.readInt();
        }
        return ZonalOffset.ofTotalSeconds(n, n2);
    }
}

