/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.base.UnixTime;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.format.Attributes;
import net.time4j.format.ElementPosition;
import net.time4j.format.FormatProcessor;
import net.time4j.format.FormatStep;
import net.time4j.format.Leniency;
import net.time4j.format.LocalizedGMTProcessor;
import net.time4j.format.ParseLog;
import net.time4j.format.TimezoneElement;
import net.time4j.tz.NameStyle;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class TimezoneNameProcessor
implements FormatProcessor<TZID> {
    private static final ConcurrentMap<Locale, TZNames> CACHE_ABBREVIATIONS = new ConcurrentHashMap<Locale, TZNames>();
    private static final ConcurrentMap<Locale, TZNames> CACHE_ZONENAMES = new ConcurrentHashMap<Locale, TZNames>();
    private static final int MAX = 25;
    private static final boolean WITH_OLSON_MODULE;
    private final boolean abbreviated;
    private final FormatProcessor<TZID> fallback;
    private final Set<TZID> preferredZones;

    TimezoneNameProcessor(boolean bl, Set<TZID> set) {
        this.abbreviated = bl;
        this.fallback = new LocalizedGMTProcessor(bl);
        this.preferredZones = new LinkedHashSet<TZID>(set);
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery, Set<ElementPosition> set, FormatStep formatStep) throws IOException {
        if (!chronoDisplay.hasTimezone()) {
            throw new IllegalArgumentException("Cannot extract timezone id from: " + chronoDisplay);
        }
        TZID tZID = chronoDisplay.getTimezone();
        if (tZID instanceof ZonalOffset) {
            this.fallback.print(chronoDisplay, appendable, attributeQuery, set, formatStep);
            return;
        }
        if (!(chronoDisplay instanceof UnixTime)) {
            throw new IllegalArgumentException("Cannot extract timezone name from: " + chronoDisplay);
        }
        Timezone timezone = Timezone.of(tZID);
        UnixTime unixTime = (UnixTime)UnixTime.class.cast(chronoDisplay);
        String string = timezone.getDisplayName(this.getStyle(timezone.isDaylightSaving(unixTime)), formatStep.getAttribute(Attributes.LOCALE, attributeQuery, Locale.ROOT));
        int n = -1;
        if (appendable instanceof CharSequence) {
            n = ((CharSequence)((Object)appendable)).length();
        }
        appendable.append(string);
        int n2 = string.length();
        if (n != -1 && n2 > 0 && set != null) {
            set.add(new ElementPosition(TimezoneElement.TIMEZONE_ID, n, n + n2));
        }
    }

    @Override
    public void parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery, Map<ChronoElement<?>, Object> map, FormatStep formatStep) {
        Object object;
        List<TZID> list;
        char c;
        int n = charSequence.length();
        int n2 = parseLog.getPosition();
        int n3 = n2;
        if (n3 >= n) {
            parseLog.setError(n2, "Missing timezone name.");
            return;
        }
        Locale locale = formatStep.getAttribute(Attributes.LOCALE, attributeQuery, Locale.ROOT);
        Leniency leniency = formatStep.getAttribute(Attributes.LENIENCY, attributeQuery, Leniency.SMART);
        StringBuilder stringBuilder = new StringBuilder();
        while (n3 < n && (Character.isLetter(c = charSequence.charAt(n3)) || !this.abbreviated && Character.isWhitespace(c) || c == '\'')) {
            stringBuilder.append(c);
            ++n3;
        }
        String string = stringBuilder.toString();
        if (string.startsWith("GMT") || string.startsWith("UT")) {
            this.fallback.parse(charSequence, parseLog, attributeQuery, map, formatStep);
            return;
        }
        ConcurrentMap<Locale, TZNames> concurrentMap = this.abbreviated ? CACHE_ABBREVIATIONS : CACHE_ZONENAMES;
        Object object2 = (TZNames)concurrentMap.get(locale);
        if (object2 == null) {
            Map<String, List<TZID>> map2 = this.getTimezoneNameMap(locale, false);
            list = this.getTimezoneNameMap(locale, true);
            object2 = new TZNames(map2, (Map<String, List<TZID>>)((Object)list));
            if (concurrentMap.size() < 25 && (object = (Object)concurrentMap.putIfAbsent(locale, (TZNames)object2)) != null) {
                object2 = object;
            }
        }
        boolean bl = false;
        list = ((TZNames)object2).search(string, false);
        if (list.isEmpty()) {
            list = ((TZNames)object2).search(string, true);
            if (list.isEmpty()) {
                object = new int[]{0};
                list = ((TZNames)object2).search(charSequence, n2, false, (int[])object);
                if (list.isEmpty() && !(list = ((TZNames)object2).search(charSequence, n2, true, (int[])object)).isEmpty()) {
                    bl = true;
                }
                n3 = n2 + object[0];
            } else {
                bl = true;
            }
        }
        if (list.isEmpty()) {
            parseLog.setError(n2, "Unknown timezone name: " + string);
            return;
        }
        if (WITH_OLSON_MODULE && list.size() > 1 && !leniency.isLax()) {
            object = new ArrayList<TZID>(list);
            for (TZID tZID : list) {
                boolean bl2 = false;
                for (TZID tZID2 : this.preferredZones) {
                    if (!tZID2.canonical().equals(tZID.canonical())) continue;
                    bl2 = true;
                    break;
                }
                if (bl2) continue;
                object.remove(tZID);
            }
            if (object.isEmpty()) {
                parseLog.setError(n2, "Time zone id not found among preferred timezones.");
                return;
            }
            list = object;
        }
        if (list.size() == 1 || leniency.isLax()) {
            map.put(TimezoneElement.TIMEZONE_ID, list.get(0));
            parseLog.setPosition(n3);
            parseLog.setDaylightSaving(bl);
        } else {
            parseLog.setError(n2, "Time zone name is not unique: \"" + string + "\" in " + list);
        }
    }

    @Override
    public ChronoElement<TZID> getElement() {
        return TimezoneElement.TIMEZONE_ID;
    }

    @Override
    public FormatProcessor<TZID> withElement(ChronoElement<TZID> chronoElement) {
        return this;
    }

    @Override
    public boolean isNumerical() {
        return false;
    }

    private Map<String, List<TZID>> getTimezoneNameMap(Locale locale, boolean bl) {
        HashMap<String, ArrayList<TZID>> hashMap = new HashMap<String, ArrayList<TZID>>();
        for (TZID tZID : Timezone.getAvailableIDs()) {
            Timezone timezone = Timezone.of(tZID);
            String string = timezone.getDisplayName(this.getStyle(bl), locale);
            ArrayList<TZID> arrayList = (ArrayList<TZID>)hashMap.get(string);
            if (arrayList == null) {
                arrayList = new ArrayList<TZID>();
                hashMap.put(string, arrayList);
            }
            arrayList.add(tZID);
        }
        return Collections.unmodifiableMap(hashMap);
    }

    private NameStyle getStyle(boolean bl) {
        if (bl) {
            return this.abbreviated ? NameStyle.SHORT_DAYLIGHT_TIME : NameStyle.LONG_DAYLIGHT_TIME;
        }
        return this.abbreviated ? NameStyle.SHORT_STANDARD_TIME : NameStyle.LONG_STANDARD_TIME;
    }

    static {
        boolean bl = true;
        try {
            Class.forName("net.time4j.tz.olson.StdZoneIdentifier");
        }
        catch (ClassNotFoundException classNotFoundException) {
            bl = false;
        }
        WITH_OLSON_MODULE = bl;
    }

    private static class TZNames {
        private final Map<String, List<TZID>> stdNames;
        private final Map<String, List<TZID>> dstNames;

        TZNames(Map<String, List<TZID>> map, Map<String, List<TZID>> map2) {
            this.stdNames = map;
            this.dstNames = map2;
        }

        List<TZID> search(String string, boolean bl) {
            Map<String, List<TZID>> map;
            Map<String, List<TZID>> map2 = map = bl ? this.dstNames : this.stdNames;
            if (map.containsKey(string)) {
                return map.get(string);
            }
            return Collections.emptyList();
        }

        List<TZID> search(CharSequence charSequence, int n, boolean bl, int[] nArray) {
            Map<String, List<TZID>> map = bl ? this.dstNames : this.stdNames;
            int n2 = charSequence.length();
            for (String string : map.keySet()) {
                boolean bl2 = true;
                int n3 = string.length();
                for (int i = n; i < n + n3; ++i) {
                    if (i >= n2) {
                        bl2 = false;
                        break;
                    }
                    if (string.charAt(i - n) == charSequence.charAt(i)) {
                        continue;
                    }
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                nArray[0] = n3;
                return map.get(string);
            }
            return Collections.emptyList();
        }
    }
}

