/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.Month;
import net.time4j.PlainDate;
import net.time4j.base.GregorianDate;
import net.time4j.engine.CalendarEra;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ElementRule;

enum SimpleEra implements CalendarEra
{
    BC{

        @Override
        public GregorianDate getDate() {
            return PlainDate.of(0, Month.DECEMBER, 31);
        }

        @Override
        public boolean isStarting() {
            return false;
        }
    }
    ,
    AD{

        @Override
        public GregorianDate getDate() {
            return PlainDate.of(1, Month.JANUARY, 1);
        }

        @Override
        public boolean isStarting() {
            return true;
        }
    };


    @Override
    public int getValue() {
        return this.ordinal();
    }

    static class Rule<T extends ChronoEntity<T>>
    implements ElementRule<T, SimpleEra> {
        Rule() {
        }

        @Override
        public SimpleEra getValue(T t) {
            int n = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE).getYear();
            return n <= 0 ? BC : AD;
        }

        @Override
        public SimpleEra getMinimum(T t) {
            return BC;
        }

        @Override
        public SimpleEra getMaximum(T t) {
            return AD;
        }

        @Override
        public boolean isValid(T t, SimpleEra simpleEra) {
            return simpleEra != null;
        }

        @Override
        public T withValue(T t, SimpleEra simpleEra, boolean bl) {
            if (simpleEra == null) {
                throw new NullPointerException("Missing era.");
            }
            PlainDate plainDate = ((ChronoEntity)t).get(PlainDate.CALENDAR_DATE);
            int n = plainDate.getYear();
            if (n <= 0 && simpleEra == AD || n > 0 && simpleEra == BC) {
                plainDate = (PlainDate)plainDate.with((ChronoElement<Integer>)PlainDate.YEAR, 1 - n);
            }
            return ((ChronoEntity)t).with(PlainDate.CALENDAR_DATE, (PlainDate)plainDate);
        }

        @Override
        public ChronoElement<?> getChildAtFloor(T t) {
            return PlainDate.YEAR_OF_ERA;
        }

        @Override
        public ChronoElement<?> getChildAtCeiling(T t) {
            return PlainDate.YEAR_OF_ERA;
        }
    }
}

