/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.Serializable;
import net.time4j.CalendarUnit;
import net.time4j.IsoDateUnit;
import net.time4j.OverflowPolicy;
import net.time4j.PlainDate;
import net.time4j.engine.BasicUnit;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.engine.UnitRule;

final class OverflowUnit
extends BasicUnit
implements IsoDateUnit,
Serializable {
    private static final long serialVersionUID = 1988843503875912053L;
    private final CalendarUnit unit;
    private final OverflowPolicy policy;

    OverflowUnit(CalendarUnit calendarUnit, OverflowPolicy overflowPolicy) {
        this.unit = calendarUnit;
        this.policy = overflowPolicy;
    }

    @Override
    public char getSymbol() {
        return '\u0000';
    }

    @Override
    public double getLength() {
        return this.unit.getLength();
    }

    @Override
    public boolean isCalendrical() {
        return true;
    }

    @Override
    protected <T extends ChronoEntity<T>> UnitRule<T> derive(Chronology<T> chronology) {
        if (chronology.isRegistered(PlainDate.CALENDAR_DATE)) {
            return new CalendarUnit.Rule(this.unit, this.policy);
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof OverflowUnit) {
            OverflowUnit overflowUnit = (OverflowUnit)object;
            return this.unit == overflowUnit.unit && this.policy == overflowUnit.policy;
        }
        return false;
    }

    public int hashCode() {
        return 23 * this.unit.hashCode() + 37 * this.policy.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.unit.getSymbol());
        stringBuilder.append('-');
        stringBuilder.append(this.policy.name());
        return stringBuilder.toString();
    }

    CalendarUnit getCalendarUnit() {
        return this.unit;
    }
}

