/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.format;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormatSymbols;
import java.text.Normalizer;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.Chronology;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarType;
import net.time4j.format.OutputContext;
import net.time4j.format.ParseLog;
import net.time4j.format.TextWidth;

public final class CalendarText {
    public static final String ISO_CALENDAR_TYPE = "iso8601";
    private static final ConcurrentMap<String, CalendarText> CACHE = new ConcurrentHashMap<String, CalendarText>();
    private static final ResourceBundle.Control CONTROL = new UTF8NoFallbackControl();
    private final String provider;
    private final Map<TextWidth, Map<OutputContext, Accessor>> stdMonths;
    private final Map<TextWidth, Map<OutputContext, Accessor>> leapMonths;
    private final Map<TextWidth, Map<OutputContext, Accessor>> quarters;
    private final Map<TextWidth, Map<OutputContext, Accessor>> weekdays;
    private final Map<TextWidth, Accessor> eras;
    private final Map<TextWidth, Accessor> meridiems;
    private final ResourceBundle textForms;
    private final MissingResourceException mre;

    /*
     * WARNING - void declaration
     */
    private CalendarText(String string, Locale locale, Provider provider) {
        void var13_29;
        void var12_21;
        this.provider = provider.toString();
        ResourceBundle resourceBundle = null;
        MissingResourceException missingResourceException = null;
        try {
            resourceBundle = ResourceBundle.getBundle("data/" + string, locale, CalendarText.getLoader(), CONTROL);
        }
        catch (MissingResourceException missingResourceException2) {
            missingResourceException = missingResourceException2;
        }
        this.textForms = resourceBundle;
        this.mre = missingResourceException;
        this.stdMonths = Collections.unmodifiableMap(CalendarText.getMonths(string, locale, provider, false));
        Map<TextWidth, Map<OutputContext, Accessor>> map = CalendarText.getMonths(string, locale, provider, true);
        this.leapMonths = map == null ? this.stdMonths : Collections.unmodifiableMap(map);
        EnumMap enumMap = new EnumMap(TextWidth.class);
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, Accessor> object = new EnumMap<OutputContext, Accessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                object.put(outputContext, new Accessor(provider.quarters(string, locale, textWidth, outputContext), locale));
            }
            enumMap.put(textWidth, object);
        }
        this.quarters = Collections.unmodifiableMap(enumMap);
        EnumMap enumMap2 = new EnumMap(TextWidth.class);
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, Accessor> enumMap3 = new EnumMap<OutputContext, Accessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                enumMap3.put(outputContext, new Accessor(provider.weekdays(string, locale, textWidth, outputContext), locale));
            }
            enumMap2.put(textWidth, enumMap3);
        }
        this.weekdays = Collections.unmodifiableMap(enumMap2);
        EnumMap enumMap3 = new EnumMap(TextWidth.class);
        Object enumMap4 = TextWidth.values();
        int n = ((TextWidth[])enumMap4).length;
        boolean bl = false;
        while (var12_21 < n) {
            TextWidth textWidth = enumMap4[var12_21];
            enumMap3.put(textWidth, new Accessor(provider.eras(string, locale, textWidth), locale));
            ++var12_21;
        }
        this.eras = Collections.unmodifiableMap(enumMap3);
        enumMap4 = new EnumMap(TextWidth.class);
        TextWidth[] textWidthArray = TextWidth.values();
        int n2 = textWidthArray.length;
        boolean bl2 = false;
        while (var13_29 < n2) {
            TextWidth textWidth = textWidthArray[var13_29];
            enumMap4.put(textWidth, new Accessor(provider.meridiems(string, locale, textWidth), locale));
            ++var13_29;
        }
        this.meridiems = Collections.unmodifiableMap(enumMap4);
    }

    public static CalendarText getInstance(Chronology<?> chronology, Locale locale) {
        return CalendarText.getInstance(CalendarText.extractCalendarType(chronology), locale);
    }

    public static CalendarText getInstance(String string, Locale locale) {
        if (string == null) {
            throw new NullPointerException("Missing calendar type.");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        stringBuilder.append(':');
        stringBuilder.append(locale.getLanguage());
        stringBuilder.append('-');
        stringBuilder.append(locale.getCountry());
        String string2 = stringBuilder.toString();
        Object object = (CalendarText)CACHE.get(string2);
        if (object == null) {
            Object object2 = null;
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = Provider.class.getClassLoader();
            }
            Object object3 = ServiceLoader.load(Provider.class, classLoader).iterator();
            while (object3.hasNext()) {
                Provider provider = object3.next();
                if (!CalendarText.isCalendarTypeSupported(provider, string) || !CalendarText.isLocaleSupported(provider, locale)) continue;
                object2 = provider;
                break;
            }
            if (object2 == null) {
                object3 = new Iso8601Provider();
                if (CalendarText.isCalendarTypeSupported((Provider)object3, string) && CalendarText.isLocaleSupported((Provider)object3, locale)) {
                    object2 = object3;
                }
                if (object2 == null) {
                    object2 = new FallbackProvider();
                }
            }
            if ((object3 = CACHE.putIfAbsent(string2, (CalendarText)(object = new CalendarText(string, locale, (Provider)object2)))) != null) {
                object = object3;
            }
        }
        return object;
    }

    public Accessor getStdMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, false);
    }

    public Accessor getLeapMonths(TextWidth textWidth, OutputContext outputContext) {
        return this.getMonths(textWidth, outputContext, true);
    }

    public Accessor getQuarters(TextWidth textWidth, OutputContext outputContext) {
        return this.quarters.get((Object)textWidth).get((Object)outputContext);
    }

    public Accessor getWeekdays(TextWidth textWidth, OutputContext outputContext) {
        return this.weekdays.get((Object)textWidth).get((Object)outputContext);
    }

    public Accessor getEras(TextWidth textWidth) {
        return this.eras.get((Object)textWidth);
    }

    public Accessor getMeridiems(TextWidth textWidth) {
        return this.meridiems.get((Object)textWidth);
    }

    public <V extends Enum<V>> Accessor getTextForms(ChronoElement<V> chronoElement, String ... stringArray) {
        int n;
        if (this.textForms == null) {
            throw new MissingResourceException(this.mre.getMessage(), this.mre.getClassName(), this.mre.getKey());
        }
        Enum[] enumArray = (Enum[])chronoElement.getType().getEnumConstants();
        int n2 = enumArray.length;
        String[] stringArray2 = new String[n2];
        StringBuilder stringBuilder = new StringBuilder(chronoElement.name());
        if (stringArray != null && stringArray.length > 0) {
            boolean bl = true;
            for (n = 0; n < stringArray.length; ++n) {
                if (bl) {
                    stringBuilder.append('(');
                } else {
                    stringBuilder.append('|');
                }
                stringBuilder.append(stringArray[n]);
            }
            stringBuilder.append(')');
        }
        String string = stringBuilder.toString();
        for (n = 0; n < n2; ++n) {
            String string2;
            String string3 = CalendarText.toKey(string, n);
            stringArray2[n] = this.textForms.containsKey(string3) ? this.textForms.getString(string3) : (this.textForms.containsKey(string2 = CalendarText.toKey(chronoElement.name(), n)) ? this.textForms.getString(string2) : enumArray[n].name());
        }
        return new Accessor(stringArray2, this.textForms.getLocale());
    }

    public static String getGMTPrefix(Locale locale) {
        CalendarText calendarText = CalendarText.getInstance(ISO_CALENDAR_TYPE, locale);
        if (calendarText.textForms == null) {
            return "GMT";
        }
        return calendarText.textForms.getString("prefixGMTOffset");
    }

    public String toString() {
        return this.provider;
    }

    public static void clearCache() {
        CACHE.clear();
    }

    static String extractCalendarType(Chronology<?> chronology) {
        CalendarType calendarType = chronology.getChronoType().getAnnotation(CalendarType.class);
        return calendarType == null ? ISO_CALENDAR_TYPE : calendarType.value();
    }

    private Accessor getMonths(TextWidth textWidth, OutputContext outputContext, boolean bl) {
        if (bl) {
            return this.leapMonths.get((Object)textWidth).get((Object)outputContext);
        }
        return this.stdMonths.get((Object)textWidth).get((Object)outputContext);
    }

    private static Map<TextWidth, Map<OutputContext, Accessor>> getMonths(String string, Locale locale, Provider provider, boolean bl) {
        EnumMap<TextWidth, Map<OutputContext, Accessor>> enumMap = new EnumMap<TextWidth, Map<OutputContext, Accessor>>(TextWidth.class);
        boolean bl2 = false;
        for (TextWidth textWidth : TextWidth.values()) {
            EnumMap<OutputContext, Accessor> enumMap2 = new EnumMap<OutputContext, Accessor>(OutputContext.class);
            for (OutputContext outputContext : OutputContext.values()) {
                Object[] objectArray = provider.months(string, locale, textWidth, outputContext, bl);
                if (bl && !bl2) {
                    Object[] objectArray2 = provider.months(string, locale, textWidth, outputContext, false);
                    bl2 = !Arrays.equals(objectArray2, objectArray);
                }
                enumMap2.put(outputContext, new Accessor((String[])objectArray, locale));
            }
            enumMap.put(textWidth, enumMap2);
        }
        return !bl || bl2 ? enumMap : null;
    }

    private static boolean isCalendarTypeSupported(Provider provider, String string) {
        for (String string2 : provider.getSupportedCalendarTypes()) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    private static boolean isLocaleSupported(Provider provider, Locale locale) {
        for (Locale locale2 : provider.getAvailableLocales()) {
            String string = locale.getLanguage();
            String string2 = locale.getCountry();
            if (!string.equals(locale2.getLanguage()) || !string2.isEmpty() && !string2.equals(locale2.getCountry())) continue;
            return true;
        }
        return false;
    }

    private static String toKey(String string, int n) {
        StringBuilder stringBuilder = new StringBuilder(string);
        stringBuilder.append('_');
        stringBuilder.append(n + 1);
        return stringBuilder.toString();
    }

    private static ClassLoader getLoader() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = CalendarText.class.getClassLoader();
        }
        return classLoader;
    }

    private static class UTF8NoFallbackControl
    extends ResourceBundle.Control {
        private UTF8NoFallbackControl() {
        }

        @Override
        public Locale getFallbackLocale(String string, Locale locale) {
            if (string == null || locale == null) {
                throw new NullPointerException();
            }
            return null;
        }

        @Override
        public List<String> getFormats(String string) {
            return ResourceBundle.Control.FORMAT_PROPERTIES;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ResourceBundle newBundle(String string, Locale locale, String string2, ClassLoader classLoader, boolean bl) throws IllegalAccessException, InstantiationException, IOException {
            if (string2.equals("java.properties")) {
                Object object;
                PropertyResourceBundle propertyResourceBundle = null;
                InputStream inputStream = null;
                String string3 = this.toBundleName(string, locale);
                String string4 = this.toResourceName(string3, "properties");
                if (bl) {
                    object = classLoader.getResource(string4);
                    if (object != null) {
                        URLConnection uRLConnection = ((URL)object).openConnection();
                        uRLConnection.setUseCaches(false);
                        inputStream = uRLConnection.getInputStream();
                    }
                } else {
                    inputStream = classLoader.getResourceAsStream(string4);
                }
                if (inputStream != null) {
                    object = null;
                    try {
                        object = new BufferedReader(new InputStreamReader(inputStream, "UTF-8"));
                        propertyResourceBundle = new PropertyResourceBundle((Reader)object);
                    }
                    finally {
                        if (object != null) {
                            ((Reader)object).close();
                        }
                    }
                }
                return propertyResourceBundle;
            }
            throw new UnsupportedOperationException("Unknown resource bundle format: " + string2);
        }
    }

    private static class FallbackProvider
    implements Provider {
        private FallbackProvider() {
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public Locale[] getAvailableLocales() {
            throw new UnsupportedOperationException("Never called.");
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
            if (textWidth == TextWidth.WIDE) {
                return new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13"};
            }
            return new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12", "13"};
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"1", "2", "3", "4"};
            }
            return new String[]{"Q1", "Q2", "Q3", "Q4"};
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            return new String[]{"1", "2", "3", "4", "5", "6", "7"};
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"B", "A"};
            }
            return new String[]{"BC", "AD"};
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"A", "P"};
            }
            return new String[]{"AM", "PM"};
        }

        public String toString() {
            return "FallbackProvider";
        }
    }

    private static class Iso8601Provider
    implements Provider {
        private Iso8601Provider() {
        }

        @Override
        public String[] getSupportedCalendarTypes() {
            return new String[]{CalendarText.ISO_CALENDAR_TYPE};
        }

        @Override
        public Locale[] getAvailableLocales() {
            return DateFormatSymbols.getAvailableLocales();
        }

        @Override
        public String[] months(String string, Locale locale, TextWidth textWidth, OutputContext outputContext, boolean bl) {
            String[] stringArray;
            ResourceBundle resourceBundle = Iso8601Provider.getBundle(locale);
            if (resourceBundle != null && !locale.equals(Locale.ROOT)) {
                String string2 = Iso8601Provider.getKey(resourceBundle, "MONTH_OF_YEAR");
                if (textWidth == TextWidth.SHORT) {
                    textWidth = TextWidth.ABBREVIATED;
                }
                if ((stringArray = outputContext == OutputContext.STANDALONE && "true".equals(resourceBundle.getObject("enableStandalone")) ? Iso8601Provider.lookupBundle(resourceBundle, 12, string2, textWidth, outputContext) : Iso8601Provider.lookupBundle(resourceBundle, 12, string2, textWidth)) != null) {
                    return stringArray;
                }
                if (textWidth == TextWidth.NARROW) {
                    stringArray = this.months("", locale, TextWidth.SHORT, outputContext, false);
                    return Iso8601Provider.narrow(stringArray, 12);
                }
            }
            stringArray = DateFormatSymbols.getInstance(locale);
            switch (textWidth) {
                case WIDE: {
                    return stringArray.getMonths();
                }
                case ABBREVIATED: 
                case SHORT: {
                    return stringArray.getShortMonths();
                }
                case NARROW: {
                    return Iso8601Provider.narrow(stringArray.getShortMonths(), 12);
                }
            }
            throw new UnsupportedOperationException(textWidth.name());
        }

        @Override
        public String[] quarters(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            ResourceBundle resourceBundle = Iso8601Provider.getBundle(locale);
            if (resourceBundle != null) {
                String[] stringArray;
                String string2 = Iso8601Provider.getKey(resourceBundle, "QUARTER_OF_YEAR");
                if (textWidth == TextWidth.SHORT) {
                    textWidth = TextWidth.ABBREVIATED;
                }
                if ((stringArray = outputContext == OutputContext.STANDALONE && "true".equals(resourceBundle.getObject("enableStandalone")) ? Iso8601Provider.lookupBundle(resourceBundle, 4, string2, textWidth, outputContext) : Iso8601Provider.lookupBundle(resourceBundle, 4, string2, textWidth)) != null) {
                    return stringArray;
                }
            }
            return new String[]{"Q1", "Q2", "Q3", "Q4"};
        }

        @Override
        public String[] weekdays(String string, Locale locale, TextWidth textWidth, OutputContext outputContext) {
            Object object;
            String[] stringArray;
            String[] stringArray2;
            ResourceBundle resourceBundle = Iso8601Provider.getBundle(locale);
            if (resourceBundle != null && !locale.equals(Locale.ROOT)) {
                stringArray2 = Iso8601Provider.getKey(resourceBundle, "DAY_OF_WEEK");
                stringArray = outputContext == OutputContext.STANDALONE && "true".equals(resourceBundle.getObject("enableStandalone")) ? Iso8601Provider.lookupBundle(resourceBundle, 7, (String)stringArray2, textWidth, outputContext) : Iso8601Provider.lookupBundle(resourceBundle, 7, (String)stringArray2, textWidth);
                if (stringArray != null) {
                    return stringArray;
                }
                if (textWidth == TextWidth.SHORT) {
                    return this.weekdays("", locale, TextWidth.ABBREVIATED, outputContext);
                }
                if (textWidth == TextWidth.NARROW) {
                    stringArray = this.weekdays("", locale, TextWidth.SHORT, outputContext);
                    return Iso8601Provider.narrow(stringArray, 7);
                }
            }
            stringArray = DateFormatSymbols.getInstance(locale);
            switch (textWidth) {
                case WIDE: {
                    stringArray2 = stringArray.getWeekdays();
                    break;
                }
                case ABBREVIATED: 
                case SHORT: {
                    stringArray2 = stringArray.getShortWeekdays();
                    break;
                }
                case NARROW: {
                    object = this.weekdays("", locale, TextWidth.SHORT, outputContext);
                    stringArray2 = Iso8601Provider.narrow(object, 7);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown text width: " + (Object)((Object)textWidth));
                }
            }
            if (stringArray2.length > 7) {
                object = stringArray2[1];
                String[] stringArray3 = new String[7];
                for (int i = 2; i < 8; ++i) {
                    stringArray3[i - 2] = stringArray2[i];
                }
                stringArray3[6] = object;
                stringArray2 = stringArray3;
            }
            return stringArray2;
        }

        @Override
        public String[] eras(String string, Locale locale, TextWidth textWidth) {
            Object object;
            String[] stringArray;
            ResourceBundle resourceBundle = Iso8601Provider.getBundle(locale);
            if (resourceBundle != null && !locale.equals(Locale.ROOT) && (stringArray = Iso8601Provider.lookupBundle(resourceBundle, 2, (String)(object = Iso8601Provider.getKey(resourceBundle, "ERA")), textWidth)) != null) {
                return stringArray;
            }
            object = DateFormatSymbols.getInstance(locale);
            if (textWidth == TextWidth.NARROW) {
                stringArray = ((DateFormatSymbols)object).getEras();
                String[] stringArray2 = new String[stringArray.length];
                int n = stringArray.length;
                for (int i = 0; i < n; ++i) {
                    stringArray2[i] = !stringArray[i].isEmpty() ? Iso8601Provider.toSingleLetter(stringArray[i]) : (i == 0 && stringArray.length == 2 ? "B" : (i == 1 && stringArray.length == 2 ? "A" : String.valueOf(i)));
                }
                return stringArray2;
            }
            return ((DateFormatSymbols)object).getEras();
        }

        @Override
        public String[] meridiems(String string, Locale locale, TextWidth textWidth) {
            String string2;
            String[] stringArray;
            ResourceBundle resourceBundle = Iso8601Provider.getBundle(locale);
            if (resourceBundle != null && !locale.equals(Locale.ROOT) && (stringArray = Iso8601Provider.lookupBundle(resourceBundle, 2, string2 = Iso8601Provider.getKey(resourceBundle, "AM_PM_OF_DAY"), textWidth)) != null) {
                return stringArray;
            }
            if (textWidth == TextWidth.NARROW) {
                return new String[]{"A", "P"};
            }
            return DateFormatSymbols.getInstance(locale).getAmPmStrings();
        }

        public String toString() {
            return "Iso8601Provider";
        }

        private static String[] narrow(String[] stringArray, int n) {
            String[] stringArray2 = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray2[i] = !stringArray[i].isEmpty() ? Iso8601Provider.toSingleLetter(stringArray[i]) : String.valueOf(i + 1);
            }
            return stringArray2;
        }

        private static String toSingleLetter(String string) {
            char c = Normalizer.normalize(string, Normalizer.Form.NFD).charAt(0);
            if (c >= 'A' && c <= 'Z') {
                return String.valueOf(c);
            }
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 32);
                return String.valueOf(c);
            }
            if (c >= '\u0410' && c <= '\u042f') {
                return String.valueOf(c);
            }
            if (c >= '\u0430' && c <= '\u044f') {
                c = (char)(c - 32);
                return String.valueOf(c);
            }
            return string;
        }

        private static ResourceBundle getBundle(Locale locale) {
            try {
                return ResourceBundle.getBundle("data/iso8601", locale, CalendarText.getLoader(), CONTROL);
            }
            catch (MissingResourceException missingResourceException) {
                return null;
            }
        }

        private static String[] lookupBundle(ResourceBundle resourceBundle, int n, String string, TextWidth textWidth) {
            return Iso8601Provider.lookupBundle(resourceBundle, n, string, textWidth, null);
        }

        private static String[] lookupBundle(ResourceBundle resourceBundle, int n, String string, TextWidth textWidth, OutputContext outputContext) {
            String[] stringArray = new String[n];
            boolean bl = string.length() == 1;
            for (int i = 0; i < n; ++i) {
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(string);
                stringBuilder.append('(');
                if (bl) {
                    char c = textWidth.name().charAt(0);
                    if (outputContext != OutputContext.STANDALONE) {
                        c = Character.toLowerCase(c);
                    }
                    stringBuilder.append(c);
                } else {
                    stringBuilder.append(textWidth.name());
                    if (outputContext == OutputContext.STANDALONE) {
                        stringBuilder.append('|');
                        stringBuilder.append(outputContext.name());
                    }
                }
                stringBuilder.append(')');
                stringBuilder.append('_');
                stringBuilder.append(i + 1);
                String string2 = stringBuilder.toString();
                if (!resourceBundle.containsKey(string2)) {
                    return null;
                }
                stringArray[i] = resourceBundle.getString(string2);
            }
            return stringArray;
        }

        private static String getKey(ResourceBundle resourceBundle, String string) {
            if (resourceBundle.containsKey("useShortKeys") && "true".equals(resourceBundle.getString("useShortKeys"))) {
                return string.substring(0, 1);
            }
            return string;
        }
    }

    public static final class Accessor {
        private final List<String> textForms;
        private final Locale locale;

        private Accessor(String[] stringArray, Locale locale) {
            this.textForms = Collections.unmodifiableList(Arrays.asList(stringArray));
            this.locale = locale;
        }

        public String print(Enum<?> enum_) {
            int n = enum_.ordinal();
            if (this.textForms.size() <= n) {
                return enum_.name();
            }
            return this.textForms.get(n);
        }

        public <V extends Enum<V>> V parse(CharSequence charSequence, ParseLog parseLog, Class<V> clazz) {
            return this.parse(charSequence, parseLog, clazz, true, false);
        }

        public <V extends Enum<V>> V parse(CharSequence charSequence, ParseLog parseLog, Class<V> clazz, AttributeQuery attributeQuery) {
            boolean bl = attributeQuery.get(Attributes.PARSE_CASE_INSENSITIVE, Boolean.TRUE);
            boolean bl2 = attributeQuery.get(Attributes.PARSE_PARTIAL_COMPARE, Boolean.FALSE);
            return this.parse(charSequence, parseLog, clazz, bl, bl2);
        }

        public String toString() {
            int n = this.textForms.size();
            StringBuilder stringBuilder = new StringBuilder(n * 16 + 2);
            stringBuilder.append('{');
            boolean bl = true;
            for (int i = 0; i < n; ++i) {
                if (bl) {
                    bl = false;
                } else {
                    stringBuilder.append(',');
                }
                stringBuilder.append(this.textForms.get(i));
            }
            stringBuilder.append('}');
            return stringBuilder.toString();
        }

        private <V extends Enum<V>> V parse(CharSequence charSequence, ParseLog parseLog, Class<V> clazz, boolean bl, boolean bl2) {
            Enum[] enumArray = (Enum[])clazz.getEnumConstants();
            int n = this.textForms.size();
            int n2 = parseLog.getPosition();
            int n3 = charSequence.length();
            int n4 = 0;
            Enum enum_ = null;
            for (int i = 0; i < enumArray.length; ++i) {
                String string = i >= n ? enumArray[i].name() : this.textForms.get(i);
                int n5 = n2;
                int n6 = string.length();
                boolean bl3 = true;
                for (int j = 0; bl3 && j < n6; ++j) {
                    if (n2 + j >= n3) {
                        bl3 = false;
                        continue;
                    }
                    char c = charSequence.charAt(n2 + j);
                    char c2 = string.charAt(j);
                    if (bl) {
                        bl3 = this.compareIgnoreCase(c, c2);
                    } else {
                        boolean bl4 = bl3 = c == c2;
                    }
                    if (!bl3) continue;
                    ++n5;
                }
                if (bl3) {
                    assert (n5 == n2 + n6);
                    parseLog.setPosition(n5);
                    return (V)enumArray[i];
                }
                if (!bl2 || n4 >= n5 - n2) continue;
                n4 = n5 - n2;
                enum_ = enumArray[i];
            }
            if (enum_ == null) {
                parseLog.setError(n2);
            } else {
                parseLog.setPosition(n2 + n4);
            }
            return (V)enum_;
        }

        private boolean compareIgnoreCase(char c, char c2) {
            if (c >= 'a' && c <= 'z') {
                c = (char)(c - 97 + 65);
            }
            if (c2 >= 'a' && c2 <= 'z') {
                c2 = (char)(c2 - 97 + 65);
            }
            if (c >= 'A' && c <= 'Z') {
                return c == c2;
            }
            String string = String.valueOf(c).toUpperCase(this.locale);
            String string2 = String.valueOf(c2).toUpperCase(this.locale);
            return string.equals(string2);
        }
    }

    public static interface Provider {
        public String[] getSupportedCalendarTypes();

        public Locale[] getAvailableLocales();

        public String[] months(String var1, Locale var2, TextWidth var3, OutputContext var4, boolean var5);

        public String[] quarters(String var1, Locale var2, TextWidth var3, OutputContext var4);

        public String[] weekdays(String var1, Locale var2, TextWidth var3, OutputContext var4);

        public String[] eras(String var1, Locale var2, TextWidth var3);

        public String[] meridiems(String var1, Locale var2, TextWidth var3);
    }
}

