/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.ChronoException;
import net.time4j.engine.ChronoOperator;
import net.time4j.engine.ElementRule;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimePoint;

public abstract class AdvancedElement<V extends Comparable<V>>
extends BasicElement<V> {
    private static final int MIN_MODE = 1;
    private static final int MAX_MODE = 2;
    private static final int FLOOR_MODE = 3;
    private static final int CEILING_MODE = 4;
    private static final int LENIENT_MODE = 5;
    private static final int DECREMENTING_MODE = 6;
    private static final int INCREMENTING_MODE = 7;

    protected AdvancedElement(String string) {
        super(string);
    }

    @Override
    public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
        return ((Comparable)chronoEntity.get(this)).compareTo(chronoEntity2.get(this));
    }

    public <T extends ChronoEntity<T>> ChronoOperator<T> minimized(Class<T> clazz) {
        return new StdOperator(1, this);
    }

    public <T extends ChronoEntity<T>> ChronoOperator<T> maximized(Class<T> clazz) {
        return new StdOperator(2, this);
    }

    public <T extends ChronoEntity<T>> ChronoOperator<T> decremented(Class<T> clazz) {
        return new StdOperator(6, this);
    }

    public <T extends ChronoEntity<T>> ChronoOperator<T> incremented(Class<T> clazz) {
        return new StdOperator(7, this);
    }

    public <T extends ChronoEntity<T>> ChronoOperator<T> atFloor(Class<T> clazz) {
        return new StdOperator(3, this);
    }

    public <T extends ChronoEntity<T>> ChronoOperator<T> atCeiling(Class<T> clazz) {
        return new StdOperator(4, this);
    }

    public <T extends ChronoEntity<T>> ChronoOperator<T> setLenient(V v, Class<T> clazz) {
        return new StdOperator(5, this, v);
    }

    private static class StdOperator<T extends ChronoEntity<T>>
    implements ChronoOperator<T> {
        private final int mode;
        private final ChronoElement<?> element;
        private final Object value;

        StdOperator(int n, ChronoElement<?> chronoElement) {
            this(n, chronoElement, null);
        }

        StdOperator(int n, ChronoElement<?> chronoElement, Object object) {
            this.mode = n;
            this.element = chronoElement;
            this.value = object;
        }

        @Override
        public T apply(T t) {
            switch (this.mode) {
                case 1: {
                    return StdOperator.min(t, this.element);
                }
                case 2: {
                    return StdOperator.max(t, this.element);
                }
                case 3: {
                    return StdOperator.floor(t, this.element);
                }
                case 4: {
                    return StdOperator.ceiling(t, this.element);
                }
                case 5: {
                    return StdOperator.value(t, this.element, this.value, true);
                }
                case 6: {
                    return this.move(t, false);
                }
                case 7: {
                    return this.move(t, true);
                }
            }
            throw new UnsupportedOperationException("Unknown mode: " + this.mode);
        }

        private static <T extends ChronoEntity<T>, V> T min(ChronoEntity<T> chronoEntity, ChronoElement<V> chronoElement) {
            return chronoEntity.with(chronoElement, chronoEntity.getMinimum(chronoElement));
        }

        private static <T extends ChronoEntity<T>, V> T max(ChronoEntity<T> chronoEntity, ChronoElement<V> chronoElement) {
            return chronoEntity.with(chronoElement, chronoEntity.getMaximum(chronoElement));
        }

        private static <T extends ChronoEntity<T>, V> T floor(ChronoEntity<T> chronoEntity, ChronoElement<V> chronoElement) {
            T t = chronoEntity.getContext();
            ChronoElement<Object> chronoElement2 = chronoElement;
            while ((chronoElement2 = StdOperator.getRule(t, chronoElement2).getChildAtFloor(t)) != null) {
                t = StdOperator.withFloor(t, chronoElement2);
            }
            return t;
        }

        private static <T extends ChronoEntity<T>, V> T ceiling(ChronoEntity<T> chronoEntity, ChronoElement<V> chronoElement) {
            T t = chronoEntity.getContext();
            ChronoElement<Object> chronoElement2 = chronoElement;
            while ((chronoElement2 = StdOperator.getRule(t, chronoElement2).getChildAtCeiling(t)) != null) {
                t = StdOperator.withCeiling(t, chronoElement2);
            }
            return t;
        }

        private static <T extends ChronoEntity<T>, V> T value(ChronoEntity<T> chronoEntity, ChronoElement<V> chronoElement, Object object, boolean bl) {
            T t = chronoEntity.getContext();
            return (T)((ChronoEntity)StdOperator.getRule(t, chronoElement).withValue(t, chronoElement.getType().cast(object), bl));
        }

        private static <T extends ChronoEntity<T>, V> ElementRule<T, V> getRule(T t, ChronoElement<V> chronoElement) {
            return t.getChronology().getRule(chronoElement);
        }

        private static <T extends ChronoEntity<T>, V> T withFloor(T t, ChronoElement<V> chronoElement) {
            ElementRule<T, V> elementRule = StdOperator.getRule(t, chronoElement);
            return elementRule.withValue(t, elementRule.getMinimum(t), chronoElement.isLenient());
        }

        private static <T extends ChronoEntity<T>, V> T withCeiling(T t, ChronoElement<V> chronoElement) {
            ElementRule<T, V> elementRule = StdOperator.getRule(t, chronoElement);
            return elementRule.withValue(t, elementRule.getMaximum(t), chronoElement.isLenient());
        }

        private T move(T t, boolean bl) {
            ChronoEntity chronoEntity = null;
            if (!(t instanceof TimePoint)) {
                throw new ChronoException("Base units not supported by: " + ((ChronoEntity)t).getChronology().getChronoType());
            }
            TimePoint timePoint = (TimePoint)TimePoint.class.cast(t);
            T t2 = StdOperator.add(timePoint, this.element, bl);
            chronoEntity = (ChronoEntity)((ChronoEntity)t).getChronology().getChronoType().cast(t2);
            return (T)chronoEntity;
        }

        private static <U, T extends TimePoint<U, T>> T add(TimePoint<U, T> timePoint, ChronoElement<?> chronoElement, boolean bl) {
            Object u = ((TimeAxis)timePoint.getChronology()).getBaseUnit(chronoElement);
            if (bl) {
                return timePoint.plus(1L, u);
            }
            return timePoint.minus(1L, u);
        }
    }
}

