/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import net.time4j.Moment;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.SI;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;
import net.time4j.scale.TimeScale;
import net.time4j.scale.UniversalTime;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

final class ZonalTimestamp
extends ChronoEntity<ZonalTimestamp>
implements UniversalTime {
    private final Moment moment;
    private final Timezone zone;
    private final transient PlainTimestamp timestamp;

    ZonalTimestamp(Moment moment, TZID tZID) {
        this.zone = tZID == null ? Timezone.ofSystem() : Timezone.of(tZID);
        ZonalOffset zonalOffset = this.zone.getOffset(moment);
        if (moment.isLeapSecond() && (zonalOffset.getFractionalAmount() != 0 || zonalOffset.getAbsoluteSeconds() % 60 != 0)) {
            throw new IllegalArgumentException("Leap second can only be formatted  with timezone-offset in full minutes: " + zonalOffset);
        }
        this.moment = moment;
        this.timestamp = PlainTimestamp.from(moment, zonalOffset);
    }

    @Override
    public boolean contains(ChronoElement<?> chronoElement) {
        return this.timestamp.contains(chronoElement);
    }

    @Override
    public <V> V get(ChronoElement<V> chronoElement) {
        if (this.moment.isLeapSecond() && chronoElement == PlainTime.SECOND_OF_MINUTE) {
            return chronoElement.getType().cast(60);
        }
        return this.timestamp.get(chronoElement);
    }

    @Override
    public <V> V getMinimum(ChronoElement<V> chronoElement) {
        return this.timestamp.getMinimum(chronoElement);
    }

    @Override
    public <V> V getMaximum(ChronoElement<V> chronoElement) {
        Moment moment;
        Moment moment2;
        PlainTimestamp plainTimestamp;
        V v = this.timestamp.getMaximum(chronoElement);
        if (chronoElement == PlainTime.SECOND_OF_MINUTE && this.timestamp.getYear() >= 1972 && !this.zone.isInvalid(plainTimestamp = (PlainTimestamp)this.timestamp.with(chronoElement, v), plainTimestamp) && (moment2 = (moment = plainTimestamp.in(this.zone)).plus(1L, SI.SECONDS)).isLeapSecond()) {
            return chronoElement.getType().cast(60);
        }
        return v;
    }

    @Override
    public <V> boolean isValid(ChronoElement<V> chronoElement, V v) {
        if (chronoElement == null) {
            throw new NullPointerException("Missing chronological element.");
        }
        return false;
    }

    @Override
    public <V> ZonalTimestamp with(ChronoElement<V> chronoElement, V v) {
        throw new IllegalArgumentException("Zonal timestamps are effectively read-only.");
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ZonalTimestamp) {
            ZonalTimestamp zonalTimestamp = (ZonalTimestamp)object;
            return this.moment.equals(zonalTimestamp.moment) && this.zone.equals(zonalTimestamp.zone);
        }
        return false;
    }

    public int hashCode() {
        return this.moment.hashCode() ^ this.zone.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[moment=");
        stringBuilder.append(this.moment);
        stringBuilder.append(", time-zone=");
        stringBuilder.append(this.zone);
        stringBuilder.append(']');
        return stringBuilder.toString();
    }

    @Override
    public long getElapsedTime(TimeScale timeScale) {
        return this.moment.getElapsedTime(timeScale);
    }

    @Override
    public int getNanosecond(TimeScale timeScale) {
        return this.moment.getNanosecond(timeScale);
    }

    @Override
    public boolean isLeapSecond() {
        return this.moment.isLeapSecond();
    }

    @Override
    public long getPosixTime() {
        return this.moment.getPosixTime();
    }

    @Override
    public int getNanosecond() {
        return this.moment.getNanosecond();
    }

    @Override
    public boolean hasTimezone() {
        return true;
    }

    @Override
    public TZID getTimezone() {
        return this.zone.getID();
    }

    @Override
    protected Chronology<ZonalTimestamp> getChronology() {
        throw new UnsupportedOperationException("Zonal timestamps have no defined chronology.");
    }

    @Override
    protected ZonalTimestamp getContext() {
        return this;
    }
}

