/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.ObjectStreamException;
import net.time4j.ElementOperator;
import net.time4j.FullValueOperator;
import net.time4j.PlainTime;
import net.time4j.WallTimeElement;
import net.time4j.WallTimeOperator;
import net.time4j.base.UnixTime;
import net.time4j.engine.BasicElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.Chronology;

final class TimeElement
extends BasicElement<PlainTime>
implements WallTimeElement {
    static final TimeElement INSTANCE = new TimeElement();
    private static final long serialVersionUID = -3712256393866098916L;

    private TimeElement() {
        super("WALL_TIME");
    }

    @Override
    public Class<PlainTime> getType() {
        return PlainTime.class;
    }

    @Override
    public PlainTime getDefaultMinimum() {
        return PlainTime.MIN;
    }

    @Override
    public PlainTime getDefaultMaximum() {
        return PlainTime.of(23, 59, 59, 999999999);
    }

    @Override
    public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
        return chronoEntity.get(this).compareTo(chronoEntity2.get(this));
    }

    @Override
    public boolean isDateElement() {
        return false;
    }

    @Override
    public boolean isTimeElement() {
        return true;
    }

    @Override
    public ElementOperator<?> setToNext(PlainTime plainTime) {
        return new WallTimeOperator(9, plainTime);
    }

    @Override
    public ElementOperator<?> setToPrevious(PlainTime plainTime) {
        return new WallTimeOperator(10, plainTime);
    }

    @Override
    public ElementOperator<?> setToNextOrSame(PlainTime plainTime) {
        return new WallTimeOperator(11, plainTime);
    }

    @Override
    public ElementOperator<?> setToPreviousOrSame(PlainTime plainTime) {
        return new WallTimeOperator(12, plainTime);
    }

    @Override
    public ElementOperator<PlainTime> roundedToFullHour() {
        return FullValueOperator.ROUNDING_FULL_HOUR;
    }

    @Override
    public ElementOperator<PlainTime> roundedToFullMinute() {
        return FullValueOperator.ROUNDING_FULL_MINUTE;
    }

    @Override
    public ElementOperator<PlainTime> setToNextFullHour() {
        return FullValueOperator.NEXT_FULL_HOUR;
    }

    @Override
    public ElementOperator<PlainTime> setToNextFullMinute() {
        return FullValueOperator.NEXT_FULL_MINUTE;
    }

    @Override
    protected String getVeto(Chronology<?> chronology) {
        if (UnixTime.class.isAssignableFrom(chronology.getChronoType())) {
            return "Accessing the wall time component from a global type requires a timezone. Try to first convert the global type to a PlainTimestamp: \"moment.inZonalView(...)\".";
        }
        return null;
    }

    private Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

