/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.text.DecimalFormatSymbols;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.PlainTimestamp;
import net.time4j.SystemClock;
import net.time4j.base.MathUtils;
import net.time4j.base.TimeSource;
import net.time4j.base.UnixTime;
import net.time4j.engine.TimeSpan;
import net.time4j.format.NumberType;
import net.time4j.format.PluralCategory;
import net.time4j.format.PluralRules;
import net.time4j.format.TextWidth;
import net.time4j.format.UnitPatterns;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public final class PrettyTime {
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static final int MIO = 1000000;
    private static final char UNICODE_RLM = '\u200f';
    private static final ConcurrentMap<Locale, PrettyTime> LANGUAGE_MAP = new ConcurrentHashMap<Locale, PrettyTime>();
    private static final IsoUnit[] STD_UNITS;
    private static final Set<IsoUnit> SUPPORTED_UNITS;
    private final PluralRules rules;
    private final Locale locale;
    private final TimeSource<?> refClock;
    private final char zeroDigit;
    private final IsoUnit emptyUnit;
    private final int minusOrientation;
    private final char minusSign;

    private PrettyTime(Locale locale, TimeSource<?> timeSource, char c, IsoUnit isoUnit) {
        if (isoUnit == null) {
            throw new NullPointerException("Missing zero time unit.");
        }
        if (timeSource == null) {
            throw new NullPointerException("Missing reference clock.");
        }
        this.rules = PluralRules.of(locale, NumberType.CARDINALS);
        this.locale = locale;
        this.refClock = timeSource;
        this.zeroDigit = c;
        this.emptyUnit = isoUnit;
        char c2 = DecimalFormatSymbols.getInstance(locale).getMinusSign();
        String string = NumberFormat.getInstance(locale).format(-123L);
        this.minusOrientation = string.charAt(string.length() - 1) == c2 ? 1 : 0;
        this.minusSign = c2;
    }

    public static PrettyTime of(Locale locale) {
        PrettyTime prettyTime;
        PrettyTime prettyTime2 = (PrettyTime)LANGUAGE_MAP.get(locale);
        if (prettyTime2 == null && (prettyTime = LANGUAGE_MAP.putIfAbsent(locale, prettyTime2 = new PrettyTime(locale, SystemClock.INSTANCE, DecimalFormatSymbols.getInstance(locale).getZeroDigit(), ClockUnit.SECONDS))) != null) {
            prettyTime2 = prettyTime;
        }
        return prettyTime2;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public TimeSource<?> getReferenceClock() {
        return this.refClock;
    }

    public PrettyTime withReferenceClock(TimeSource<?> timeSource) {
        return new PrettyTime(this.locale, timeSource, this.zeroDigit, this.emptyUnit);
    }

    public PrettyTime withZeroDigit(char c) {
        return new PrettyTime(this.locale, this.refClock, c, this.emptyUnit);
    }

    public PrettyTime withEmptyUnit(CalendarUnit calendarUnit) {
        return new PrettyTime(this.locale, this.refClock, Character.valueOf(this.zeroDigit).charValue(), calendarUnit);
    }

    public PrettyTime withEmptyUnit(ClockUnit clockUnit) {
        return new PrettyTime(this.locale, this.refClock, Character.valueOf(this.zeroDigit).charValue(), clockUnit);
    }

    public String print(long l, CalendarUnit calendarUnit, TextWidth textWidth) {
        String string;
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        switch (calendarUnit) {
            case MILLENNIA: {
                l = MathUtils.safeMultiply(l, 1000L);
                string = unitPatterns.getYears(textWidth, this.getCategory(l));
                break;
            }
            case CENTURIES: {
                l = MathUtils.safeMultiply(l, 100L);
                string = unitPatterns.getYears(textWidth, this.getCategory(l));
                break;
            }
            case DECADES: {
                l = MathUtils.safeMultiply(l, 10L);
                string = unitPatterns.getYears(textWidth, this.getCategory(l));
                break;
            }
            case YEARS: {
                string = unitPatterns.getYears(textWidth, this.getCategory(l));
                break;
            }
            case QUARTERS: {
                l = MathUtils.safeMultiply(l, 3L);
                string = unitPatterns.getMonths(textWidth, this.getCategory(l));
                break;
            }
            case MONTHS: {
                string = unitPatterns.getMonths(textWidth, this.getCategory(l));
                break;
            }
            case WEEKS: {
                string = unitPatterns.getWeeks(textWidth, this.getCategory(l));
                break;
            }
            case DAYS: {
                string = unitPatterns.getDays(textWidth, this.getCategory(l));
                break;
            }
            default: {
                throw new UnsupportedOperationException(calendarUnit.name());
            }
        }
        return this.format(string, l);
    }

    public String print(long l, ClockUnit clockUnit, TextWidth textWidth) {
        String string;
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        switch (clockUnit) {
            case HOURS: {
                string = unitPatterns.getHours(textWidth, this.getCategory(l));
                break;
            }
            case MINUTES: {
                string = unitPatterns.getMinutes(textWidth, this.getCategory(l));
                break;
            }
            case SECONDS: {
                string = unitPatterns.getSeconds(textWidth, this.getCategory(l));
                break;
            }
            case MILLIS: {
                string = unitPatterns.getMillis(textWidth, this.getCategory(l));
                break;
            }
            case MICROS: {
                string = unitPatterns.getMicros(textWidth, this.getCategory(l));
                break;
            }
            case NANOS: {
                string = unitPatterns.getNanos(textWidth, this.getCategory(l));
                break;
            }
            default: {
                throw new UnsupportedOperationException(clockUnit.name());
            }
        }
        return this.format(string, l);
    }

    public String print(Duration<?> duration, TextWidth textWidth) {
        if (duration.isEmpty()) {
            if (this.emptyUnit.isCalendrical()) {
                CalendarUnit calendarUnit = (CalendarUnit)CalendarUnit.class.cast(this.emptyUnit);
                return this.print(0L, calendarUnit, textWidth);
            }
            ClockUnit clockUnit = (ClockUnit)ClockUnit.class.cast(this.emptyUnit);
            return this.print(0L, clockUnit, textWidth);
        }
        int n = duration.getTotalLength().size();
        boolean bl = duration.isNegative();
        if (n == 1) {
            TimeSpan.Item<?> item = duration.getTotalLength().get(0);
            return this.format(item, bl, textWidth);
        }
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        Object[] objectArray = new Object[n];
        for (int i = 0; i < n; ++i) {
            objectArray[i] = this.format(duration.getTotalLength().get(i), bl, textWidth);
        }
        return MessageFormat.format(unitPatterns.getListPattern(textWidth, n), objectArray);
    }

    public String printRelative(UnixTime unixTime, TZID tZID) {
        return this.print(unixTime, Timezone.of(tZID));
    }

    public String printRelative(UnixTime unixTime, String string) {
        return this.print(unixTime, Timezone.of(string));
    }

    private String print(UnixTime unixTime, Timezone timezone) {
        Object obj = this.getReferenceClock().currentTime();
        PlainTimestamp plainTimestamp = PlainTimestamp.from(obj, timezone.getOffset((UnixTime)obj));
        PlainTimestamp plainTimestamp2 = PlainTimestamp.from(unixTime, timezone.getOffset(unixTime));
        Duration<IsoUnit> duration = Duration.in(timezone, STD_UNITS).between(plainTimestamp, plainTimestamp2);
        if (duration.isEmpty()) {
            return UnitPatterns.of(this.locale).getNowWord();
        }
        TimeSpan.Item<IsoUnit> item = duration.getTotalLength().get(0);
        long l = item.getAmount();
        IsoUnit isoUnit = item.getUnit();
        String string = duration.isNegative() ? (isoUnit.isCalendrical() ? this.getPastPattern(l, (CalendarUnit)isoUnit) : this.getPastPattern(l, (ClockUnit)isoUnit)) : (isoUnit.isCalendrical() ? this.getFuturePattern(l, (CalendarUnit)isoUnit) : this.getFuturePattern(l, (ClockUnit)isoUnit));
        return this.format(string, l);
    }

    private String getPastPattern(long l, CalendarUnit calendarUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l);
        switch (calendarUnit) {
            case YEARS: {
                return unitPatterns.getYearsInPast(pluralCategory);
            }
            case MONTHS: {
                return unitPatterns.getMonthsInPast(pluralCategory);
            }
            case WEEKS: {
                return unitPatterns.getWeeksInPast(pluralCategory);
            }
            case DAYS: {
                return unitPatterns.getDaysInPast(pluralCategory);
            }
        }
        throw new UnsupportedOperationException(calendarUnit.name());
    }

    private String getFuturePattern(long l, CalendarUnit calendarUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l);
        switch (calendarUnit) {
            case YEARS: {
                return unitPatterns.getYearsInFuture(pluralCategory);
            }
            case MONTHS: {
                return unitPatterns.getMonthsInFuture(pluralCategory);
            }
            case WEEKS: {
                return unitPatterns.getWeeksInFuture(pluralCategory);
            }
            case DAYS: {
                return unitPatterns.getDaysInFuture(pluralCategory);
            }
        }
        throw new UnsupportedOperationException(calendarUnit.name());
    }

    private String getPastPattern(long l, ClockUnit clockUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l);
        switch (clockUnit) {
            case HOURS: {
                return unitPatterns.getHoursInPast(pluralCategory);
            }
            case MINUTES: {
                return unitPatterns.getMinutesInPast(pluralCategory);
            }
            case SECONDS: {
                return unitPatterns.getSecondsInPast(pluralCategory);
            }
        }
        throw new UnsupportedOperationException(clockUnit.name());
    }

    private String getFuturePattern(long l, ClockUnit clockUnit) {
        UnitPatterns unitPatterns = UnitPatterns.of(this.locale);
        PluralCategory pluralCategory = this.getCategory(l);
        switch (clockUnit) {
            case HOURS: {
                return unitPatterns.getHoursInFuture(pluralCategory);
            }
            case MINUTES: {
                return unitPatterns.getMinutesInFuture(pluralCategory);
            }
            case SECONDS: {
                return unitPatterns.getSecondsInFuture(pluralCategory);
            }
        }
        throw new UnsupportedOperationException(clockUnit.name());
    }

    private PluralCategory getCategory(long l) {
        return this.rules.getCategory(Math.abs(l));
    }

    private String format(TimeSpan.Item<? extends IsoUnit> item, boolean bl, TextWidth textWidth) {
        long l;
        IsoUnit isoUnit = item.getUnit();
        long l2 = l = item.getAmount();
        if (bl) {
            l2 = MathUtils.safeNegate(l);
        }
        if (SUPPORTED_UNITS.contains(isoUnit)) {
            if (isoUnit.isCalendrical()) {
                CalendarUnit calendarUnit = (CalendarUnit)CalendarUnit.class.cast(isoUnit);
                return this.print(l2, calendarUnit, textWidth);
            }
            ClockUnit clockUnit = (ClockUnit)ClockUnit.class.cast(isoUnit);
            if (clockUnit == ClockUnit.NANOS) {
                if (l % 1000000L == 0L) {
                    clockUnit = ClockUnit.MILLIS;
                    l2 /= 1000000L;
                } else if (l % 1000L == 0L) {
                    clockUnit = ClockUnit.MICROS;
                    l2 /= 1000L;
                }
            }
            return this.print(l2, clockUnit, textWidth);
        }
        return this.format(l2) + " " + isoUnit.toString();
    }

    private String format(String string, long l) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (i >= n - 2 || string.charAt(i) != '{' || string.charAt(i + 1) != '0' || string.charAt(i + 2) != '}') continue;
            StringBuilder stringBuilder = new StringBuilder(string);
            stringBuilder.replace(i, i + 3, this.format(l));
            return stringBuilder.toString();
        }
        return string;
    }

    private String format(long l) {
        StringBuilder stringBuilder = new StringBuilder();
        String string = String.valueOf(Math.abs(l));
        char c = this.zeroDigit;
        if (this.minusOrientation == 0 && l < 0L) {
            stringBuilder.append(this.minusSign);
        } else if (this.minusOrientation == 1) {
            stringBuilder.append('\u200f');
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (c != '0') {
                c2 = (char)(c2 + c - 48);
            }
            stringBuilder.append(c2);
        }
        if (this.minusOrientation == 1 && l < 0L) {
            stringBuilder.append(this.minusSign);
        }
        return stringBuilder.toString();
    }

    static {
        IsoUnit[] isoUnitArray = new IsoUnit[]{CalendarUnit.YEARS, CalendarUnit.MONTHS, CalendarUnit.WEEKS, CalendarUnit.DAYS, ClockUnit.HOURS, ClockUnit.MINUTES, ClockUnit.SECONDS};
        STD_UNITS = isoUnitArray;
        HashSet<IsoUnit> hashSet = new HashSet<IsoUnit>();
        for (IsoUnit isoUnit : isoUnitArray) {
            hashSet.add(isoUnit);
        }
        hashSet.add(ClockUnit.MILLIS);
        hashSet.add(ClockUnit.MICROS);
        hashSet.add(ClockUnit.NANOS);
        SUPPORTED_UNITS = Collections.unmodifiableSet(hashSet);
    }
}

