/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.io.IOException;
import java.util.Locale;
import net.time4j.Meridiem;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoEntity;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.ParseLog;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;

enum AmPmElement implements TextElement<Meridiem>
{
    AM_PM_OF_DAY;


    @Override
    public Class<Meridiem> getType() {
        return Meridiem.class;
    }

    @Override
    public char getSymbol() {
        return 'a';
    }

    @Override
    public int compare(ChronoEntity<?> chronoEntity, ChronoEntity<?> chronoEntity2) {
        return chronoEntity.get(this).compareTo((Enum)chronoEntity2.get(this));
    }

    @Override
    public Meridiem getDefaultMinimum() {
        return Meridiem.AM;
    }

    @Override
    public Meridiem getDefaultMaximum() {
        return Meridiem.PM;
    }

    @Override
    public boolean isDateElement() {
        return false;
    }

    @Override
    public boolean isTimeElement() {
        return true;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public void print(ChronoEntity<?> chronoEntity, Appendable appendable, AttributeQuery attributeQuery) throws IOException {
        appendable.append(this.accessor(attributeQuery).print(chronoEntity.get(this)));
    }

    @Override
    public Meridiem parse(CharSequence charSequence, ParseLog parseLog, AttributeQuery attributeQuery) {
        return this.accessor(attributeQuery).parse(charSequence, parseLog, this.getType(), attributeQuery);
    }

    private CalendarText.Accessor accessor(AttributeQuery attributeQuery) {
        CalendarText calendarText = CalendarText.getInstance(attributeQuery.get(Attributes.CALENDAR_TYPE, "iso8601"), attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT));
        TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
        return calendarText.getMeridiems(textWidth);
    }
}

