/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.tz.model;

public enum OffsetIndicator {
    UTC_TIME{

        @Override
        public char getSymbol() {
            return 'u';
        }
    }
    ,
    STANDARD_TIME{

        @Override
        public char getSymbol() {
            return 's';
        }
    }
    ,
    WALL_TIME{

        @Override
        public char getSymbol() {
            return 'w';
        }
    };

    static final OffsetIndicator[] VALUES;

    public static OffsetIndicator parseSymbol(char c) {
        switch (c) {
            case 'g': 
            case 'u': 
            case 'z': {
                return UTC_TIME;
            }
            case 's': {
                return STANDARD_TIME;
            }
            case 'w': {
                return WALL_TIME;
            }
        }
        throw new IllegalArgumentException("Unknown offset indicator: " + c);
    }

    public char getSymbol() {
        throw new AbstractMethodError();
    }

    static {
        VALUES = OffsetIndicator.values();
    }
}

