/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.range;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.time4j.AdjustableElement;
import net.time4j.CalendarUnit;
import net.time4j.ClockUnit;
import net.time4j.Duration;
import net.time4j.IsoUnit;
import net.time4j.Moment;
import net.time4j.PlainDate;
import net.time4j.PlainTime;
import net.time4j.PlainTimestamp;
import net.time4j.Weekmodel;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.CalendarDays;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoElement;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimePoint;
import net.time4j.engine.TimeSpan;
import net.time4j.format.Attributes;
import net.time4j.format.expert.ChronoFormatter;
import net.time4j.format.expert.ChronoParser;
import net.time4j.format.expert.ChronoPrinter;
import net.time4j.format.expert.Iso8601Format;
import net.time4j.format.expert.IsoDateStyle;
import net.time4j.format.expert.IsoDecimalStyle;
import net.time4j.format.expert.ParseLog;
import net.time4j.format.expert.SignPolicy;
import net.time4j.range.Boundary;
import net.time4j.range.BracketPolicy;
import net.time4j.range.ChronoInterval;
import net.time4j.range.ClockInterval;
import net.time4j.range.DateInterval;
import net.time4j.range.DayPartitionRule;
import net.time4j.range.FixedNumParser;
import net.time4j.range.InfinityStyle;
import net.time4j.range.IntervalComparator;
import net.time4j.range.IntervalEdge;
import net.time4j.range.IntervalFactory;
import net.time4j.range.IntervalParser;
import net.time4j.range.IsoInterval;
import net.time4j.range.MomentInterval;
import net.time4j.range.SPX;
import net.time4j.range.TimestampIntervalFactory;
import net.time4j.range.YearParser;
import net.time4j.tz.GapResolver;
import net.time4j.tz.OverlapResolver;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;
import net.time4j.tz.ZonalOffset;

public final class TimestampInterval
extends IsoInterval<PlainTimestamp, TimestampInterval>
implements Serializable {
    public static final TimestampInterval ALWAYS = TimestampIntervalFactory.INSTANCE.between(Boundary.infinitePast(), Boundary.infiniteFuture());
    private static final long serialVersionUID = -3965530927182499606L;
    private static final Comparator<ChronoInterval<PlainTimestamp>> COMPARATOR = new IntervalComparator<PlainTimestamp>(PlainTimestamp.axis());
    private static final ChronoPrinter<Integer> NOOP = (n, stringBuilder, attributeQuery) -> Collections.emptySet();

    TimestampInterval(Boundary<PlainTimestamp> boundary, Boundary<PlainTimestamp> boundary2) {
        super(boundary, boundary2);
    }

    public static Comparator<ChronoInterval<PlainTimestamp>> comparator() {
        return COMPARATOR;
    }

    public static TimestampInterval between(PlainTimestamp plainTimestamp, PlainTimestamp plainTimestamp2) {
        return new TimestampInterval(Boundary.of(IntervalEdge.CLOSED, plainTimestamp), Boundary.of(IntervalEdge.OPEN, plainTimestamp2));
    }

    public static TimestampInterval between(LocalDateTime localDateTime, LocalDateTime localDateTime2) {
        return TimestampInterval.between(PlainTimestamp.from(localDateTime), PlainTimestamp.from(localDateTime2));
    }

    public static TimestampInterval since(PlainTimestamp plainTimestamp) {
        Boundary<PlainTimestamp> boundary = Boundary.infiniteFuture();
        return new TimestampInterval(Boundary.of(IntervalEdge.CLOSED, plainTimestamp), boundary);
    }

    public static TimestampInterval since(LocalDateTime localDateTime) {
        return TimestampInterval.since(PlainTimestamp.from(localDateTime));
    }

    public static TimestampInterval until(PlainTimestamp plainTimestamp) {
        Boundary<PlainTimestamp> boundary = Boundary.infinitePast();
        return new TimestampInterval(boundary, Boundary.of(IntervalEdge.OPEN, plainTimestamp));
    }

    public static TimestampInterval until(LocalDateTime localDateTime) {
        return TimestampInterval.until(PlainTimestamp.from(localDateTime));
    }

    public static TimestampInterval from(ChronoInterval<PlainTimestamp> chronoInterval) {
        if (chronoInterval instanceof TimestampInterval) {
            return (TimestampInterval)TimestampInterval.class.cast(chronoInterval);
        }
        return new TimestampInterval(chronoInterval.getStart(), chronoInterval.getEnd());
    }

    public PlainTimestamp getStartAsTimestamp() {
        return (PlainTimestamp)this.getStart().getTemporal();
    }

    public LocalDateTime getStartAsLocalDateTime() {
        PlainTimestamp plainTimestamp = this.getStartAsTimestamp();
        return plainTimestamp == null ? null : plainTimestamp.toTemporalAccessor();
    }

    public PlainTimestamp getEndAsTimestamp() {
        return (PlainTimestamp)this.getEnd().getTemporal();
    }

    public LocalDateTime getEndAsLocalDateTime() {
        PlainTimestamp plainTimestamp = this.getEndAsTimestamp();
        return plainTimestamp == null ? null : plainTimestamp.toTemporalAccessor();
    }

    public MomentInterval atUTC() {
        return this.at(ZonalOffset.UTC);
    }

    public MomentInterval at(ZonalOffset zonalOffset) {
        Boundary<Moment> boundary;
        Moment moment;
        Boundary<Moment> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            moment = ((PlainTimestamp)this.getStart().getTemporal()).at(zonalOffset);
            boundary2 = Boundary.of(this.getStart().getEdge(), moment);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            moment = ((PlainTimestamp)this.getEnd().getTemporal()).at(zonalOffset);
            boundary = Boundary.of(this.getEnd().getEdge(), moment);
        }
        return new MomentInterval(boundary2, boundary);
    }

    public MomentInterval inStdTimezone() {
        return this.in(SystemTimezoneHolder.get());
    }

    public MomentInterval inTimezone(TZID tZID) {
        return this.in(Timezone.of(tZID).with(GapResolver.NEXT_VALID_TIME.and(OverlapResolver.EARLIER_OFFSET)));
    }

    @SafeVarargs
    public final <U extends IsoUnit> Duration<U> getDuration(U ... UArray) {
        boolean bl;
        PlainTimestamp plainTimestamp = (PlainTimestamp)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = plainTimestamp == null;
        if (bl) {
            plainTimestamp = (PlainTimestamp)this.getEnd().getTemporal();
        }
        Duration duration = (Duration)Duration.in(UArray).between((TimePoint)this.getTemporalOfClosedStart(), plainTimestamp);
        if (bl) {
            for (U u : UArray) {
                if (!u.equals(ClockUnit.NANOS)) continue;
                return duration.plus(1L, u);
            }
        }
        return duration;
    }

    public Duration<IsoUnit> getDuration(Timezone timezone, IsoUnit ... isoUnitArray) {
        boolean bl;
        PlainTimestamp plainTimestamp = (PlainTimestamp)this.getTemporalOfOpenEnd();
        boolean bl2 = bl = plainTimestamp == null;
        if (bl) {
            plainTimestamp = (PlainTimestamp)this.getEnd().getTemporal();
        }
        Duration<IsoUnit> duration = Duration.in(timezone, isoUnitArray).between((TimePoint)this.getTemporalOfClosedStart(), plainTimestamp);
        if (bl) {
            for (IsoUnit isoUnit : isoUnitArray) {
                if (!isoUnit.equals(ClockUnit.NANOS)) continue;
                return duration.plus(1L, isoUnit);
            }
        }
        return duration;
    }

    public TimestampInterval move(long l, IsoUnit isoUnit) {
        if (l == 0L) {
            return this;
        }
        Boundary<PlainTimestamp> boundary = this.getStart().isInfinite() ? Boundary.infinitePast() : Boundary.of(this.getStart().getEdge(), ((PlainTimestamp)this.getStart().getTemporal()).plus(l, isoUnit));
        Boundary<PlainTimestamp> boundary2 = this.getEnd().isInfinite() ? Boundary.infiniteFuture() : Boundary.of(this.getEnd().getEdge(), ((PlainTimestamp)this.getEnd().getTemporal()).plus(l, isoUnit));
        return new TimestampInterval(boundary, boundary2);
    }

    public Stream<PlainTimestamp> stream(Duration<?> duration) {
        TimestampInterval timestampInterval = (TimestampInterval)this.toCanonical();
        PlainTimestamp plainTimestamp = timestampInterval.getStartAsTimestamp();
        PlainTimestamp plainTimestamp2 = timestampInterval.getEndAsTimestamp();
        if (plainTimestamp == null || plainTimestamp2 == null) {
            throw new IllegalStateException("Streaming is not supported for infinite intervals.");
        }
        return TimestampInterval.stream(duration, plainTimestamp, plainTimestamp2);
    }

    public static Stream<PlainTimestamp> stream(Duration<?> duration, PlainTimestamp plainTimestamp, PlainTimestamp plainTimestamp2) {
        int n2;
        if (!duration.isPositive()) {
            throw new IllegalArgumentException("Duration must be positive: " + duration);
        }
        int n3 = plainTimestamp.compareTo(plainTimestamp2);
        if (n3 > 0) {
            throw new IllegalArgumentException("Start after end: " + plainTimestamp + "/" + plainTimestamp2);
        }
        if (n3 == 0) {
            return Stream.empty();
        }
        double d = 0.0;
        for (TimeSpan.Item<?> item : duration.getTotalLength()) {
            d += ((IsoUnit)item.getUnit()).getLength() * (double)item.getAmount();
        }
        double d2 = d < 1.0 ? (double)ClockUnit.NANOS.between(plainTimestamp, plainTimestamp2) / (d * 1.0E9) : (double)ClockUnit.SECONDS.between(plainTimestamp, plainTimestamp2) / d;
        if (Double.compare(d2, 2.147483647E9) >= 0) {
            throw new ArithmeticException();
        }
        boolean bl = false;
        for (n2 = (int)Math.floor(d2); n2 > 0 && !((PlainTimestamp)plainTimestamp.plus(duration.multipliedBy(n2))).isBefore(plainTimestamp2); --n2) {
            bl = true;
        }
        int n4 = n2 + 1;
        if (!bl) {
            do {
                n4 = Math.addExact(n2, 1);
            } while (((PlainTimestamp)plainTimestamp.plus(duration.multipliedBy(++n2))).isBefore(plainTimestamp2));
        }
        if (n4 == 1) {
            return Stream.of(plainTimestamp);
        }
        return IntStream.range(0, n4).mapToObj(n -> (PlainTimestamp)plainTimestamp.plus(duration.multipliedBy(n)));
    }

    public Stream<TimestampInterval> streamPartitioned(DayPartitionRule dayPartitionRule) {
        PlainDate plainDate;
        TimestampInterval timestampInterval = (TimestampInterval)this.toCanonical();
        PlainTimestamp plainTimestamp = timestampInterval.getStartAsTimestamp();
        PlainTimestamp plainTimestamp2 = timestampInterval.getEndAsTimestamp();
        if (plainTimestamp == null || plainTimestamp2 == null) {
            throw new IllegalStateException("Streaming is not supported for infinite intervals.");
        }
        PlainDate plainDate2 = plainTimestamp.getCalendarDate();
        long l = CalendarUnit.DAYS.between(plainDate2, plainDate = plainTimestamp2.getCalendarDate());
        if (l == 0L) {
            ClockInterval clockInterval = ClockInterval.between(plainTimestamp.getWallTime(), plainTimestamp2.getWallTime());
            return TimestampInterval.getPartitions(plainDate2, clockInterval, dayPartitionRule).stream();
        }
        ClockInterval clockInterval = ClockInterval.between(plainTimestamp.getWallTime(), PlainTime.midnightAtEndOfDay());
        ClockInterval clockInterval2 = ClockInterval.between(PlainTime.midnightAtStartOfDay(), plainTimestamp2.getWallTime());
        Stream<Object> stream = TimestampInterval.getPartitions(plainDate2, clockInterval, dayPartitionRule).stream();
        Stream stream2 = TimestampInterval.getPartitions(plainDate, clockInterval2, dayPartitionRule).stream();
        if (l > 1L) {
            Stream<TimestampInterval> stream3 = DateInterval.between((PlainDate)plainDate2.plus(CalendarDays.ONE), (PlainDate)plainDate.minus(CalendarDays.ONE)).streamPartitioned(dayPartitionRule);
            stream = Stream.concat(stream, stream3);
        }
        return Stream.concat(stream, stream2);
    }

    public PlainTimestamp random() {
        try {
            MomentInterval momentInterval = ((TimestampInterval)this.toCanonical()).atUTC();
            return momentInterval.random().toZonalTimestamp(ZonalOffset.UTC);
        }
        catch (IllegalStateException illegalStateException) {
            throw new IllegalStateException("Cannot get random timestamp in an empty or infinite interval: " + this, illegalStateException);
        }
    }

    public String formatISO(IsoDateStyle isoDateStyle, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit, InfinityStyle infinityStyle) {
        TimestampInterval timestampInterval = (TimestampInterval)this.toCanonical();
        StringBuilder stringBuilder = new StringBuilder(60);
        ChronoPrinter<PlainTimestamp> chronoPrinter = Iso8601Format.ofTimestamp(isoDateStyle, isoDecimalStyle, clockUnit);
        if (timestampInterval.getStart().isInfinite()) {
            stringBuilder.append(infinityStyle.displayPast(chronoPrinter, PlainTimestamp.axis()));
        } else {
            chronoPrinter.print(timestampInterval.getStartAsTimestamp(), stringBuilder);
        }
        stringBuilder.append('/');
        if (timestampInterval.getEnd().isInfinite()) {
            stringBuilder.append(infinityStyle.displayFuture(chronoPrinter, PlainTimestamp.axis()));
        } else {
            chronoPrinter.print(timestampInterval.getEndAsTimestamp(), stringBuilder);
        }
        return stringBuilder.toString();
    }

    public String formatReduced(IsoDateStyle isoDateStyle, IsoDecimalStyle isoDecimalStyle, ClockUnit clockUnit, InfinityStyle infinityStyle) {
        TimestampInterval timestampInterval = (TimestampInterval)this.toCanonical();
        PlainTimestamp plainTimestamp = timestampInterval.getStartAsTimestamp();
        PlainTimestamp plainTimestamp2 = timestampInterval.getEndAsTimestamp();
        StringBuilder stringBuilder = new StringBuilder(60);
        ChronoPrinter<PlainTime> chronoPrinter = isoDateStyle.isExtended() ? Iso8601Format.ofExtendedTime(isoDecimalStyle, clockUnit) : Iso8601Format.ofBasicTime(isoDecimalStyle, clockUnit);
        ChronoPrinter<PlainTimestamp> chronoPrinter2 = null;
        if (timestampInterval.getStart().isInfinite()) {
            chronoPrinter2 = Iso8601Format.ofTimestamp(isoDateStyle, isoDecimalStyle, clockUnit);
            stringBuilder.append(infinityStyle.displayPast(chronoPrinter2, PlainTimestamp.axis()));
        } else {
            Iso8601Format.ofDate(isoDateStyle).print(plainTimestamp.getCalendarDate(), stringBuilder);
            stringBuilder.append('T');
            chronoPrinter.print(plainTimestamp.getWallTime(), stringBuilder);
        }
        stringBuilder.append('/');
        if (timestampInterval.isFinite()) {
            PlainDate plainDate;
            PlainDate plainDate2 = plainTimestamp.getCalendarDate();
            if (!plainDate2.equals(plainDate = plainTimestamp2.getCalendarDate())) {
                DateInterval.getEndPrinter(isoDateStyle, plainDate2, plainDate).print(plainDate, stringBuilder);
            }
            stringBuilder.append('T');
            chronoPrinter.print(plainTimestamp2.getWallTime(), stringBuilder);
        } else if (timestampInterval.getEnd().isInfinite()) {
            if (chronoPrinter2 == null) {
                chronoPrinter2 = Iso8601Format.ofTimestamp(isoDateStyle, isoDecimalStyle, clockUnit);
            }
            stringBuilder.append(infinityStyle.displayFuture(chronoPrinter2, PlainTimestamp.axis()));
        } else {
            if (chronoPrinter2 == null) {
                chronoPrinter2 = Iso8601Format.ofTimestamp(isoDateStyle, isoDecimalStyle, clockUnit);
            }
            chronoPrinter2.print(plainTimestamp2, stringBuilder);
        }
        return stringBuilder.toString();
    }

    public static TimestampInterval parse(String string, ChronoParser<PlainTimestamp> chronoParser) throws ParseException {
        return TimestampInterval.parse(string, chronoParser, IsoInterval.getIntervalPattern(chronoParser));
    }

    public static TimestampInterval parse(String string, ChronoParser<PlainTimestamp> chronoParser, String string2) throws ParseException {
        return IntervalParser.parsePattern(string, TimestampIntervalFactory.INSTANCE, chronoParser, string2);
    }

    public static TimestampInterval parse(CharSequence charSequence, ChronoParser<PlainTimestamp> chronoParser, BracketPolicy bracketPolicy) throws ParseException {
        ParseLog parseLog = new ParseLog();
        TimestampInterval timestampInterval = (TimestampInterval)IntervalParser.of(TimestampIntervalFactory.INSTANCE, chronoParser, bracketPolicy).parse(charSequence, parseLog, chronoParser.getAttributes());
        if (timestampInterval == null || parseLog.isError()) {
            throw new ParseException(parseLog.getErrorMessage(), parseLog.getErrorIndex());
        }
        if (parseLog.getPosition() < charSequence.length() && !chronoParser.getAttributes().get(Attributes.TRAILING_CHARACTERS, Boolean.FALSE).booleanValue()) {
            throw new ParseException("Trailing characters found: " + charSequence, parseLog.getPosition());
        }
        return timestampInterval;
    }

    public static TimestampInterval parse(CharSequence charSequence, ChronoParser<PlainTimestamp> chronoParser, char c, ChronoParser<PlainTimestamp> chronoParser2, BracketPolicy bracketPolicy, ParseLog parseLog) {
        return (TimestampInterval)IntervalParser.of(TimestampIntervalFactory.INSTANCE, chronoParser, chronoParser2, bracketPolicy, c).parse(charSequence, parseLog, chronoParser.getAttributes());
    }

    public static TimestampInterval parseISO(String string) throws ParseException {
        int n;
        int n2;
        int n3;
        boolean bl;
        if (string.isEmpty()) {
            throw new IndexOutOfBoundsException("Empty text.");
        }
        int n4 = 0;
        int n5 = Math.min(string.length(), 107);
        boolean bl2 = true;
        int n6 = 1;
        int n7 = 0;
        int n8 = 0;
        boolean bl3 = bl = string.charAt(0) == '-';
        if (string.charAt(0) == 'P' || bl) {
            for (n3 = 1; n3 < n5; ++n3) {
                if (string.charAt(n3) != '/') continue;
                if (n3 + 1 == n5) {
                    throw new ParseException("Missing end component.", n5);
                }
                if (bl) {
                    if (string.charAt(1) != '\u221e' && n3 != 1) break;
                    n4 = n3 + 1;
                    break;
                }
                n4 = n3 + 1;
                break;
            }
        }
        n3 = 0;
        int n9 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        boolean bl6 = false;
        boolean bl7 = false;
        int n10 = -1;
        for (n2 = n4 + 1; n2 < n5; ++n2) {
            n = string.charAt(n2);
            if (bl7) {
                if (n == 80 || n == 45 && n2 == n5 - 1 || n == 43 && n2 == n5 - 2 && string.charAt(n2 + 1) == '\u221e') {
                    bl7 = false;
                    break;
                }
                if (n == 84 || n8 > 0) {
                    ++n8;
                    continue;
                }
                if (n == 87) {
                    bl6 = true;
                } else if (n == 45 && n2 > n10 + 1) {
                    ++n9;
                }
                ++n7;
                continue;
            }
            if (n == 47) {
                if (n10 == -1) {
                    n10 = n2;
                    bl7 = true;
                    n8 = 0;
                    continue;
                }
                throw new ParseException("Interval with two slashes found: " + string, n2);
            }
            if (n == 84 || n8 > 0) {
                ++n8;
                continue;
            }
            if (n == 45) {
                ++n6;
                ++n3;
                continue;
            }
            if (n == 87) {
                ++n6;
                bl5 = true;
                continue;
            }
            ++n6;
        }
        if (bl7 && bl5 != bl6) {
            throw new ParseException("Mixed date styles not allowed.", n5);
        }
        n2 = string.charAt(n4);
        n = n6 - 4;
        if (n2 == 43 || n2 == 45) {
            n -= 2;
        }
        if (!bl5) {
            bl4 = n3 == 1 || n3 == 0 && n == 3;
        }
        boolean bl8 = n3 > 0;
        boolean bl9 = true;
        if (bl7) {
            if (n8 == 0) {
                bl9 = false;
                n8 = n7;
                n7 = 0;
            }
            bl2 = n6 == n7 && n3 == n9;
        }
        ChronoFormatter<PlainTimestamp> chronoFormatter = bl8 ? Iso8601Format.EXTENDED_DATE_TIME : Iso8601Format.BASIC_DATE_TIME;
        ChronoFormatter<PlainTimestamp> chronoFormatter2 = bl2 ? chronoFormatter : null;
        Parser parser = new Parser(chronoFormatter, chronoFormatter2, bl8, bl5, bl4, n8, bl9);
        return (TimestampInterval)parser.parse(string);
    }

    MomentInterval in(Timezone timezone) {
        Boundary<Moment> boundary;
        Moment moment;
        Boundary<Moment> boundary2;
        if (this.getStart().isInfinite()) {
            boundary2 = Boundary.infinitePast();
        } else {
            moment = ((PlainTimestamp)this.getStart().getTemporal()).in(timezone);
            boundary2 = Boundary.of(this.getStart().getEdge(), moment);
        }
        if (this.getEnd().isInfinite()) {
            boundary = Boundary.infiniteFuture();
        } else {
            moment = ((PlainTimestamp)this.getEnd().getTemporal()).in(timezone);
            boundary = Boundary.of(this.getEnd().getEdge(), moment);
        }
        return new MomentInterval(boundary2, boundary);
    }

    @Override
    IntervalFactory<PlainTimestamp, TimestampInterval> getFactory() {
        return TimestampIntervalFactory.INSTANCE;
    }

    @Override
    TimestampInterval getContext() {
        return this;
    }

    private static List<TimestampInterval> getPartitions(PlainDate plainDate, ClockInterval clockInterval, DayPartitionRule dayPartitionRule) {
        ArrayList<TimestampInterval> arrayList = new ArrayList<TimestampInterval>();
        TimestampInterval timestampInterval = clockInterval.on(plainDate);
        for (ChronoInterval<PlainTime> chronoInterval : dayPartitionRule.getPartitions(plainDate)) {
            TimestampInterval timestampInterval2 = TimestampInterval.between(plainDate.at(chronoInterval.getStart().getTemporal()), plainDate.at(chronoInterval.getEnd().getTemporal()));
            timestampInterval.findIntersection(timestampInterval2).ifPresent(arrayList::add);
        }
        return arrayList;
    }

    private Object writeReplace() {
        return new SPX(this, 34);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        throw new InvalidObjectException("Serialization proxy required.");
    }

    private static class SystemTimezoneHolder {
        private static final Timezone SYS_TZ = Boolean.getBoolean("net.time4j.allow.system.tz.override") ? null : SystemTimezoneHolder.create();

        private SystemTimezoneHolder() {
        }

        static Timezone get() {
            return SYS_TZ == null ? SystemTimezoneHolder.create() : SYS_TZ;
        }

        private static Timezone create() {
            return Timezone.ofSystem().with(GapResolver.NEXT_VALID_TIME.and(OverlapResolver.EARLIER_OFFSET));
        }
    }

    private static class Parser
    extends IntervalParser<PlainTimestamp, TimestampInterval> {
        private final boolean extended;
        private final boolean weekStyle;
        private final boolean ordinalStyle;
        private final int protectedArea;
        private final boolean hasT;

        Parser(ChronoParser<PlainTimestamp> chronoParser, ChronoParser<PlainTimestamp> chronoParser2, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super(TimestampIntervalFactory.INSTANCE, chronoParser, chronoParser2, BracketPolicy.SHOW_NEVER, Character.valueOf('/'));
            this.extended = bl;
            this.weekStyle = bl2;
            this.ordinalStyle = bl3;
            this.protectedArea = n;
            this.hasT = bl4;
        }

        @Override
        protected PlainTimestamp parseReducedEnd(CharSequence charSequence, PlainTimestamp plainTimestamp, ParseLog parseLog, ParseLog parseLog2, AttributeQuery attributeQuery) {
            ChronoFormatter<PlainTimestamp> chronoFormatter = this.createEndFormat(PlainTimestamp.axis().preformat(plainTimestamp, attributeQuery), parseLog.getRawValues());
            return chronoFormatter.parse(charSequence, parseLog2);
        }

        private ChronoFormatter<PlainTimestamp> createEndFormat(ChronoDisplay chronoDisplay, ChronoEntity<?> chronoEntity) {
            int n;
            AdjustableElement<Integer, PlainDate> adjustableElement;
            ChronoFormatter.Builder<PlainTimestamp> builder = ChronoFormatter.setUp(PlainTimestamp.class, Locale.ROOT);
            AdjustableElement<Integer, PlainDate> adjustableElement2 = adjustableElement = this.weekStyle ? PlainDate.YEAR_OF_WEEKDATE : PlainDate.YEAR;
            if (this.extended) {
                n = (this.ordinalStyle ? 3 : 5) + this.protectedArea;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
                builder.addCustomized(adjustableElement, NOOP, this.weekStyle ? YearParser.YEAR_OF_WEEKDATE : YearParser.YEAR);
            } else {
                n = (this.ordinalStyle ? 3 : 4) + this.protectedArea;
                builder.startSection(Attributes.PROTECTED_CHARACTERS, n);
                builder.addInteger(adjustableElement, 4, 9, SignPolicy.SHOW_WHEN_BIG_NUMBER);
            }
            builder.endSection();
            if (this.weekStyle) {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, 1 + this.protectedArea);
                builder.addCustomized(Weekmodel.ISO.weekOfYear(), NOOP, this.extended ? FixedNumParser.EXTENDED_WEEK_OF_YEAR : FixedNumParser.BASIC_WEEK_OF_YEAR);
                builder.endSection();
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedNumerical(PlainDate.DAY_OF_WEEK, 1);
                builder.endSection();
            } else if (this.ordinalStyle) {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedInteger(PlainDate.DAY_OF_YEAR, 3);
                builder.endSection();
            } else {
                builder.startSection(Attributes.PROTECTED_CHARACTERS, 2 + this.protectedArea);
                if (this.extended) {
                    builder.addCustomized(PlainDate.MONTH_AS_NUMBER, NOOP, FixedNumParser.CALENDAR_MONTH);
                } else {
                    builder.addFixedInteger(PlainDate.MONTH_AS_NUMBER, 2);
                }
                builder.endSection();
                builder.startSection(Attributes.PROTECTED_CHARACTERS, this.protectedArea);
                builder.addFixedInteger(PlainDate.DAY_OF_MONTH, 2);
                builder.endSection();
            }
            if (this.hasT) {
                builder.addLiteral('T');
            }
            builder.addCustomized(PlainTime.COMPONENT, this.extended ? Iso8601Format.EXTENDED_WALL_TIME : Iso8601Format.BASIC_WALL_TIME);
            for (ChronoElement<?> chronoElement : TimestampIntervalFactory.INSTANCE.stdElements(chronoEntity)) {
                Parser.setDefault(builder, chronoElement, chronoDisplay);
            }
            return builder.build();
        }

        private static <V> void setDefault(ChronoFormatter.Builder<PlainTimestamp> builder, ChronoElement<V> chronoElement, ChronoDisplay chronoDisplay) {
            builder.setDefault(chronoElement, chronoDisplay.get(chronoElement));
        }
    }
}

