/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.engine;

import java.io.Serializable;
import net.time4j.base.MathUtils;
import net.time4j.engine.ChronoEntity;
import net.time4j.engine.TimeAxis;
import net.time4j.engine.TimeMetric;
import net.time4j.engine.TimeSpan;

public abstract class TimePoint<U, T extends TimePoint<U, T>>
extends ChronoEntity<T>
implements Comparable<T>,
Serializable {
    @Override
    public abstract int compareTo(T var1);

    public T plus(TimeSpan<? extends U> timeSpan) {
        try {
            return (T)timeSpan.addTo((TimePoint)this.getContext());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Result beyond boundaries of time axis.");
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    public T minus(TimeSpan<? extends U> timeSpan) {
        try {
            return (T)timeSpan.subtractFrom((TimePoint)this.getContext());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Result beyond boundaries of time axis.");
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    public T plus(long l, U u) {
        if (l == 0L) {
            return (T)((TimePoint)this.getContext());
        }
        try {
            return (T)((TimePoint)((TimeAxis)this.getChronology()).getRule(u).addTo(this.getContext(), l));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            ArithmeticException arithmeticException = new ArithmeticException("Result beyond boundaries of time axis.");
            arithmeticException.initCause(illegalArgumentException);
            throw arithmeticException;
        }
    }

    public T minus(long l, U u) {
        return this.plus(MathUtils.safeNegate(l), u);
    }

    public <P> P until(T t, TimeMetric<? extends U, P> timeMetric) {
        return timeMetric.between((TimePoint)this.getContext(), t);
    }

    public long until(T t, U u) {
        return ((TimeAxis)this.getChronology()).getRule(u).between(this.getContext(), t);
    }

    public static <U, T extends TimePoint<U, T>> T min(T t, T t2) {
        return t.compareTo(t2) > 0 ? t2 : t;
    }

    public static <U, T extends TimePoint<U, T>> T max(T t, T t2) {
        return t.compareTo(t2) > 0 ? t : t2;
    }

    public abstract boolean equals(Object var1);

    public abstract int hashCode();

    public abstract String toString();

    protected abstract TimeAxis<U, T> getChronology();
}

