/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar.astro;

import java.util.concurrent.TimeUnit;
import net.time4j.Moment;
import net.time4j.PlainTimestamp;
import net.time4j.base.MathUtils;
import net.time4j.calendar.astro.JulianDay;

public enum MoonPhase {
    NEW_MOON(0),
    FIRST_QUARTER(90),
    FULL_MOON(180),
    LAST_QUARTER(270);

    private static final int[] FACTORS;
    private static final double MEAN_SYNODIC_MONTH = 29.530588861;
    private static final Moment ZERO_REF;
    private static final int[] W_NEW_FULL;
    private static final int[] W_QUARTER;
    private static final int[] X_NEW_FULL;
    private static final int[] X_QUARTER;
    private static final int[] Y_NEW_FULL;
    private static final int[] Y_QUARTER;
    private static final int[] Z_NEW_FULL;
    private static final int[] Z_QUARTER;
    private static final double[] V_NEW;
    private static final double[] V_FULL;
    private static final double[] V_QUARTER;
    private final transient int phase;

    private MoonPhase(int n2) {
        this.phase = n2;
    }

    public Moment after(Moment moment) {
        int n = this.getEstimatedLunations(moment);
        Moment moment2 = this.atLunation(n);
        int n2 = n;
        while (!moment2.isAfter(moment)) {
            moment2 = this.atLunation(++n2);
        }
        if (n2 <= n) {
            Moment moment3;
            while ((moment3 = this.atLunation(--n2)).isAfter(moment)) {
                moment2 = moment3;
            }
        }
        return moment2;
    }

    public Moment atOrAfter(Moment moment) {
        int n = this.getEstimatedLunations(moment);
        Moment moment2 = this.atLunation(n);
        int n2 = n;
        while (moment2.isBefore(moment)) {
            moment2 = this.atLunation(++n2);
        }
        if (n2 <= n) {
            Moment moment3;
            while (!(moment3 = this.atLunation(--n2)).isBefore(moment)) {
                moment2 = moment3;
            }
        }
        return moment2;
    }

    public Moment before(Moment moment) {
        int n = this.getEstimatedLunations(moment);
        Moment moment2 = this.atLunation(n);
        int n2 = n;
        while (!moment2.isBefore(moment)) {
            moment2 = this.atLunation(--n2);
        }
        if (n2 >= n) {
            Moment moment3;
            while (((Moment)moment2.plus(29L, TimeUnit.DAYS)).isBefore(moment) && (moment3 = this.atLunation(++n2)).isBefore(moment)) {
                moment2 = moment3;
            }
        }
        return moment2;
    }

    public static int minLunation() {
        return -49473;
    }

    public static int maxLunation() {
        return 12379;
    }

    public Moment atLunation(int n) {
        double d = (double)n + (double)this.phase / 360.0;
        double d2 = d / 1236.85;
        double d3 = d2 * d2;
        double d4 = 2451550.09766 + 29.530588861 * d + (1.5437E-4 + (-1.5E-7 + 7.3E-10 * d2) * d2) * d3;
        double d5 = 124.7746 - 1.56375588 * d + (0.0020672 + 2.15E-6 * d2) * d3;
        d4 -= 1.7E-4 * Math.sin(Math.toRadians(d5));
        double d6 = 1.0 - (0.002516 + 7.4E-6 * d2) * d2;
        double d7 = 2.5534 + 29.1053567 * d - (1.4E-6 + 1.1E-7 * d2) * d3;
        double d8 = 201.5643 + 385.81693528 * d + (0.0107582 + (1.238E-5 - 5.8E-8 * d2) * d2) * d3;
        double d9 = 160.7108 + 390.67050284 * d + (-0.0016118 + (-2.27E-6 + 1.1E-8 * d2) * d2) * d3;
        d4 += this.periodic24(d6, d7, d8, d9);
        if (this == FIRST_QUARTER) {
            d4 += MoonPhase.corrQuarter(d6, d7, d8, d9);
        } else if (this == LAST_QUARTER) {
            d4 -= MoonPhase.corrQuarter(d6, d7, d8, d9);
        }
        double[] dArray = new double[]{299.77 + 0.107408 * d - 0.009173 * d3, 3.25E-4, 251.88 + 0.016321 * d, 1.65E-4, 251.83 + 26.651886 * d, 1.64E-4, 349.42 + 36.412478 * d, 1.26E-4, 84.66 + 18.206239 * d, 1.1E-4, 141.74 + 53.303771 * d, 6.2E-5, 207.14 + 2.453732 * d, 6.0E-5, 154.84 + 7.30686 * d, 5.6E-5, 34.52 + 27.261239 * d, 4.7E-5, 207.19 + 0.121824 * d, 4.2E-5, 291.34 + 1.844379 * d, 4.0E-5, 161.72 + 24.198154 * d, 3.7E-5, 239.56 + 25.513099 * d, 3.5E-5, 331.55 + 3.592518 * d, 2.3E-5};
        for (int i = 0; i < 28; i += 2) {
            d4 += dArray[i + 1] * Math.sin(Math.toRadians(dArray[i]));
        }
        return (Moment)JulianDay.ofEphemerisTime(d4).toMoment().with(Moment.PRECISION, TimeUnit.SECONDS);
    }

    public static double getIllumination(Moment moment) {
        return MoonPhase.getIllumination(moment, 0);
    }

    public static double getIllumination(Moment moment, int n) {
        double d = JulianDay.ofEphemerisTime(moment).getCenturyJ2000();
        double d2 = 297.8501921 + (445267.1114034 + (-0.0018819 + (1.8319447192361523E-6 + 8.844469995135542E-9 * d) * d) * d) * d;
        double d3 = 357.5291092 + (35999.0502909 + (-1.536E-4 + 4.083299305839118E-8 * d) * d) * d;
        int n2 = FACTORS[n];
        double d4 = 134.9633964 + (477198.8675055 + (0.0087414 + (1.4347408140719379E-5 + 6.797172376291463E-8 * d) * d) * d) * d;
        double d5 = 180.0 - d2 - 6.289 * MoonPhase.sin(d4) + 2.1 * MoonPhase.sin(d3) - 1.274 * MoonPhase.sin(2.0 * d2 - d4) - 0.658 * MoonPhase.sin(2.0 * d2) - 0.214 * MoonPhase.sin(2.0 * d4) - 0.11 * MoonPhase.sin(d2);
        double d6 = (MoonPhase.cos(d5) + 1.0) / 2.0;
        if ((double)n2 - d6 * (double)n2 <= 0.5) {
            return 1.0;
        }
        return Math.floor(d6 * (double)n2) / (double)n2;
    }

    private int getEstimatedLunations(Moment moment) {
        return MathUtils.safeCast(Math.round((double)ZERO_REF.until(moment, TimeUnit.DAYS) / 29.530588861 - (double)this.phase / 360.0));
    }

    private double periodic24(double d, double d2, double d3, double d4) {
        double[] dArray = this == NEW_MOON ? V_NEW : (this == FULL_MOON ? V_FULL : V_QUARTER);
        int[] nArray = this == NEW_MOON || this == FULL_MOON ? W_NEW_FULL : W_QUARTER;
        int[] nArray2 = this == NEW_MOON || this == FULL_MOON ? X_NEW_FULL : X_QUARTER;
        int[] nArray3 = this == NEW_MOON || this == FULL_MOON ? Y_NEW_FULL : Y_QUARTER;
        int[] nArray4 = this == NEW_MOON || this == FULL_MOON ? Z_NEW_FULL : Z_QUARTER;
        double d5 = 0.0;
        for (int i = 23; i >= 0; --i) {
            double d6 = dArray[i];
            if (nArray[i] == 1) {
                d6 *= d;
            } else if (nArray[i] == 2) {
                d6 = d6 * d * d;
            }
            d5 += (d6 *= MoonPhase.sin((double)nArray2[i] * d2 + (double)nArray3[i] * d3 + (double)nArray4[i] * d4));
        }
        return d5;
    }

    private static double corrQuarter(double d, double d2, double d3, double d4) {
        return 0.00306 - 3.8E-4 * d * MoonPhase.cos(d2) + 2.6E-4 * MoonPhase.cos(d3) - 2.0E-5 * MoonPhase.cos(d3 - d2) + 2.0E-5 * MoonPhase.cos(d3 + d2) + 2.0E-5 * MoonPhase.cos(2.0 * d4);
    }

    private static double sin(double d) {
        return Math.sin(d * Math.PI / 180.0);
    }

    private static double cos(double d) {
        return Math.cos(d * Math.PI / 180.0);
    }

    static {
        FACTORS = new int[]{100, 1000, 10000, 100000};
        ZERO_REF = PlainTimestamp.of(2000, 1, 6, 18, 13, 42).atUTC();
        W_NEW_FULL = new int[]{0, 1, 0, 0, 1, 1, 2, 0, 0, 1, 0, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        W_QUARTER = new int[]{0, 1, 1, 0, 0, 1, 2, 0, 0, 0, 1, 1, 1, 2, 1, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        X_NEW_FULL = new int[]{0, 1, 0, 0, -1, 1, 2, 0, 0, 1, 0, 1, 1, -1, 2, 0, 3, 1, 0, 1, -1, -1, 1, 0};
        X_QUARTER = new int[]{0, 1, 1, 0, 0, -1, 2, 0, 0, 0, -1, 1, 1, 2, 1, -1, 0, 1, -2, 1, 3, 0, -1, 1};
        Y_NEW_FULL = new int[]{1, 0, 2, 0, 1, 1, 0, 1, 1, 2, 3, 0, 0, 2, 1, 2, 0, 1, 2, 1, 1, 1, 3, 4};
        Y_QUARTER = new int[]{1, 0, 1, 2, 0, 1, 0, 1, 1, 3, 2, 0, 0, 1, 2, 1, 2, 1, 1, 1, 0, 2, 1, 3};
        Z_NEW_FULL = new int[]{0, 0, 0, 2, 0, 0, 0, -2, 2, 0, 0, 2, -2, 0, 0, -2, 0, -2, 2, 2, 2, -2, 0, 0};
        Z_QUARTER = new int[]{0, 0, 0, 0, 2, 0, 0, -2, 2, 0, 0, 2, -2, 0, 0, -2, 2, 2, 0, -2, 0, -2, 2, 0};
        V_NEW = new double[]{-0.4072, 0.17241, 0.01608, 0.01039, 0.00739, -0.00514, 0.00208, -0.00111, -5.7E-4, 5.6E-4, -4.2E-4, 4.2E-4, 3.8E-4, -2.4E-4, -7.0E-5, 4.0E-5, 4.0E-5, 3.0E-5, 3.0E-5, -3.0E-5, 3.0E-5, -2.0E-5, -2.0E-5, 2.0E-5};
        V_FULL = new double[]{-0.40614, 0.17302, 0.01614, 0.01043, 0.00734, -0.00515, 0.00209, -0.00111, -5.7E-4, 5.6E-4, -4.2E-4, 4.2E-4, 3.8E-4, -2.4E-4, -7.0E-5, 4.0E-5, 4.0E-5, 3.0E-5, 3.0E-5, -3.0E-5, 3.0E-5, -2.0E-5, -2.0E-5, 2.0E-5};
        V_QUARTER = new double[]{-0.62801, 0.17172, -0.01183, 0.00862, 0.00804, 0.00454, 0.00204, -0.0018, -7.0E-4, -4.0E-4, -3.4E-4, 3.2E-4, 3.2E-4, -2.8E-4, 2.7E-4, -5.0E-5, 4.0E-5, -4.0E-5, 4.0E-5, 3.0E-5, 3.0E-5, 2.0E-5, 2.0E-5, -2.0E-5};
    }
}

