/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.util.Locale;
import net.time4j.calendar.PersianCalendar;
import net.time4j.engine.ChronoCondition;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum PersianMonth implements ChronoCondition<PersianCalendar>
{
    FARVARDIN,
    ORDIBEHESHT,
    KHORDAD,
    TIR,
    MORDAD,
    SHAHRIVAR,
    MEHR,
    ABAN,
    AZAR,
    DEY,
    BAHMAN,
    ESFAND;

    private static final PersianMonth[] ENUMS;

    public static PersianMonth valueOf(int n) {
        if (n < 1 || n > 12) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return ENUMS[n - 1];
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        CalendarText calendarText = CalendarText.getInstance("persian", locale);
        return calendarText.getStdMonths(textWidth, outputContext).print(this);
    }

    @Override
    public boolean test(PersianCalendar persianCalendar) {
        return persianCalendar.getMonth() == this;
    }

    static {
        ENUMS = PersianMonth.values();
    }
}

