/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.calendar;

import java.io.IOException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.text.ParsePosition;
import java.util.Locale;
import java.util.Map;
import net.time4j.Month;
import net.time4j.calendar.EastAsianMonth;
import net.time4j.engine.AttributeQuery;
import net.time4j.engine.ChronoDisplay;
import net.time4j.engine.ChronoException;
import net.time4j.format.Attributes;
import net.time4j.format.CalendarText;
import net.time4j.format.NumberSystem;
import net.time4j.format.OutputContext;
import net.time4j.format.TextAccessor;
import net.time4j.format.TextElement;
import net.time4j.format.TextWidth;
import net.time4j.format.internal.DualFormatElement;

class EastAsianME
implements TextElement<EastAsianMonth>,
Serializable {
    static final EastAsianME SINGLETON_EA = new EastAsianME();
    private static final long serialVersionUID = -5874268477318061153L;

    EastAsianME() {
    }

    @Override
    public String name() {
        return "MONTH_OF_YEAR";
    }

    @Override
    public Class<EastAsianMonth> getType() {
        return EastAsianMonth.class;
    }

    @Override
    public char getSymbol() {
        return 'M';
    }

    @Override
    public int compare(ChronoDisplay chronoDisplay, ChronoDisplay chronoDisplay2) {
        return chronoDisplay.get(this).compareTo(chronoDisplay2.get(this));
    }

    @Override
    public EastAsianMonth getDefaultMinimum() {
        return EastAsianMonth.valueOf(1);
    }

    @Override
    public EastAsianMonth getDefaultMaximum() {
        return EastAsianMonth.valueOf(12);
    }

    @Override
    public boolean isDateElement() {
        return true;
    }

    @Override
    public boolean isTimeElement() {
        return false;
    }

    @Override
    public boolean isLenient() {
        return false;
    }

    @Override
    public String getDisplayName(Locale locale) {
        String string = "L_month";
        String string2 = CalendarText.getIsoInstance(locale).getTextForms().get(string);
        return string2 == null ? this.name() : string2;
    }

    protected Object readResolve() throws ObjectStreamException {
        return SINGLETON_EA;
    }

    @Override
    public void print(ChronoDisplay chronoDisplay, Appendable appendable, AttributeQuery attributeQuery) throws IOException, ChronoException {
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        EastAsianMonth eastAsianMonth = chronoDisplay.get(this);
        if (attributeQuery.contains(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS)) {
            NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            appendable.append(eastAsianMonth.getDisplayName(locale, numberSystem, attributeQuery));
        } else {
            TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
            TextAccessor textAccessor = eastAsianMonth.isLeap() ? CalendarText.getInstance("chinese", locale).getLeapMonths(textWidth, outputContext) : CalendarText.getInstance("chinese", locale).getStdMonths(textWidth, outputContext);
            appendable.append(textAccessor.print(Month.valueOf(eastAsianMonth.getNumber())));
        }
    }

    @Override
    public EastAsianMonth parse(CharSequence charSequence, ParsePosition parsePosition, AttributeQuery attributeQuery) {
        EastAsianMonth eastAsianMonth;
        Locale locale = attributeQuery.get(Attributes.LANGUAGE, Locale.ROOT);
        int n = charSequence.length();
        int n2 = parsePosition.getIndex();
        if (n2 >= n) {
            parsePosition.setErrorIndex(n);
            return null;
        }
        boolean bl = false;
        if (attributeQuery.contains(DualFormatElement.COUNT_OF_PATTERN_SYMBOLS)) {
            Map<String, String> map = CalendarText.getInstance("generic", locale).getTextForms();
            NumberSystem numberSystem = attributeQuery.get(Attributes.NUMBER_SYSTEM, NumberSystem.ARABIC);
            int n3 = n2;
            char c = attributeQuery.get(Attributes.ZERO_DIGIT, Character.valueOf(numberSystem.getDigits().charAt(0))).charValue();
            boolean bl2 = attributeQuery.get(EastAsianMonth.LEAP_MONTH_IS_TRAILING, "R".equals(map.get("leap-alignment")));
            char c2 = attributeQuery.get(EastAsianMonth.LEAP_MONTH_INDICATOR, Character.valueOf(map.get("leap-indicator").charAt(0))).charValue();
            if (!bl2 && charSequence.charAt(n3) == c2) {
                ++n3;
                bl = true;
            }
            if (numberSystem.isDecimal()) {
                while (n3 < n && charSequence.charAt(n3) == c) {
                    ++n3;
                }
            }
            int n4 = 0;
            block1: for (int i = 12; i >= 1 && n4 == 0; --i) {
                String string = EastAsianMonth.toNumeral(numberSystem, c, i);
                int n5 = string.length();
                int n6 = 0;
                while (n <= n3 + n6 || charSequence.charAt(n3 + n6) == string.charAt(n6)) {
                    if (n6 + 1 == n5) {
                        n4 = i;
                        n3 += n5;
                        continue block1;
                    }
                    ++n6;
                }
            }
            if (n4 == 0) {
                parsePosition.setErrorIndex(n2);
                return null;
            }
            if (bl2 && n > n3 && charSequence.charAt(n3) == c2) {
                ++n3;
                bl = true;
            }
            eastAsianMonth = EastAsianMonth.valueOf(n4);
            parsePosition.setIndex(n3);
        } else {
            TextWidth textWidth = attributeQuery.get(Attributes.TEXT_WIDTH, TextWidth.WIDE);
            OutputContext outputContext = attributeQuery.get(Attributes.OUTPUT_CONTEXT, OutputContext.FORMAT);
            TextAccessor textAccessor = CalendarText.getInstance("chinese", locale).getStdMonths(textWidth, outputContext);
            Month month = textAccessor.parse(charSequence, parsePosition, Month.class, attributeQuery);
            if (month == null) {
                parsePosition.setErrorIndex(-1);
                parsePosition.setIndex(n2);
                TextAccessor textAccessor2 = CalendarText.getInstance("chinese", locale).getLeapMonths(textWidth, outputContext);
                month = textAccessor2.parse(charSequence, parsePosition, Month.class, attributeQuery);
                if (month != null) {
                    bl = true;
                }
            }
            if (month == null) {
                parsePosition.setErrorIndex(n2);
                return null;
            }
            eastAsianMonth = EastAsianMonth.valueOf(month.getValue());
        }
        if (bl) {
            eastAsianMonth = eastAsianMonth.withLeap();
        }
        return eastAsianMonth;
    }
}

