/*
 * Decompiled with CFR 0.152.
 */
package net.time4j;

import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import net.time4j.PlainDate;
import net.time4j.base.GregorianDate;
import net.time4j.engine.ChronoCondition;
import net.time4j.engine.ChronoOperator;
import net.time4j.format.CalendarText;
import net.time4j.format.OutputContext;
import net.time4j.format.TextWidth;

public enum Quarter implements ChronoCondition<GregorianDate>,
ChronoOperator<PlainDate>
{
    Q1,
    Q2,
    Q3,
    Q4;

    private static final Quarter[] ENUMS;

    public static Quarter valueOf(int n) {
        if (n < 1 || n > 4) {
            throw new IllegalArgumentException("Out of range: " + n);
        }
        return ENUMS[n - 1];
    }

    public int getValue() {
        return this.ordinal() + 1;
    }

    public Quarter next() {
        return this.roll(1);
    }

    public Quarter previous() {
        return this.roll(-1);
    }

    public Quarter roll(int n) {
        return Quarter.valueOf((this.ordinal() + (n % 4 + 4)) % 4 + 1);
    }

    public String getDisplayName(Locale locale) {
        return this.getDisplayName(locale, TextWidth.WIDE, OutputContext.FORMAT);
    }

    public String getDisplayName(Locale locale, TextWidth textWidth, OutputContext outputContext) {
        return CalendarText.getIsoInstance(locale).getQuarters(textWidth, outputContext).print(this);
    }

    public static Quarter parse(CharSequence charSequence, Locale locale, TextWidth textWidth, OutputContext outputContext) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Quarter quarter = CalendarText.getIsoInstance(locale).getQuarters(textWidth, outputContext).parse(charSequence, parsePosition, Quarter.class);
        if (quarter == null) {
            throw new ParseException("Cannot parse: " + charSequence, parsePosition.getErrorIndex());
        }
        return quarter;
    }

    @Override
    public boolean test(GregorianDate gregorianDate) {
        int n = gregorianDate.getMonth();
        return this.getValue() == (n - 1) / 3 + 1;
    }

    @Override
    public PlainDate apply(PlainDate plainDate) {
        return (PlainDate)plainDate.with(PlainDate.QUARTER_OF_YEAR, this);
    }

    static {
        ENUMS = Quarter.values();
    }
}

