/*
 * Decompiled with CFR 0.152.
 */
package net.time4j.android;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.util.Log;
import java.util.concurrent.atomic.AtomicBoolean;
import net.time4j.tz.TZID;
import net.time4j.tz.Timezone;

public class ApplicationStarter {
    private static final AtomicBoolean REGISTERED = new AtomicBoolean(false);

    private ApplicationStarter() {
    }

    public static void registerReceiver(Context context) {
        if (REGISTERED.compareAndSet(false, true)) {
            context.getApplicationContext().registerReceiver((BroadcastReceiver)new TimezoneChangedReceiver(), new IntentFilter("android.intent.action.TIMEZONE_CHANGED"));
        }
    }

    private static class TimezoneChangedReceiver
    extends BroadcastReceiver {
        private TimezoneChangedReceiver() {
        }

        public void onReceive(Context context, Intent intent) {
            String string = intent.getStringExtra("time-zone");
            try {
                TZID tZID = Timezone.of((String)string).getID();
                Timezone.Cache.refresh();
                Log.i((String)"time4j-android", (String)("Event ACTION_TIMEZONE_CHANGED received, system timezone changed to: [" + tZID.canonical() + "]. Changed android timezone was: [" + string + "]"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Log.e((String)"time4j-android", (String)("Could not recognize timezone id: [" + string + "]"), (Throwable)illegalArgumentException);
            }
        }
    }
}

