/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.javaflow.api;

import java.io.Serializable;
import org.apache.commons.javaflow.core.ReflectionUtils;
import org.apache.commons.javaflow.core.ResumeParameter;
import org.apache.commons.javaflow.core.StackRecorder;
import org.apache.commons.javaflow.core.SuspendResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Continuation
implements Serializable {
    private static final Logger log = LoggerFactory.getLogger(Continuation.class);
    private static final long serialVersionUID = 3L;
    private final Object value;
    final StackRecorder stackRecorder;

    Continuation(StackRecorder stackRecorder, Object value) {
        this.stackRecorder = stackRecorder;
        this.value = value;
    }

    public static Object getContext() {
        return StackRecorder.get().getContext();
    }

    public static Continuation startSuspendedWith(Runnable target) {
        return Continuation.startSuspendedWith(target, false);
    }

    public static Continuation startSuspendedWith(Runnable target, boolean singleShot) {
        if (target == null) {
            throw new IllegalArgumentException("target is null");
        }
        StackRecorder stackRecorder = new StackRecorder(target);
        return singleShot ? new SingleShotContinuation(stackRecorder, null) : new MultiShotContinuation(stackRecorder, null);
    }

    public static Continuation startWith(Runnable target) {
        return Continuation.startWith(target, false);
    }

    public static Continuation startWith(Runnable target, boolean singleShot) {
        return Continuation.startWith(target, null, singleShot);
    }

    public static Continuation startWith(Runnable target, Object context) {
        return Continuation.startWith(target, context, false);
    }

    public static Continuation startWith(Runnable target, Object context, boolean singleShot) {
        if (log.isDebugEnabled()) {
            log.debug("starting new flow from " + ReflectionUtils.descriptionOfObject(target));
        }
        return Continuation.startSuspendedWith(target, singleShot).resume(context);
    }

    public static Continuation continueWith(Continuation continuation) {
        return Continuation.continueWith(continuation, null);
    }

    public static Continuation continueWith(Continuation continuation, Object value) {
        if (continuation == null) {
            throw new IllegalArgumentException("continuation parameter must not be null.");
        }
        return continuation.resume(value);
    }

    public Continuation resume() {
        return this.resume(null);
    }

    public Continuation resume(Object value) {
        return this.resumeWith(ResumeParameter.value(value));
    }

    public void terminate() {
        this.resumeWith(ResumeParameter.exit());
    }

    public boolean isSerializable() {
        return this.stackRecorder.isSerializable();
    }

    public Object value() {
        return this.value;
    }

    public abstract Continuation multiShot();

    public abstract Continuation singleShot();

    public static Object suspend() {
        return Continuation.suspend(null);
    }

    public static Object suspend(Object value) {
        return StackRecorder.suspend(SuspendResult.valueOf(value));
    }

    public static void exit() {
        StackRecorder.exit();
    }

    public static void again() {
        StackRecorder.suspend(SuspendResult.AGAIN);
    }

    public static void cancel() {
        StackRecorder.suspend(SuspendResult.CANCEL);
    }

    public String toString() {
        return "Continuation@" + this.hashCode() + "/" + ReflectionUtils.getClassLoaderName(this);
    }

    protected abstract Continuation resumeWith(ResumeParameter var1);

    static final class SingleShotContinuation
    extends Continuation {
        private static final long serialVersionUID = 1L;
        private boolean isResumed = false;

        SingleShotContinuation(StackRecorder stackRecorder, Object value) {
            super(stackRecorder, value);
        }

        @Override
        public Continuation multiShot() {
            if (this.isResumed) {
                throw new IllegalStateException("Single-shot continuation may not be converted to multi-shot after resume");
            }
            return new MultiShotContinuation(new StackRecorder(this.stackRecorder), this.value());
        }

        @Override
        public Continuation singleShot() {
            return this;
        }

        @Override
        protected Continuation resumeWith(ResumeParameter param) {
            if (log.isDebugEnabled()) {
                log.debug("continueing with continuation " + ReflectionUtils.descriptionOfObject(this));
            }
            if (this.isResumed) {
                if (param == ResumeParameter.exit()) {
                    return null;
                }
                throw new IllegalStateException("Single-shot continuation may be resumed only once");
            }
            this.isResumed = true;
            StackRecorder nextStackRecorder = this.stackRecorder;
            SuspendResult result = nextStackRecorder.execute(param);
            if (SuspendResult.EXIT == result) {
                return null;
            }
            if (SuspendResult.CANCEL == result) {
                return null;
            }
            if (SuspendResult.AGAIN == result) {
                throw new IllegalStateException("Single-shot continuation may not be re-tried");
            }
            return new SingleShotContinuation(nextStackRecorder, result.value());
        }
    }

    static final class MultiShotContinuation
    extends Continuation {
        private static final long serialVersionUID = 1L;

        MultiShotContinuation(StackRecorder stackRecorder, Object value) {
            super(stackRecorder, value);
        }

        @Override
        public Continuation multiShot() {
            return this;
        }

        @Override
        public Continuation singleShot() {
            return new SingleShotContinuation(new StackRecorder(this.stackRecorder), this.value());
        }

        @Override
        protected Continuation resumeWith(ResumeParameter param) {
            StackRecorder nextStackRecorder;
            SuspendResult result;
            if (log.isDebugEnabled()) {
                log.debug("continueing with continuation " + ReflectionUtils.descriptionOfObject(this));
            }
            do {
                if (SuspendResult.EXIT == (result = (nextStackRecorder = new StackRecorder(this.stackRecorder)).execute(param))) {
                    return null;
                }
                if (SuspendResult.CANCEL != result) continue;
                return this;
            } while (SuspendResult.AGAIN == result);
            return new MultiShotContinuation(nextStackRecorder, result.value());
        }
    }
}

