/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.vm.rule.basic;

import net.sourceforge.pmd.PropertyDescriptor;
import net.sourceforge.pmd.lang.rule.properties.IntegerProperty;
import net.sourceforge.pmd.lang.vm.ast.ASTElseIfStatement;
import net.sourceforge.pmd.lang.vm.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.vm.ast.ASTprocess;
import net.sourceforge.pmd.lang.vm.ast.AbstractVmNode;
import net.sourceforge.pmd.lang.vm.rule.AbstractVmRule;

public class AvoidDeeplyNestedIfStmtsRule
extends AbstractVmRule {
    private int depth;
    private int depthLimit;
    private static final IntegerProperty PROBLEM_DEPTH_DESCRIPTOR = new IntegerProperty("problemDepth", "The if statement depth reporting threshold", Integer.valueOf(1), Integer.valueOf(25), Integer.valueOf(3), 1.0f);

    public AvoidDeeplyNestedIfStmtsRule() {
        this.definePropertyDescriptor((PropertyDescriptor)PROBLEM_DEPTH_DESCRIPTOR);
    }

    @Override
    public Object visit(ASTprocess node, Object data) {
        this.depth = 0;
        this.depthLimit = (Integer)this.getProperty((PropertyDescriptor)PROBLEM_DEPTH_DESCRIPTOR);
        return super.visit(node, data);
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        return this.handleIf(node, data);
    }

    @Override
    public Object visit(ASTElseIfStatement node, Object data) {
        return this.handleIf(node, data);
    }

    private Object handleIf(AbstractVmNode node, Object data) {
        ++this.depth;
        super.visit(node, data);
        if (this.depth == this.depthLimit) {
            this.addViolation(data, node);
        }
        --this.depth;
        return data;
    }
}

