/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.plsql.rule.design;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.plsql.ast.ASTCaseStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTCaseWhenClause;
import net.sourceforge.pmd.lang.plsql.ast.ASTConditionalAndExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTConditionalOrExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTElseClause;
import net.sourceforge.pmd.lang.plsql.ast.ASTElsifClause;
import net.sourceforge.pmd.lang.plsql.ast.ASTExpression;
import net.sourceforge.pmd.lang.plsql.ast.ASTForStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTIfStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTLoopStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.plsql.ast.ASTProgramUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTReturnStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTStatement;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerTimingPointSection;
import net.sourceforge.pmd.lang.plsql.ast.ASTTriggerUnit;
import net.sourceforge.pmd.lang.plsql.ast.ASTTypeMethod;
import net.sourceforge.pmd.lang.plsql.ast.ASTWhileStatement;
import net.sourceforge.pmd.lang.plsql.ast.AbstractPLSQLNode;
import net.sourceforge.pmd.lang.plsql.ast.ExecutableCode;
import net.sourceforge.pmd.lang.plsql.ast.PLSQLNode;
import net.sourceforge.pmd.lang.plsql.rule.AbstractStatisticalPLSQLRule;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.util.NumericConstants;

public class NPathComplexityRule
extends AbstractStatisticalPLSQLRule {
    private static final String CLASS_NAME = NPathComplexityRule.class.getCanonicalName();
    private static final Logger LOGGER = Logger.getLogger(NPathComplexityRule.class.getName());

    public NPathComplexityRule() {
        this.setProperty((PropertyDescriptor)MINIMUM_DESCRIPTOR, 200.0);
    }

    private int complexityMultipleOf(PLSQLNode node, int npathStart, Object data) {
        LOGGER.entering(CLASS_NAME, "complexityMultipleOf(SimpleNode)");
        int npath = npathStart;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            PLSQLNode n = (PLSQLNode)node.jjtGetChild(i);
            npath *= ((Integer)n.jjtAccept(this, data)).intValue();
        }
        LOGGER.exiting(CLASS_NAME, "complexityMultipleOf(SimpleNode)", npath);
        return npath;
    }

    @Override
    public Object visit(ASTMethodDeclaration node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTMethodDeclaration)");
        int npath = this.complexityMultipleOf(node, 1, data);
        DataPoint point = new DataPoint();
        point.setNode((Node)node);
        point.setScore(1.0 * (double)npath);
        point.setMessage(this.getMessage());
        this.addDataPoint(point);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("NPath complexity:  " + npath + " for line " + node.getBeginLine() + ", column " + node.getBeginColumn());
        }
        LOGGER.exiting(CLASS_NAME, "visit(ASTMethodDeclaration)", npath);
        return npath;
    }

    @Override
    public Object visit(ASTProgramUnit node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTProgramUnit)");
        int npath = this.complexityMultipleOf(node, 1, data);
        DataPoint point = new DataPoint();
        point.setNode((Node)node);
        point.setScore(1.0 * (double)npath);
        point.setMessage(this.getMessage());
        this.addDataPoint(point);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("NPath complexity:  " + npath + " for line " + node.getBeginLine() + ", column " + node.getBeginColumn());
        }
        LOGGER.exiting(CLASS_NAME, "visit(ASTProgramUnit)", npath);
        return npath;
    }

    @Override
    public Object visit(ASTTypeMethod node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTTypeMethod)");
        int npath = this.complexityMultipleOf(node, 1, data);
        DataPoint point = new DataPoint();
        point.setNode((Node)node);
        point.setScore(1.0 * (double)npath);
        point.setMessage(this.getMessage());
        this.addDataPoint(point);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("NPath complexity:  " + npath + " for line " + node.getBeginLine() + ", column " + node.getBeginColumn());
        }
        LOGGER.exiting(CLASS_NAME, "visit(ASTTypeMethod)", npath);
        return npath;
    }

    @Override
    public Object visit(ASTTriggerUnit node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTTriggerUnit)");
        int npath = this.complexityMultipleOf(node, 1, data);
        DataPoint point = new DataPoint();
        point.setNode((Node)node);
        point.setScore(1.0 * (double)npath);
        point.setMessage(this.getMessage());
        this.addDataPoint(point);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("NPath complexity:  " + npath + " for line " + node.getBeginLine() + ", column " + node.getBeginColumn());
        }
        LOGGER.exiting(CLASS_NAME, "visit(ASTTriggerUnit)", npath);
        return npath;
    }

    @Override
    public Object visit(ASTTriggerTimingPointSection node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTTriggerTimingPointSection)");
        int npath = this.complexityMultipleOf(node, 1, data);
        DataPoint point = new DataPoint();
        point.setNode((Node)node);
        point.setScore(1.0 * (double)npath);
        point.setMessage(this.getMessage());
        this.addDataPoint(point);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("NPath complexity:  " + npath + " for line " + node.getBeginLine() + ", column " + node.getBeginColumn());
        }
        LOGGER.exiting(CLASS_NAME, "visit(ASTTriggerTimingPointSection)", npath);
        return npath;
    }

    @Override
    public Object visit(PLSQLNode node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(SimpleNode)");
        int npath = this.complexityMultipleOf(node, 1, data);
        LOGGER.exiting(CLASS_NAME, "visit(SimpleNode)", npath);
        return npath;
    }

    @Override
    public Object visit(ASTIfStatement node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTIfStatement)");
        int boolCompIf = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        int complexity = 0;
        ArrayList<PLSQLNode> statementChildren = new ArrayList<PLSQLNode>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i).getClass() != ASTStatement.class && node.jjtGetChild(i).getClass() != ASTElsifClause.class && node.jjtGetChild(i).getClass() != ASTElseClause.class) continue;
            statementChildren.add((PLSQLNode)node.jjtGetChild(i));
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(statementChildren.size() + " statementChildren found for IF statement " + node.getBeginLine() + ", column " + node.getBeginColumn());
        }
        for (PLSQLNode element : statementChildren) {
            complexity += ((Integer)element.jjtAccept(this, data)).intValue();
        }
        LOGGER.exiting(CLASS_NAME, "visit(ASTIfStatement)", boolCompIf + complexity);
        return boolCompIf + complexity;
    }

    @Override
    public Object visit(ASTElsifClause node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTElsifClause)");
        int boolCompIf = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        int complexity = 0;
        ArrayList<PLSQLNode> statementChildren = new ArrayList<PLSQLNode>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i).getClass() != ASTStatement.class) continue;
            statementChildren.add((PLSQLNode)node.jjtGetChild(i));
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(statementChildren.size() + " statementChildren found for ELSIF statement " + node.getBeginLine() + ", column " + node.getBeginColumn());
        }
        for (PLSQLNode element : statementChildren) {
            complexity += ((Integer)element.jjtAccept(this, data)).intValue();
        }
        LOGGER.exiting(CLASS_NAME, "visit(ASTElsifClause)", boolCompIf + complexity);
        return boolCompIf + complexity;
    }

    @Override
    public Object visit(ASTElseClause node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTElseClause)");
        int complexity = 0;
        ArrayList<PLSQLNode> statementChildren = new ArrayList<PLSQLNode>();
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            if (node.jjtGetChild(i).getClass() != ASTStatement.class) continue;
            statementChildren.add((PLSQLNode)node.jjtGetChild(i));
        }
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(statementChildren.size() + " statementChildren found for ELSE clause statement " + node.getBeginLine() + ", column " + node.getBeginColumn());
        }
        for (PLSQLNode element : statementChildren) {
            complexity += ((Integer)element.jjtAccept(this, data)).intValue();
        }
        LOGGER.exiting(CLASS_NAME, "visit(ASTElseClause)", complexity);
        return complexity;
    }

    @Override
    public Object visit(ASTWhileStatement node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTWhileStatement)");
        int boolCompWhile = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        Integer nPathWhile = (Integer)((PLSQLNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        LOGGER.exiting(CLASS_NAME, "visit(ASTWhileStatement)", boolCompWhile + nPathWhile + 1);
        return boolCompWhile + nPathWhile + 1;
    }

    @Override
    public Object visit(ASTLoopStatement node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTLoopStatement)");
        int boolCompDo = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        Integer nPathDo = (Integer)((PLSQLNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        LOGGER.exiting(CLASS_NAME, "visit(ASTLoopStatement)", boolCompDo + nPathDo + 1);
        return boolCompDo + nPathDo + 1;
    }

    @Override
    public Object visit(ASTForStatement node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTForStatement)");
        int boolCompFor = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstDescendantOfType(ASTExpression.class));
        Integer nPathFor = (Integer)((PLSQLNode)node.getFirstChildOfType(ASTStatement.class)).jjtAccept(this, data);
        LOGGER.exiting(CLASS_NAME, "visit(ASTForStatement)", boolCompFor + nPathFor + 1);
        return boolCompFor + nPathFor + 1;
    }

    @Override
    public Object visit(ASTReturnStatement node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTReturnStatement)");
        ASTExpression expr = (ASTExpression)node.getFirstChildOfType(ASTExpression.class);
        if (expr == null) {
            return NumericConstants.ONE;
        }
        int boolCompReturn = NPathComplexityRule.sumExpressionComplexity(expr);
        int conditionalExpressionComplexity = this.complexityMultipleOf(expr, 1, data);
        if (conditionalExpressionComplexity > 1) {
            boolCompReturn += conditionalExpressionComplexity;
        }
        if (boolCompReturn > 0) {
            return boolCompReturn;
        }
        LOGGER.entering(CLASS_NAME, "visit(ASTReturnStatement)", NumericConstants.ONE);
        return NumericConstants.ONE;
    }

    @Override
    public Object visit(ASTCaseWhenClause node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTCaseWhenClause)");
        int boolCompSwitch = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        int npath = 1;
        int caseRange = 0;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            PLSQLNode n = (PLSQLNode)node.jjtGetChild(i);
            Integer complexity = (Integer)n.jjtAccept(this, data);
            caseRange *= complexity.intValue();
        }
        LOGGER.exiting(CLASS_NAME, "visit(ASTCaseWhenClause)", boolCompSwitch + (npath += caseRange));
        return boolCompSwitch + npath;
    }

    @Override
    public Object visit(ASTCaseStatement node, Object data) {
        LOGGER.entering(CLASS_NAME, "visit(ASTCaseStatement)");
        int boolCompSwitch = NPathComplexityRule.sumExpressionComplexity((ASTExpression)node.getFirstChildOfType(ASTExpression.class));
        int npath = 0;
        int caseRange = 0;
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            PLSQLNode n = (PLSQLNode)node.jjtGetChild(i);
            Integer complexity = (Integer)n.jjtAccept(this, data);
            caseRange *= complexity.intValue();
        }
        LOGGER.exiting(CLASS_NAME, "visit(ASTCaseStatement)", boolCompSwitch + (npath += caseRange));
        return boolCompSwitch + npath;
    }

    @Override
    public Object visit(ASTConditionalOrExpression node, Object data) {
        return NumericConstants.ONE;
    }

    public static int sumExpressionComplexity(ASTExpression expr) {
        LOGGER.entering(CLASS_NAME, "visit(ASTExpression)");
        if (expr == null) {
            LOGGER.exiting(CLASS_NAME, "visit(ASTExpression)", 0);
            return 0;
        }
        List andNodes = expr.findDescendantsOfType(ASTConditionalAndExpression.class);
        List orNodes = expr.findDescendantsOfType(ASTConditionalOrExpression.class);
        int children = 0;
        for (AbstractPLSQLNode element : orNodes) {
            children += element.jjtGetNumChildren();
            --children;
        }
        for (AbstractPLSQLNode element : andNodes) {
            children += element.jjtGetNumChildren();
            --children;
        }
        LOGGER.exiting(CLASS_NAME, "visit(ASTExpression)", children);
        return children;
    }

    @Override
    public Object[] getViolationParameters(DataPoint point) {
        return new String[]{((ExecutableCode)point.getNode()).getMethodName(), String.valueOf((int)point.getScore())};
    }
}

