/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.cpd;

import java.io.Reader;
import java.io.StringReader;
import net.sourceforge.pmd.cpd.SourceCode;
import net.sourceforge.pmd.cpd.TokenEntry;
import net.sourceforge.pmd.cpd.Tokenizer;
import net.sourceforge.pmd.cpd.Tokens;
import net.sourceforge.pmd.lang.LanguageRegistry;
import net.sourceforge.pmd.lang.LanguageVersionHandler;
import net.sourceforge.pmd.lang.TokenManager;
import net.sourceforge.pmd.lang.jsp.ast.Token;
import net.sourceforge.pmd.util.IOUtil;
import org.apache.commons.io.IOUtils;

public class JSPTokenizer
implements Tokenizer {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tokenize(SourceCode sourceCode, Tokens tokenEntries) {
        StringBuilder buffer = sourceCode.getCodeBuffer();
        LanguageVersionHandler languageVersionHandler = LanguageRegistry.getLanguage((String)"Java Server Pages").getDefaultVersion().getLanguageVersionHandler();
        Reader reader = null;
        try {
            reader = new StringReader(buffer.toString());
            reader = IOUtil.skipBOM((Reader)reader);
            TokenManager tokenMgr = languageVersionHandler.getParser(languageVersionHandler.getDefaultParserOptions()).getTokenManager(sourceCode.getFileName(), reader);
            Token currentToken = (Token)tokenMgr.getNextToken();
            while (currentToken.image.length() > 0) {
                tokenEntries.add(new TokenEntry(String.valueOf(currentToken.kind), sourceCode.getFileName(), currentToken.beginLine));
                currentToken = (Token)tokenMgr.getNextToken();
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
        tokenEntries.add(TokenEntry.getEOF());
    }
}

