/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.Arrays;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;

public class UnnecessaryCaseChangeRule
extends AbstractJavaRulechainRule {
    private static final List<String> CASE_CHANGING_METHODS = Arrays.asList("toLowerCase", "toUpperCase");
    private static final List<String> EQUALITY_METHODS = Arrays.asList("equals", "equalsIgnoreCase");

    public UnnecessaryCaseChangeRule() {
        super(ASTMethodCall.class, new Class[0]);
    }

    public Object visit(ASTMethodCall node, Object data) {
        if (EQUALITY_METHODS.contains(node.getMethodName()) && node.getArguments().size() == 1 && (this.isCaseChangingMethodCall(node.getQualifier()) || this.isCaseChangingMethodCall((ASTExpression)node.getArguments().get(0)))) {
            this.asCtx(data).addViolation((Node)node);
        }
        return data;
    }

    private boolean isCaseChangingMethodCall(ASTExpression expr) {
        if (expr instanceof ASTMethodCall) {
            ASTMethodCall call = (ASTMethodCall)expr;
            return CASE_CHANGING_METHODS.contains(call.getMethodName()) && call.getArguments().size() == 0;
        }
        return false;
    }
}

