/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.symbols;

import java.util.List;
import net.sourceforge.pmd.lang.java.symbols.JClassSymbol;
import net.sourceforge.pmd.util.CollectionUtil;
import org.apache.commons.lang3.ArrayUtils;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public interface SymbolResolver {
    public @Nullable JClassSymbol resolveClassFromBinaryName(@NonNull String var1);

    default public @Nullable JClassSymbol resolveClassFromCanonicalName(@NonNull String canonicalName) {
        JClassSymbol symbol = this.resolveClassFromBinaryName(canonicalName);
        if (symbol != null) {
            return symbol;
        }
        int lastDotIdx = canonicalName.lastIndexOf(46);
        if (lastDotIdx < 0) {
            return null;
        }
        JClassSymbol outer = this.resolveClassFromCanonicalName(canonicalName.substring(0, lastDotIdx));
        if (outer != null) {
            String innerName = canonicalName.substring(lastDotIdx + 1);
            return outer.getDeclaredClass(innerName);
        }
        return null;
    }

    public static SymbolResolver layer(final SymbolResolver first, final SymbolResolver ... others) {
        if (!2.$assertionsDisabled && first == null) {
            throw new AssertionError((Object)"Null first table");
        }
        if (!2.$assertionsDisabled && others == null) {
            throw new AssertionError((Object)"Null array");
        }
        if (!2.$assertionsDisabled && ArrayUtils.contains((Object[])others, null)) {
            throw new AssertionError((Object)"Null component");
        }
        return new SymbolResolver(){
            private final List<SymbolResolver> stack;
            {
                this.stack = CollectionUtil.listOf((Object)first, (Object[])others);
            }

            @Override
            public @Nullable JClassSymbol resolveClassFromBinaryName(@NonNull String binaryName) {
                for (SymbolResolver resolver : this.stack) {
                    JClassSymbol sym = resolver.resolveClassFromBinaryName(binaryName);
                    if (sym == null) continue;
                    return sym;
                }
                return null;
            }

            @Override
            public void logStats() {
                this.stack.forEach(SymbolResolver::logStats);
            }
        };
    }

    public void logStats();

    static {
        if (2.$assertionsDisabled) {
            // empty if block
        }
    }
}

