/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.design;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTExecutableDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.lang.java.ast.ASTTypeDeclaration;
import net.sourceforge.pmd.lang.java.ast.JavaNode;
import net.sourceforge.pmd.lang.java.ast.internal.PrettyPrintingUtil;
import net.sourceforge.pmd.lang.java.metrics.JavaMetrics;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.metrics.MetricOptions;
import net.sourceforge.pmd.lang.metrics.MetricsUtil;
import net.sourceforge.pmd.properties.NumericConstraints;
import net.sourceforge.pmd.properties.PropertyBuilder;
import net.sourceforge.pmd.properties.PropertyDescriptor;
import net.sourceforge.pmd.properties.PropertyFactory;
import net.sourceforge.pmd.reporting.RuleContext;
import net.sourceforge.pmd.util.AssertionUtil;

public final class NcssCountRule
extends AbstractJavaRulechainRule {
    private static final PropertyDescriptor<Integer> METHOD_REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"methodReportLevel").desc("NCSS reporting threshold for methods")).require(NumericConstraints.positive())).defaultValue((Object)60)).build();
    private static final PropertyDescriptor<Integer> CLASS_REPORT_LEVEL_DESCRIPTOR = ((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)((PropertyBuilder.GenericPropertyBuilder)PropertyFactory.intProperty((String)"classReportLevel").desc("NCSS reporting threshold for classes")).require(NumericConstraints.positive())).defaultValue((Object)1500)).build();
    private static final PropertyDescriptor<List<JavaMetrics.NcssOption>> NCSS_OPTIONS_DESCRIPTOR;

    public NcssCountRule() {
        super(ASTExecutableDeclaration.class, ASTTypeDeclaration.class);
        this.definePropertyDescriptor(METHOD_REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(CLASS_REPORT_LEVEL_DESCRIPTOR);
        this.definePropertyDescriptor(NCSS_OPTIONS_DESCRIPTOR);
    }

    @Override
    public Object visitJavaNode(JavaNode node, Object data) {
        int methodReportLevel = (Integer)this.getProperty(METHOD_REPORT_LEVEL_DESCRIPTOR);
        int classReportLevel = (Integer)this.getProperty(CLASS_REPORT_LEVEL_DESCRIPTOR);
        MetricOptions ncssOptions = MetricOptions.ofOptions((Collection)((Collection)this.getProperty(NCSS_OPTIONS_DESCRIPTOR)));
        if (node instanceof ASTTypeDeclaration) {
            this.visitTypeDecl((ASTTypeDeclaration)node, classReportLevel, ncssOptions, (RuleContext)data);
        } else if (node instanceof ASTExecutableDeclaration) {
            this.visitMethod((ASTExecutableDeclaration)node, methodReportLevel, ncssOptions, (RuleContext)data);
        } else {
            throw AssertionUtil.shouldNotReachHere((String)"unreachable");
        }
        return data;
    }

    private void visitTypeDecl(ASTTypeDeclaration node, int level, MetricOptions ncssOptions, RuleContext data) {
        if (JavaMetrics.NCSS.supports((Node)node)) {
            int classSize = (Integer)MetricsUtil.computeMetric(JavaMetrics.NCSS, (Node)node, (MetricOptions)ncssOptions);
            int classHighest = (int)MetricsUtil.computeStatistics(JavaMetrics.NCSS, node.getOperations(), (MetricOptions)ncssOptions).getMax();
            if (classSize >= level) {
                Object[] messageParams = new String[]{PrettyPrintingUtil.getPrintableNodeKind(node), node.getSimpleName(), classSize + " (Highest = " + classHighest + ")"};
                this.asCtx(data).addViolation((Node)node, messageParams);
            }
        }
    }

    private void visitMethod(ASTExecutableDeclaration node, int level, MetricOptions ncssOptions, RuleContext data) {
        int methodSize;
        if (JavaMetrics.NCSS.supports((Node)node) && (methodSize = ((Integer)MetricsUtil.computeMetric(JavaMetrics.NCSS, (Node)node, (MetricOptions)ncssOptions)).intValue()) >= level) {
            this.asCtx(data).addViolation((Node)node, (Object[])new String[]{node instanceof ASTMethodDeclaration ? "method" : "constructor", PrettyPrintingUtil.displaySignature(node), "" + methodSize});
        }
    }

    static {
        HashMap<String, JavaMetrics.NcssOption> options = new HashMap<String, JavaMetrics.NcssOption>();
        options.put(JavaMetrics.NcssOption.COUNT_IMPORTS.valueName(), JavaMetrics.NcssOption.COUNT_IMPORTS);
        NCSS_OPTIONS_DESCRIPTOR = ((PropertyBuilder.GenericCollectionPropertyBuilder)PropertyFactory.enumListProperty((String)"ncssOptions", options).desc("Choose options for the computation of Ncss")).emptyDefaultValue().build();
    }
}

