/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.types.internal.infer;

import java.util.ArrayList;
import java.util.Set;
import net.sourceforge.pmd.lang.java.types.JTypeMirror;
import net.sourceforge.pmd.lang.java.types.TypeOps;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceContext;
import net.sourceforge.pmd.lang.java.types.internal.infer.InferenceVar;
import net.sourceforge.pmd.lang.java.types.internal.infer.ResolutionFailedException;

abstract class IncorporationAction {
    final InferenceVar ivar;
    final boolean doApplyToInstVar;

    IncorporationAction(InferenceVar ivar) {
        this(ivar, false);
    }

    IncorporationAction(InferenceVar ivar, boolean doApplyToInstVar) {
        this.ivar = ivar;
        this.doApplyToInstVar = doApplyToInstVar;
    }

    abstract void apply(InferenceContext var1);

    static class PropagateBounds
    extends IncorporationAction {
        private final InferenceVar.BoundKind kind;
        private final JTypeMirror bound;

        PropagateBounds(InferenceVar ivar, InferenceVar.BoundKind kind, JTypeMirror bound) {
            super(ivar);
            this.kind = kind;
            this.bound = bound;
        }

        @Override
        public void apply(InferenceContext ctx) {
            InferenceVar alpha = this.ivar;
            for (JTypeMirror b : alpha.getBounds(this.kind.complement())) {
                if (!(b instanceof InferenceVar)) continue;
                InferenceVar beta = (InferenceVar)b;
                beta.addBound(this.kind, ctx.ground(this.bound));
            }
            if (this.bound instanceof InferenceVar) {
                InferenceVar beta = (InferenceVar)this.bound;
                if (this.kind == InferenceVar.BoundKind.EQ) {
                    beta.adoptAllBounds(alpha);
                    return;
                }
                beta.addBound(this.kind.complement(), alpha);
                for (JTypeMirror b : beta.getBounds(this.kind)) {
                    alpha.addBound(this.kind, b);
                }
            }
        }

        public String toString() {
            return "Propagate bound " + this.kind.format(this.ivar, this.bound);
        }
    }

    static class PropagateAllBounds
    extends IncorporationAction {
        PropagateAllBounds(InferenceVar ivar) {
            super(ivar);
        }

        @Override
        void apply(InferenceContext ctx) {
            for (InferenceVar.BoundKind kind : InferenceVar.BoundKind.values()) {
                for (JTypeMirror bound : new ArrayList<JTypeMirror>(this.ivar.getBounds(kind))) {
                    new PropagateBounds(this.ivar, kind, bound).apply(ctx);
                }
            }
        }

        public String toString() {
            return "Propagate all bounds of " + this.ivar;
        }
    }

    static class SubstituteInst
    extends IncorporationAction {
        private final JTypeMirror inst;

        SubstituteInst(InferenceVar ivar, JTypeMirror inst) {
            super(ivar, true);
            this.inst = inst;
        }

        @Override
        public void apply(InferenceContext ctx) {
            if (this.inst != null) {
                for (InferenceVar freeVar : ctx.getFreeVars()) {
                    freeVar.substBounds(it -> this.ivar.isEquivalentTo((JTypeMirror)it) ? this.inst : it);
                }
                new CheckBound(this.ivar, InferenceVar.BoundKind.EQ, this.inst).apply(ctx);
            }
        }

        public String toString() {
            return "Substitute " + this.ivar + " with " + this.inst;
        }
    }

    static class CheckBound
    extends IncorporationAction {
        private final InferenceVar.BoundKind myKind;
        private final JTypeMirror myBound;

        CheckBound(InferenceVar ivar, InferenceVar.BoundKind kind, JTypeMirror bound) {
            super(ivar);
            this.myKind = kind;
            this.myBound = bound;
        }

        Set<InferenceVar.BoundKind> boundsToCheck() {
            return this.myKind.complementSet(true);
        }

        @Override
        public void apply(InferenceContext ctx) {
            for (InferenceVar.BoundKind k : this.boundsToCheck()) {
                for (JTypeMirror b : this.ivar.getBounds(k)) {
                    if (this.checkBound(b, k, ctx)) continue;
                    throw ResolutionFailedException.incompatibleBound(ctx.logger, this.ivar, this.myKind, this.myBound, k, b);
                }
            }
        }

        private boolean checkBound(JTypeMirror otherBound, InferenceVar.BoundKind otherKind, InferenceContext ctx) {
            int compare = this.myKind.compareTo(otherKind);
            if (compare > 0) {
                return this.checkBound(false, this.myBound, otherBound, ctx);
            }
            if (compare < 0) {
                return this.checkBound(false, otherBound, this.myBound, ctx);
            }
            return this.checkBound(true, this.myBound, otherBound, ctx);
        }

        boolean checkBound(boolean eq, JTypeMirror t, JTypeMirror s, InferenceContext ctx) {
            return eq ? TypeOps.isSameTypeInInference(t, s) : this.checkSubtype(t, s, ctx);
        }

        private boolean checkSubtype(JTypeMirror t, JTypeMirror s, InferenceContext ctx) {
            if (ctx.getSupertypeCheckCache().isCertainlyASubtype(t, s)) {
                return true;
            }
            TypeOps.Convertibility isConvertible = TypeOps.isConvertible(t, s);
            boolean doCache = true;
            if (isConvertible.withUncheckedWarning()) {
                ctx.setNeedsUncheckedConversion();
                doCache = false;
            }
            boolean result = isConvertible.somehow();
            if (doCache && result) {
                ctx.getSupertypeCheckCache().remember(t, s);
            }
            return result;
        }

        public String toString() {
            return "Check " + this.myKind.format(this.ivar, this.myBound);
        }
    }
}

