/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.lang.java.rule.errorprone;

import java.util.OptionalInt;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.pmd.lang.ast.Node;
import net.sourceforge.pmd.lang.java.ast.ASTArgumentList;
import net.sourceforge.pmd.lang.java.ast.ASTArrayAllocation;
import net.sourceforge.pmd.lang.java.ast.ASTAssignableExpr;
import net.sourceforge.pmd.lang.java.ast.ASTExpression;
import net.sourceforge.pmd.lang.java.ast.ASTMethodCall;
import net.sourceforge.pmd.lang.java.ast.TypeNode;
import net.sourceforge.pmd.lang.java.ast.internal.JavaAstUtils;
import net.sourceforge.pmd.lang.java.rule.AbstractJavaRulechainRule;
import net.sourceforge.pmd.lang.java.rule.internal.DataflowPass;
import net.sourceforge.pmd.lang.java.types.TypeTestUtil;
import net.sourceforge.pmd.util.CollectionUtil;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class InvalidLogMessageFormatRule
extends AbstractJavaRulechainRule {
    private static final Pattern PLACEHOLDER_AND_FORMAT_SPECIFIER = Pattern.compile("(\\{})|(%(?:\\d\\$)?(?:\\w+)?(?:\\d+)?(?:\\.\\d+)?\\w)");
    private static final Set<String> SLF4J = CollectionUtil.immutableSetOf((Object)"trace", (Object[])new String[]{"debug", "info", "warn", "error"});
    private static final Set<String> APACHE_SLF4J = CollectionUtil.immutableSetOf((Object)"trace", (Object[])new String[]{"debug", "info", "warn", "error", "fatal", "all"});
    private static final Set<String> STRUCTURED_ARGUMENTS_METHODS = CollectionUtil.immutableSetOf((Object)"a", (Object[])new String[]{"array", "defer", "e", "entries", "f", "fields", "keyValue", "kv", "r", "raw", "v", "value"});

    public InvalidLogMessageFormatRule() {
        super(ASTMethodCall.class, new Class[0]);
    }

    @Override
    public Object visit(ASTMethodCall call, Object data) {
        if (this.isLoggerCall(call, "org.slf4j.Logger", SLF4J) || this.isLoggerCall(call, "org.apache.logging.log4j.Logger", APACHE_SLF4J)) {
            ASTArgumentList args = call.getArguments();
            ASTExpression messageParam = (ASTExpression)args.toStream().first(it -> TypeTestUtil.isA(String.class, (TypeNode)it));
            if (messageParam == null) {
                return null;
            }
            OptionalInt expectedArgs = InvalidLogMessageFormatRule.expectedArguments0(messageParam);
            if (!expectedArgs.isPresent()) {
                return null;
            }
            int expectedArguments = expectedArgs.getAsInt();
            int providedArguments = args.size() - (messageParam.getIndexInParent() + 1);
            if (providedArguments == 1 && JavaAstUtils.isArrayInitializer((ASTExpression)args.getLastChild())) {
                providedArguments = ((ASTArrayAllocation)args.getLastChild()).getArrayInitializer().length();
            } else if (TypeTestUtil.isA(Throwable.class, (TypeNode)args.getLastChild()) && providedArguments > expectedArguments) {
                --providedArguments;
            }
            if (providedArguments > expectedArguments) {
                int removed = this.removePotentialStructuredArguments(providedArguments - expectedArguments, args);
                providedArguments -= removed;
            }
            if (providedArguments < expectedArguments) {
                this.addViolationWithMessage(data, (Node)call, "Missing arguments," + this.getExpectedMessage(providedArguments, expectedArguments));
            } else if (providedArguments > expectedArguments) {
                this.addViolationWithMessage(data, (Node)call, "Too many arguments," + this.getExpectedMessage(providedArguments, expectedArguments));
            }
        }
        return null;
    }

    private boolean isLoggerCall(ASTMethodCall call, String loggerType, Set<String> methodNames) {
        return TypeTestUtil.isA(loggerType, (TypeNode)call.getQualifier()) && methodNames.contains(call.getMethodName());
    }

    private static int countPlaceHolders(@NonNull String constValue) {
        int result = 0;
        Matcher matcher = PLACEHOLDER_AND_FORMAT_SPECIFIER.matcher(constValue);
        while (matcher.find()) {
            String format = matcher.group();
            if ("%%".equals(format) || "%n".equals(format)) continue;
            ++result;
        }
        return result;
    }

    private static OptionalInt expectedArguments0(ASTExpression node) {
        if (node.getConstValue() instanceof String) {
            return OptionalInt.of(InvalidLogMessageFormatRule.countPlaceHolders((String)node.getConstValue()));
        }
        if (node instanceof ASTAssignableExpr.ASTNamedReferenceExpr) {
            DataflowPass.DataflowResult dataflow = DataflowPass.getDataflowResult(node.getRoot());
            DataflowPass.ReachingDefinitionSet reaching = dataflow.getReachingDefinitions((ASTAssignableExpr.ASTNamedReferenceExpr)node);
            if (reaching.isNotFullyKnown()) {
                return OptionalInt.empty();
            }
            DataflowPass.AssignmentEntry assignment = (DataflowPass.AssignmentEntry)CollectionUtil.asSingle(reaching.getReaching());
            if (assignment == null) {
                return OptionalInt.empty();
            }
            ASTExpression rhs = assignment.getRhsAsExpression();
            if (rhs != null && rhs.getConstValue() instanceof String) {
                return OptionalInt.of(InvalidLogMessageFormatRule.countPlaceHolders((String)rhs.getConstValue()));
            }
        }
        return OptionalInt.empty();
    }

    private String getExpectedMessage(int providedArguments, int expectedArguments) {
        return " expected " + expectedArguments + (expectedArguments > 1 ? " arguments " : " argument ") + "but found " + providedArguments;
    }

    private int removePotentialStructuredArguments(int maxArgumentsToRemove, ASTArgumentList argumentList) {
        ASTExpression argument;
        int removed = 0;
        int lastIndex = argumentList.size() - 1;
        while (argumentList.size() > 0 && removed < maxArgumentsToRemove && this.isStructuredArgumentMethodCall(argument = (ASTExpression)argumentList.get(lastIndex))) {
            ++removed;
            --lastIndex;
        }
        return removed;
    }

    private boolean isStructuredArgumentMethodCall(ASTExpression argument) {
        if (argument instanceof ASTMethodCall) {
            ASTMethodCall methodCall = (ASTMethodCall)argument;
            @Nullable ASTExpression qualifier = methodCall.getQualifier();
            return TypeTestUtil.isA("net.logstash.logback.argument.StructuredArguments", (TypeNode)qualifier) || STRUCTURED_ARGUMENTS_METHODS.contains(methodCall.getMethodName());
        }
        return false;
    }
}

